/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbattery;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.CCItems;
import com.hlysine.create_connected.content.kineticbattery.KineticBatteryBlockEntity;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public class KineticBatteryBlock
extends DirectionalKineticBlock
implements IBE<KineticBatteryBlockEntity> {
    public static final IntegerProperty LEVEL = IntegerProperty.m_61631_((String)"level", (int)0, (int)5);
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;

    public KineticBatteryBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED, LEVEL});
        super.m_7926_(builder);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        if (context.m_43723_() != null && context.m_43723_().m_6144_()) {
            return super.m_5573_(context);
        }
        Direction preferredDirection = this.getPreferredFacing(context);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)(preferredDirection == null ? context.m_7820_() : preferredDirection))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(context.m_43725_().m_276867_(context.m_8083_())))).m_61124_((Property)LEVEL, (Comparable)Integer.valueOf(0));
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        ItemStack stack = player.m_21120_(hand);
        boolean doNotConsume = player.m_7500_();
        boolean forceInsert = !(player instanceof FakePlayer);
        InteractionResultHolder<ItemStack> res = KineticBatteryBlock.tryInsert(state, level, pos, stack, doNotConsume, forceInsert, false);
        ItemStack leftover = (ItemStack)res.m_19095_();
        if (!(level.f_46443_ || doNotConsume || leftover.m_41619_())) {
            if (stack.m_41619_()) {
                player.m_21008_(hand, leftover);
            } else if (!player.m_150109_().m_36054_(leftover)) {
                player.m_36176_(leftover, false);
            }
        }
        return res.m_19089_() == InteractionResult.SUCCESS ? InteractionResult.SUCCESS : InteractionResult.PASS;
    }

    public static InteractionResultHolder<ItemStack> tryInsert(BlockState state, Level world, BlockPos pos, ItemStack stack, boolean doNotConsume, boolean forceInsert, boolean simulate) {
        ItemStack returnedItem;
        if (stack.m_41619_()) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        if (!state.m_155947_()) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        BlockEntity be = world.m_7702_(pos);
        if (!(be instanceof KineticBatteryBlockEntity)) {
            return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
        }
        KineticBatteryBlockEntity batteryBE = (KineticBatteryBlockEntity)be;
        if (KineticBatteryBlock.isDischarging(state)) {
            if (!stack.m_150930_(CCItems.CHARGED_KINETIC_BATTERY.m_5456_())) {
                return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
            }
            if (forceInsert && (Integer)state.m_61143_((Property)LEVEL) == 5) {
                return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
            }
            if (!forceInsert && batteryBE.getBatteryLevel() > 72000.0) {
                return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
            }
            if (!simulate) {
                batteryBE.setBatteryLevel(KineticBatteryBlockEntity.getMaxBatteryLevel());
            }
            returnedItem = CCBlocks.KINETIC_BATTERY.asStack();
        } else {
            if (!stack.m_150930_(CCBlocks.KINETIC_BATTERY.m_5456_())) {
                return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
            }
            if ((Integer)state.m_61143_((Property)LEVEL) < 5) {
                return InteractionResultHolder.m_19100_((Object)ItemStack.f_41583_);
            }
            if (!simulate) {
                batteryBE.setBatteryLevel(0.0);
            }
            returnedItem = CCItems.CHARGED_KINETIC_BATTERY.asStack();
        }
        if (!doNotConsume) {
            if (!world.f_46443_) {
                stack.m_41774_(1);
            }
            return InteractionResultHolder.m_19090_((Object)returnedItem);
        }
        return InteractionResultHolder.m_19090_((Object)ItemStack.f_41583_);
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).m_122434_();
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.m_122434_() == this.getRotationAxis(state);
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        if (oldState.m_61143_((Property)FACING) != newState.m_61143_((Property)FACING)) {
            return false;
        }
        if (KineticBatteryBlock.isDischarging(oldState) != KineticBatteryBlock.isDischarging(newState)) {
            return false;
        }
        return KineticBatteryBlock.isCurrentStageComplete(oldState) == KineticBatteryBlock.isCurrentStageComplete(newState);
    }

    public void m_6861_(@NotNull BlockState state, Level worldIn, @NotNull BlockPos pos, @NotNull Block blockIn, @NotNull BlockPos fromPos, boolean isMoving) {
        if (worldIn.f_46443_) {
            return;
        }
        boolean previouslyPowered = (Boolean)state.m_61143_((Property)POWERED);
        if (previouslyPowered != worldIn.m_276867_(pos)) {
            KineticBlockEntity.switchToBlockState((Level)worldIn, (BlockPos)pos, (BlockState)((BlockState)state.m_61122_((Property)POWERED)));
        }
    }

    public boolean m_7278_(@NotNull BlockState state) {
        return true;
    }

    public int m_6782_(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos) {
        return this.getBlockEntityOptional((BlockGetter)world, pos).map(be -> be.getCrudeBatteryLevel(15)).orElse(0);
    }

    @NotNull
    public ItemStack getCloneItemStack(BlockState state, @NotNull HitResult target, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Player player) {
        if ((Integer)state.m_61143_((Property)LEVEL) == 5) {
            return CCItems.CHARGED_KINETIC_BATTERY.asStack();
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public static boolean isDischarging(BlockState state) {
        return (Boolean)state.m_61143_((Property)POWERED);
    }

    public static boolean isCurrentStageComplete(BlockState state) {
        if (KineticBatteryBlock.isDischarging(state)) {
            return (Integer)state.m_61143_((Property)LEVEL) == 0;
        }
        return (Integer)state.m_61143_((Property)LEVEL) == 5;
    }

    public Class<KineticBatteryBlockEntity> getBlockEntityClass() {
        return KineticBatteryBlockEntity.class;
    }

    public BlockEntityType<? extends KineticBatteryBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.KINETIC_BATTERY.get();
    }
}

