/*
 * Decompiled with CFR 0.152.
 */
package net.createcobblestone.blocks;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import net.createcobblestone.CreateCobblestoneMod;
import net.createcobblestone.data.GeneratorType;
import net.createcobblestone.index.Config;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class MechanicalGeneratorBlockEntity
extends KineticBlockEntity
implements Container {
    final NonNullList<ItemStack> items = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);
    private final int size = 1;
    private double available = 0.0;
    public GeneratorType type = GeneratorType.NONE;

    public MechanicalGeneratorBlockEntity(BlockEntityType<? extends MechanicalGeneratorBlockEntity> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
        if (this.type == null) {
            throw new IllegalStateException("Generator type cannot be null (GeneratorTypes not initialized but mechanicalGeneratorBlockEntity created)");
        }
    }

    protected void write(CompoundTag compound, boolean clientPacket) {
        super.write(compound, clientPacket);
        compound.m_128359_("type", this.type.getId());
    }

    protected void read(CompoundTag compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        try {
            this.updateType(GeneratorType.fromId(compound.m_128461_("type")));
        }
        catch (IllegalArgumentException e) {
            CreateCobblestoneMod.LOGGER.error("Invalid generator type \"{}\", setting type to NONE", (Object)compound.m_128461_("type"));
            this.type = GeneratorType.NONE;
            this.m_6596_();
        }
    }

    public int m_6643_() {
        return this.size;
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)index, (int)count);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
        }
        return itemstack;
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
        this.m_6596_();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public void m_6211_() {
        this.items.clear();
    }

    public void tick() {
        Block generatorBlock;
        super.tick();
        try {
            generatorBlock = this.type.getBlock();
            if (!Config.common().isEnabled(this.type)) {
                this.updateType(GeneratorType.NONE);
                return;
            }
        }
        catch (NullPointerException e) {
            if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
                CreateCobblestoneMod.LOGGER.error("Tried accessing generator block before world was loaded");
            }
            return;
        }
        if (generatorBlock != Blocks.f_50016_) {
            if (!this.type.isLoaded()) {
                this.updateType(GeneratorType.NONE);
                return;
            }
            if (this.available < (double)this.type.getStorage()) {
                this.available = Math.min(this.available + (double)(Math.abs(this.getSpeed() * this.type.getOutputPerSecondPerRpm()) / 20.0f), (double)this.type.getStorage());
            }
            int current = ((ItemStack)this.items.get(0)).m_41613_();
            int added = (int)this.available;
            this.available -= (double)added;
            this.items.set(0, (Object)new ItemStack((ItemLike)generatorBlock, Math.min(current + added, this.type.getStorage())));
        }
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)this.type.getGeneratorStress();
        return impact;
    }

    public void updateType(GeneratorType newType) {
        if (newType == null) {
            if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
                CreateCobblestoneMod.LOGGER.error("Attempted to update generator type to null");
            }
            return;
        }
        if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
            CreateCobblestoneMod.LOGGER.info("Trying to update generator type from \"{}\" to \"{}\"", (Object)this.type.getId(), (Object)newType.getId());
        }
        if (!Config.common().isEnabled(newType)) {
            if (!Config.common().isEnabled(this.type)) {
                newType = GeneratorType.NONE;
            } else {
                CreateCobblestoneMod.LOGGER.error("Disabled generator type \"{}\", not changing old generator type. ({})", (Object)newType.getId(), (Object)this.type.getId());
                return;
            }
        }
        if (((Boolean)Config.common().enableDebugLogging.get()).booleanValue()) {
            CreateCobblestoneMod.LOGGER.info("Changing generator type from \"{}\" to \"{}\"", (Object)this.type.getId(), (Object)newType.getId());
        }
        this.type = newType;
        this.available = 0.0;
        this.items.clear();
        this.m_6596_();
    }
}

