/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.compat.computercraft;

import com.jesz.createdieselgenerators.compat.computercraft.peripherals.ChemicalTurretPeripheral;
import com.jesz.createdieselgenerators.content.turret.ChemicalTurretBlockEntity;
import com.simibubi.create.compat.computercraft.AbstractComputerBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import dan200.computercraft.api.peripheral.IPeripheral;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.registries.ForgeRegistries;

public class ComputerBehaviour
extends AbstractComputerBehaviour {
    protected static final Capability<IPeripheral> PERIPHERAL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPeripheral>(){});
    LazyOptional<IPeripheral> peripheral;
    NonNullSupplier<IPeripheral> peripheralSupplier;

    public ComputerBehaviour(SmartBlockEntity be) {
        super(be);
        this.peripheralSupplier = ComputerBehaviour.getPeripheralFor(be);
    }

    public static NonNullSupplier<IPeripheral> getPeripheralFor(SmartBlockEntity be) {
        if (be instanceof ChemicalTurretBlockEntity) {
            ChemicalTurretBlockEntity ctbe = (ChemicalTurretBlockEntity)be;
            return () -> new ChemicalTurretPeripheral(ctbe);
        }
        throw new IllegalArgumentException("No peripheral available for " + ForgeRegistries.BLOCK_ENTITY_TYPES.getKey((Object)be.m_58903_()));
    }

    public <T> boolean isPeripheralCap(Capability<T> cap) {
        return cap == PERIPHERAL_CAPABILITY;
    }

    public <T> LazyOptional<T> getPeripheralCapability() {
        if (this.peripheral == null || !this.peripheral.isPresent()) {
            this.peripheral = LazyOptional.of(this.peripheralSupplier);
        }
        return this.peripheral.cast();
    }

    public void removePeripheral() {
        if (this.peripheral != null) {
            this.peripheral.invalidate();
        }
    }
}

