/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.MeshTrap;

import com.adonis.createfisheryindustry.block.MeshTrap.MeshTrapBlock;
import com.adonis.createfisheryindustry.block.common.TrapBlockEntity;
import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlockEntities;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.belt.behaviour.TransportedItemStackHandlerBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.utility.CreateLang;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MeshTrapBlockEntity
extends TrapBlockEntity
implements IHaveGoggleInformation {
    protected static final int PROCESSING_TIME = 10;
    protected static final double ENTITY_KILL_RANGE = 1.0;
    private static final double MAX_COLLISION_BOX_SIZE = 0.8;
    private static final int AUTO_EXPORT_COOLDOWN = 20;
    private int autoExportTicks = 0;
    private static final int BELT_EXTRACTION_COOLDOWN = 5;
    private int beltExtractionTicks = 0;
    private final Map<Direction, TransportedItemStackHandlerBehaviour> beltHandlers = new HashMap<Direction, TransportedItemStackHandlerBehaviour>();
    private final IItemHandler insertionHandler = new InsertionOnlyItemHandler((IItemHandler)this.inventory);
    private final IItemHandler extractionHandler = new ExtractionOnlyItemHandler((IItemHandler)this.inventory);

    public MeshTrapBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)CreateFisheryBlockEntities.MESH_TRAP.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MeshTrapBlockEntity be) {
        if (level.m_5776_()) {
            return;
        }
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ++be.processingTicks;
        if (be.processingTicks >= 10) {
            be.processingTicks = 0;
            be.collectNearbyItems(serverLevel);
            be.tryProcessEntities(serverLevel);
            be.m_6596_();
            be.sendData();
            serverLevel.m_7260_(pos, state, state, 3);
        }
        ++be.autoExportTicks;
        if (be.autoExportTicks >= 20) {
            be.autoExportTicks = 0;
            be.tryExportItems(serverLevel);
        }
        ++be.beltExtractionTicks;
        if (be.beltExtractionTicks >= 5) {
            be.beltExtractionTicks = 0;
            be.extractItemsFromBelts(serverLevel);
        }
        be.tick();
    }

    protected void extractItemsFromBelts(ServerLevel level) {
        if (level == null || level.m_5776_()) {
            return;
        }
        this.updateBeltHandlers(level);
        for (Direction direction : Direction.values()) {
            TransportedItemStackHandlerBehaviour handler;
            if (direction == Direction.UP || direction == Direction.DOWN || (handler = this.beltHandlers.get(direction)) == null) continue;
            this.extractFromBelt(handler);
        }
    }

    private void updateBeltHandlers(ServerLevel level) {
        this.beltHandlers.clear();
        for (Direction direction : Direction.values()) {
            BlockPos neighborPos;
            BlockEntity blockEntity;
            if (direction == Direction.UP || direction == Direction.DOWN || !((blockEntity = level.m_7702_(neighborPos = this.m_58899_().m_121945_(direction))) instanceof SmartBlockEntity)) continue;
            SmartBlockEntity smartBE = (SmartBlockEntity)blockEntity;
            TransportedItemStackHandlerBehaviour behaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)neighborPos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (behaviour == null) continue;
            this.beltHandlers.put(direction, behaviour);
        }
    }

    private void extractFromBelt(TransportedItemStackHandlerBehaviour beltHandler) {
        boolean hasSpace = false;
        for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
            if (!this.inventory.getStackInSlot(slot).m_41619_()) continue;
            hasSpace = true;
            break;
        }
        if (!hasSpace) {
            return;
        }
        beltHandler.handleCenteredProcessingOnAllItems(0.5f, transportedItem -> {
            ItemStack stack = transportedItem.stack;
            if (stack.m_41619_()) {
                return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
            }
            ItemStack remaining = stack.m_41777_();
            boolean anyInserted = false;
            for (int slot = 0; slot < this.inventory.getSlots(); ++slot) {
                ItemStack toInsert;
                ItemStack slotStack = this.inventory.getStackInSlot(slot);
                if (!slotStack.m_41619_() && (!ItemStack.m_41656_((ItemStack)slotStack, (ItemStack)remaining) || slotStack.m_41613_() >= slotStack.m_41741_()) || (remaining = this.inventory.insertItem(slot, toInsert = remaining.m_41777_(), false)).m_41613_() >= toInsert.m_41613_()) continue;
                anyInserted = true;
                if (remaining.m_41619_()) break;
            }
            if (anyInserted) {
                this.m_6596_();
                this.sendData();
                Level patt7642$temp = this.f_58857_;
                if (patt7642$temp instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)patt7642$temp;
                    serverLevel.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
                }
                if (remaining.m_41619_()) {
                    return TransportedItemStackHandlerBehaviour.TransportedResult.removeItem();
                }
                TransportedItemStack newTransportedItem = new TransportedItemStack(remaining);
                newTransportedItem.prevBeltPosition = transportedItem.prevBeltPosition;
                newTransportedItem.beltPosition = transportedItem.beltPosition;
                newTransportedItem.insertedFrom = transportedItem.insertedFrom;
                newTransportedItem.insertedAt = transportedItem.insertedAt;
                return TransportedItemStackHandlerBehaviour.TransportedResult.convertTo((TransportedItemStack)newTransportedItem);
            }
            return TransportedItemStackHandlerBehaviour.TransportedResult.doNothing();
        });
    }

    protected void tryExportItems(ServerLevel level) {
        if (level == null || level.m_5776_()) {
            return;
        }
        boolean anyItemMoved = false;
        for (Direction direction : Direction.values()) {
            IItemHandler targetInventory;
            LazyOptional capability;
            BlockPos neighborPos = this.m_58899_().m_121945_(direction);
            TransportedItemStackHandlerBehaviour beltBehaviour = (TransportedItemStackHandlerBehaviour)BlockEntityBehaviour.get((BlockGetter)level, (BlockPos)neighborPos, (BehaviourType)TransportedItemStackHandlerBehaviour.TYPE);
            if (beltBehaviour != null || level.m_7702_(neighborPos) instanceof MeshTrapBlockEntity) continue;
            LazyOptional lazyOptional = capability = level.m_7702_(neighborPos) != null ? level.m_7702_(neighborPos).getCapability(ForgeCapabilities.ITEM_HANDLER, direction.m_122424_()) : LazyOptional.empty();
            if (!capability.isPresent() || (targetInventory = (IItemHandler)capability.orElse(null)) == null) continue;
            for (int sourceSlot = 0; sourceSlot < this.inventory.getSlots(); ++sourceSlot) {
                ItemStack extractedItem;
                ItemStack stackInSlot = this.inventory.getStackInSlot(sourceSlot);
                if (stackInSlot.m_41619_() || (extractedItem = this.inventory.extractItem(sourceSlot, stackInSlot.m_41613_(), true)).m_41619_()) continue;
                ItemStack remainingItem = this.insertItemIntoTarget(extractedItem, targetInventory);
                int actualExtractAmount = extractedItem.m_41613_() - remainingItem.m_41613_();
                if (actualExtractAmount <= 0) continue;
                this.inventory.extractItem(sourceSlot, actualExtractAmount, false);
                anyItemMoved = true;
                break;
            }
            if (anyItemMoved) break;
        }
        if (anyItemMoved) {
            this.m_6596_();
            this.sendData();
            level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
        }
    }

    private ItemStack insertItemIntoTarget(ItemStack stack, IItemHandler targetInventory) {
        ItemStack remaining = stack.m_41777_();
        for (int slot = 0; slot < targetInventory.getSlots() && !remaining.m_41619_(); ++slot) {
            remaining = targetInventory.insertItem(slot, remaining, false);
        }
        return remaining;
    }

    protected void tryProcessEntities(ServerLevel level) {
        CreateFisheryCommonConfig.refreshCache();
        AABB boundingBox = new AABB(this.m_58899_()).m_82400_(1.0);
        List entities = level.m_45976_(Entity.class, boundingBox);
        for (Entity entity : entities) {
            EntityType entityType;
            ResourceLocation entityId;
            if (!(entity instanceof Mob)) continue;
            Mob mob = (Mob)entity;
            if (!entity.m_6084_() || CreateFisheryCommonConfig.isEntityBlacklisted(entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)(entityType = entity.m_6095_())))) continue;
            if (CreateFisheryCommonConfig.isEntityWhitelisted(entityId)) {
                this.processEntityDrops(level, mob);
                continue;
            }
            AABB collisionBox = entity.m_20191_();
            double width = collisionBox.m_82362_();
            double height = collisionBox.m_82376_();
            double depth = collisionBox.m_82385_();
            if (!(width <= 0.8) || !(height <= 0.8) || !(depth <= 0.8)) continue;
            this.processEntityDrops(level, mob);
        }
    }

    private void processEntityDrops(ServerLevel level, Mob mob) {
        Player nearestPlayer;
        ResourceLocation lootTableKey = mob.m_5743_();
        if (lootTableKey == null) {
            return;
        }
        LootParams.Builder paramsBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)mob).m_287286_(LootContextParams.f_81460_, (Object)mob.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)level.m_269111_().m_269264_());
        List players = level.m_7654_().m_6846_().m_11314_();
        if (!players.isEmpty() && (nearestPlayer = level.m_45930_((Entity)mob, -1.0)) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)nearestPlayer;
            paramsBuilder.m_287286_(LootContextParams.f_81456_, (Object)serverPlayer);
        }
        LootParams params = paramsBuilder.m_287235_(LootContextParamSets.f_81415_);
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableKey);
        ObjectArrayList loots = lootTable.m_287195_(params);
        boolean allInserted = true;
        for (ItemStack stack : loots) {
            ItemStack remainder = stack.m_41777_();
            for (int i = 0; i < this.inventory.getSlots() && !(remainder = this.inventory.insertItem(i, remainder, false)).m_41619_(); ++i) {
            }
            if (remainder.m_41619_()) continue;
            ItemEntity itemEntity = new ItemEntity((Level)level, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), remainder);
            level.m_7967_((Entity)itemEntity);
            allInserted = false;
        }
        boolean inWater = (Boolean)this.m_58900_().m_61143_((Property)MeshTrapBlock.WATERLOGGED);
        SimpleParticleType particleType = inWater ? ParticleTypes.f_123795_ : ParticleTypes.f_123796_;
        level.m_8767_((ParticleOptions)particleType, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_(), 15, 0.5, 0.5, 0.5, 0.1);
        level.m_5594_(null, new BlockPos((int)mob.m_20185_(), (int)mob.m_20186_(), (int)mob.m_20189_()), SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
        Item expNuggetItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create", "experience_nugget"));
        if (expNuggetItem != null && expNuggetItem != ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "air"))) {
            ItemStack expNugget = new ItemStack((ItemLike)expNuggetItem, 1);
            ItemStack remainder = expNugget.m_41777_();
            for (int i = 0; i < this.inventory.getSlots() && !(remainder = this.inventory.insertItem(i, remainder, false)).m_41619_(); ++i) {
            }
            if (!remainder.m_41619_()) {
                ItemEntity itemEntity = new ItemEntity((Level)level, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), remainder);
                level.m_7967_((Entity)itemEntity);
            }
        }
        mob.m_142467_(Entity.RemovalReason.KILLED);
        this.m_6596_();
        this.sendData();
        level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        CreateLang.translate((String)"gui.goggles.mesh_trap_contents", (Object[])new Object[0]).forGoggles(tooltip);
        ItemStackHandler inv = this.getInventory();
        boolean isEmpty = true;
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            isEmpty = false;
            CreateLang.text((String)"").add(Component.m_237115_((String)stack.m_41778_()).m_130940_(ChatFormatting.GRAY)).add(CreateLang.text((String)(" x" + stack.m_41613_())).style(ChatFormatting.GREEN)).forGoggles(tooltip, 1);
        }
        if (isEmpty) {
            CreateLang.translate((String)"gui.goggles.inventory.empty", (Object[])new Object[0]).forGoggles(tooltip, 1);
        }
        return true;
    }

    @Override
    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return LazyOptional.of(() -> this.inventory).cast();
        }
        return super.getCapability(cap, side);
    }

    private static class InsertionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public InsertionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return this.wrapped.insertItem(slot, stack, simulate);
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }

    private static class ExtractionOnlyItemHandler
    implements IItemHandler {
        private final IItemHandler wrapped;

        public ExtractionOnlyItemHandler(IItemHandler wrapped) {
            this.wrapped = wrapped;
        }

        public int getSlots() {
            return this.wrapped.getSlots();
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return this.wrapped.getStackInSlot(slot);
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            return stack;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.wrapped.extractItem(slot, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.wrapped.getSlotLimit(slot);
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return this.wrapped.isItemValid(slot, stack);
        }
    }
}

