/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.block.common;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TrapBlockEntity
extends BlockEntity {
    public static final int INVENTORY_SLOTS = 9;
    protected static final double COLLECTION_RANGE = 1.5;
    protected static final double FISH_PROCESSING_RANGE = 1.5;
    protected final ItemStackHandler inventory = this.createInventory();
    protected int processingTicks = 0;
    protected int syncCooldown = 0;
    protected boolean queuedSync = false;
    private static final int SYNC_RATE = 8;
    private final LazyOptional<IItemHandler> inventoryOptional = LazyOptional.of(() -> this.inventory);

    public TrapBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    protected ItemStackHandler createInventory() {
        return new ItemStackHandler(9){

            protected void onContentsChanged(int slot) {
                TrapBlockEntity.this.m_6596_();
                if (TrapBlockEntity.this.f_58857_ != null && !TrapBlockEntity.this.f_58857_.m_5776_()) {
                    TrapBlockEntity.this.f_58857_.m_7260_(TrapBlockEntity.this.f_58858_, TrapBlockEntity.this.m_58900_(), TrapBlockEntity.this.m_58900_(), 3);
                    TrapBlockEntity.this.sendData();
                }
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return true;
            }
        };
    }

    public ItemStackHandler getInventory() {
        return this.inventory;
    }

    public boolean insertItem(ItemStack stack) {
        boolean partialSuccess;
        if (stack.m_41619_() || this.f_58857_ == null || this.f_58857_.m_5776_()) {
            return false;
        }
        ItemStack remainder = stack.m_41777_();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (!(remainder = this.inventory.insertItem(i, remainder, false)).m_41619_()) continue;
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.sendData();
            return true;
        }
        boolean bl = partialSuccess = stack.m_41613_() != remainder.m_41613_();
        if (partialSuccess) {
            this.m_6596_();
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.sendData();
        }
        return partialSuccess;
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        CompoundTag inventoryTag = this.inventory.serializeNBT();
        tag.m_128365_("Inventory", (Tag)inventoryTag);
        tag.m_128405_("ProcessingTicks", this.processingTicks);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Inventory")) {
            CompoundTag inventoryTag = tag.m_128469_("Inventory");
            this.inventory.deserializeNBT(inventoryTag);
        }
        this.processingTicks = tag.m_128451_("ProcessingTicks");
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.m_183515_(tag);
        return tag;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        super.onDataPacket(net, pkt);
        this.handleUpdateTag(pkt.m_131708_());
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.inventoryOptional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.inventoryOptional.invalidate();
    }

    protected void collectNearbyItems(ServerLevel level) {
        if (level == null || level.m_5776_()) {
            return;
        }
        AABB boundingBox = new AABB(this.m_58899_()).m_82400_(1.5);
        List items = level.m_45976_(ItemEntity.class, boundingBox);
        for (ItemEntity itemEntity : items) {
            ItemStack stack;
            if (itemEntity == null || !itemEntity.m_6084_() || (stack = itemEntity.m_32055_()).m_41619_()) continue;
            ItemStack copy = stack.m_41777_();
            if (this.insertItem(copy)) {
                itemEntity.m_146870_();
                continue;
            }
            if (copy.m_41613_() >= stack.m_41613_()) continue;
            itemEntity.m_32045_(copy);
        }
    }

    protected void tryProcessFish(ServerLevel level) {
        if (level == null || level.m_5776_()) {
            return;
        }
        AABB boundingBox = new AABB(this.m_58899_()).m_82400_(1.5);
        List entities = level.m_45976_(Entity.class, boundingBox);
        for (Entity entity : entities) {
            Mob mob;
            boolean isAquatic;
            if (entity == null || !entity.m_6084_() || !(isAquatic = entity instanceof WaterAnimal || entity.m_6095_() == EntityType.f_20556_ || entity.m_6095_() == EntityType.f_20519_ || entity.m_6095_() == EntityType.f_20489_ || entity.m_6095_() == EntityType.f_20516_) || !(entity instanceof Mob) || !((mob = (Mob)entity).m_21233_() < 10.0f)) continue;
            try {
                mob.m_6469_(level.m_269111_().m_269264_(), mob.m_21233_() * 2.0f);
                entity.m_146870_();
            }
            catch (Exception exception) {}
        }
    }

    public void dropInventory() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Vec3 pos = Vec3.m_82512_((Vec3i)this.f_58858_);
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_()) continue;
                ItemEntity itemEntity = new ItemEntity(this.f_58857_, pos.f_82479_, pos.f_82480_, pos.f_82481_, stack);
                serverLevel.m_7967_((Entity)itemEntity);
                this.inventory.setStackInSlot(i, ItemStack.f_41583_);
            }
        }
    }

    public void sendData() {
        if (this.syncCooldown > 0) {
            this.queuedSync = true;
            return;
        }
        if (this.f_58857_ != null && !this.f_58857_.f_46443_) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
            this.m_6596_();
        }
        this.queuedSync = false;
        this.syncCooldown = 8;
    }

    public void tick() {
        if (this.syncCooldown > 0) {
            --this.syncCooldown;
            if (this.syncCooldown == 0 && this.queuedSync) {
                this.sendData();
            }
        }
    }
}

