/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.event;

import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.registry.CreateFisheryBlocks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="createfisheryindustry")
public class MeshTrapInteractionHandler {
    private static final double MAX_COLLISION_BOX_SIZE = 0.8;

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        Mob mob;
        Level level;
        Player player = event.getEntity();
        ItemStack heldItem = player.m_21205_();
        Entity target = event.getTarget();
        if (!heldItem.m_150930_(CreateFisheryBlocks.MESH_TRAP.m_5456_())) {
            return;
        }
        if (player.m_9236_().m_5776_() || !((level = player.m_9236_()) instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (!(target instanceof Mob) || !(mob = (Mob)target).m_6084_()) {
            return;
        }
        if (!MeshTrapInteractionHandler.canCaptureEntity(mob)) {
            return;
        }
        MeshTrapInteractionHandler.processEntityDrops(serverLevel, mob, player);
        mob.m_142467_(Entity.RemovalReason.KILLED);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            serverPlayer.m_21011_(InteractionHand.MAIN_HAND, true);
        }
        SimpleParticleType particleType = ParticleTypes.f_123796_;
        serverLevel.m_8767_((ParticleOptions)particleType, mob.m_20185_(), mob.m_20186_() + 0.5, mob.m_20189_(), 15, 0.5, 0.5, 0.5, 0.1);
        serverLevel.m_5594_(null, mob.m_20183_(), SoundEvents.f_11782_, SoundSource.BLOCKS, 1.0f, 1.0f);
        event.setCanceled(true);
    }

    private static boolean canCaptureEntity(Mob mob) {
        CreateFisheryCommonConfig.refreshCache();
        EntityType entityType = mob.m_6095_();
        ResourceLocation entityId = ForgeRegistries.ENTITY_TYPES.getKey((Object)entityType);
        if (CreateFisheryCommonConfig.isEntityBlacklisted(entityId)) {
            return false;
        }
        if (CreateFisheryCommonConfig.isEntityWhitelisted(entityId)) {
            return true;
        }
        AABB collisionBox = mob.m_20191_();
        double width = collisionBox.m_82362_();
        double height = collisionBox.m_82376_();
        double depth = collisionBox.m_82385_();
        return width <= 0.8 && height <= 0.8 && depth <= 0.8;
    }

    private static void processEntityDrops(ServerLevel level, Mob mob, Player player) {
        ResourceLocation lootTableKey = mob.m_5743_();
        if (lootTableKey == null) {
            return;
        }
        LootParams.Builder paramsBuilder = new LootParams.Builder(level).m_287286_(LootContextParams.f_81455_, (Object)mob).m_287286_(LootContextParams.f_81460_, (Object)mob.m_20182_()).m_287286_(LootContextParams.f_81457_, (Object)level.m_269111_().m_269264_());
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            paramsBuilder.m_287286_(LootContextParams.f_81456_, (Object)serverPlayer);
        }
        LootParams params = paramsBuilder.m_287235_(LootContextParamSets.f_81415_);
        LootTable lootTable = level.m_7654_().m_278653_().m_278676_(lootTableKey);
        ObjectArrayList loots = lootTable.m_287195_(params);
        for (ItemStack stack : loots) {
            ItemStack remainder = stack.m_41777_();
            if (player.m_150109_().m_36054_(remainder)) continue;
            ItemEntity itemEntity = new ItemEntity((Level)level, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), remainder);
            level.m_7967_((Entity)itemEntity);
        }
        Item expNuggetItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("create", "experience_nugget"));
        if (expNuggetItem != null && expNuggetItem != ForgeRegistries.ITEMS.getValue(new ResourceLocation("minecraft", "air"))) {
            ItemStack expNugget = new ItemStack((ItemLike)expNuggetItem, 1);
            if (!player.m_150109_().m_36054_(expNugget)) {
                ItemEntity itemEntity = new ItemEntity((Level)level, mob.m_20185_(), mob.m_20186_(), mob.m_20189_(), expNugget);
                level.m_7967_((Entity)itemEntity);
            }
        }
    }
}

