/*
 * Decompiled with CFR 0.152.
 */
package com.adonis.createfisheryindustry.mixin;

import com.adonis.createfisheryindustry.config.CreateFisheryCommonConfig;
import com.adonis.createfisheryindustry.item.CopperDivingLeggingsItem;
import com.adonis.createfisheryindustry.item.NetheriteDivingLeggingsItem;
import com.simibubi.create.content.equipment.armor.DivingBootsItem;
import java.util.UUID;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class}, priority=1000)
public abstract class UnderwaterSprintMixin {
    @Unique
    private int cfi_sprintToggleTimer = 0;
    @Unique
    private boolean cfi_wasSprintKeyDown = false;
    @Unique
    private boolean cfi_underwaterSprintActive = false;
    @Unique
    private int cfi_sprintHungerTimer = 0;
    @Unique
    private static final UUID SPRINT_BOOST_UUID = UUID.fromString("621DB27C-E2C2-4AC0-9D74-AAD05068C6C7");
    @Unique
    private static final String SPRINT_BOOST_NAME = "CFI Underwater Sprint";

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void cfi_handleUnderwaterSprint(CallbackInfo ci) {
        boolean isSprintKeyDown;
        Player player = (Player)this;
        if (!this.cfi_canUseUnderwaterSprint(player)) {
            if (this.cfi_underwaterSprintActive) {
                this.cfi_deactivateUnderwaterSprint(player);
            }
            return;
        }
        Player livingPlayer = player;
        float forwardInput = livingPlayer.f_20902_;
        boolean bl = isSprintKeyDown = forwardInput > 0.8f;
        if (isSprintKeyDown && !this.cfi_wasSprintKeyDown) {
            if (this.cfi_sprintToggleTimer > 0 && !this.cfi_underwaterSprintActive) {
                int minHunger = CreateFisheryCommonConfig.getDivingMinHungerLevel();
                if (player.m_36324_().m_38702_() > minHunger || player.m_150110_().f_35936_) {
                    this.cfi_activateUnderwaterSprint(player);
                }
            } else {
                this.cfi_sprintToggleTimer = CreateFisheryCommonConfig.getDivingSprintDoubleClickWindow();
            }
        }
        this.cfi_wasSprintKeyDown = isSprintKeyDown;
        if (this.cfi_sprintToggleTimer > 0) {
            --this.cfi_sprintToggleTimer;
        }
        if (this.cfi_underwaterSprintActive) {
            this.cfi_maintainUnderwaterSprint(player);
        }
    }

    @Unique
    private void cfi_activateUnderwaterSprint(Player player) {
        this.cfi_underwaterSprintActive = true;
        this.cfi_sprintToggleTimer = 0;
        player.m_6858_(true);
        AttributeInstance speedAttribute = player.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null && speedAttribute.m_22111_(SPRINT_BOOST_UUID) == null) {
            AttributeModifier sprintBoost = new AttributeModifier(SPRINT_BOOST_UUID, SPRINT_BOOST_NAME, 0.3, AttributeModifier.Operation.MULTIPLY_TOTAL);
            speedAttribute.m_22118_(sprintBoost);
        }
        player.getPersistentData().m_128379_("CFI_UnderwaterSprint", true);
        player.getPersistentData().m_128379_("CFI_UnderwaterSprintActive", true);
        player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11808_, SoundSource.PLAYERS, 1.0f, 1.5f);
        if (!player.m_9236_().f_46443_) {
            player.m_5661_((Component)Component.m_237113_((String)"\u00a7b[CFI] \u6c34\u4e0b\u75be\u8dd1\u5df2\u6fc0\u6d3b"), true);
        }
    }

    @Unique
    private void cfi_deactivateUnderwaterSprint(Player player) {
        this.cfi_underwaterSprintActive = false;
        AttributeInstance speedAttribute = player.m_21051_(Attributes.f_22279_);
        if (speedAttribute != null) {
            speedAttribute.m_22120_(SPRINT_BOOST_UUID);
        }
        player.getPersistentData().m_128473_("CFI_UnderwaterSprint");
        player.getPersistentData().m_128473_("CFI_UnderwaterSprintActive");
        player.m_6858_(false);
    }

    @Unique
    private boolean cfi_canUseUnderwaterSprint(Player player) {
        boolean hasDivingBoots = player.m_6844_(EquipmentSlot.FEET).m_41720_() instanceof DivingBootsItem;
        boolean hasDivingLeggings = player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof CopperDivingLeggingsItem || player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof NetheriteDivingLeggingsItem;
        boolean inFluid = player.m_20069_() || player.m_20077_();
        return hasDivingBoots && hasDivingLeggings && inFluid;
    }

    @Unique
    private void cfi_maintainUnderwaterSprint(Player player) {
        boolean hasEnoughHunger;
        Player livingPlayer = player;
        float forwardInput = livingPlayer.f_20902_;
        int minHunger = CreateFisheryCommonConfig.getDivingMinHungerLevel();
        boolean bl = hasEnoughHunger = player.m_36324_().m_38702_() > minHunger || player.m_150110_().f_35936_;
        if (!hasEnoughHunger || player.f_19862_ || forwardInput <= 0.0f) {
            this.cfi_deactivateUnderwaterSprint(player);
            if (!player.m_9236_().f_46443_) {
                String reason = !hasEnoughHunger ? "\u9965\u997f\u5ea6\u4e0d\u8db3" : (player.f_19862_ ? "\u78b0\u649e\u969c\u788d" : "\u505c\u6b62\u524d\u8fdb");
                player.m_5661_((Component)Component.m_237113_((String)("\u00a7c[CFI] \u6c34\u4e0b\u75be\u8dd1\u5df2\u505c\u6b62 - " + reason)), true);
            }
            return;
        }
        player.m_6858_(true);
        this.cfi_applySprintSpeedBoost(player);
        ++this.cfi_sprintHungerTimer;
        if (this.cfi_sprintHungerTimer >= 20) {
            this.cfi_sprintHungerTimer = 0;
            if (!player.m_150110_().f_35936_) {
                float hungerCost = (float)CreateFisheryCommonConfig.getDivingSprintHungerCost();
                player.m_36399_(hungerCost);
            }
        }
    }

    @Unique
    private void cfi_applySprintSpeedBoost(Player player) {
        double speedMultiplier = CreateFisheryCommonConfig.getDivingCopperSprintSpeed();
        if (player.m_6844_(EquipmentSlot.LEGS).m_41720_() instanceof NetheriteDivingLeggingsItem) {
            speedMultiplier = CreateFisheryCommonConfig.getDivingNetheriteSprintSpeed();
        }
        Player livingPlayer = player;
        float forwardInput = livingPlayer.f_20902_;
        float sideInput = livingPlayer.f_20900_;
        if ((double)Math.abs(forwardInput) > 0.01 || (double)Math.abs(sideInput) > 0.01) {
            float yaw = player.m_146908_() * ((float)Math.PI / 180);
            float pitch = player.m_146909_() * ((float)Math.PI / 180);
            double moveX = -Math.sin(yaw) * Math.cos(pitch) * speedMultiplier * (double)forwardInput;
            double moveY = -Math.sin(pitch) * speedMultiplier * (double)forwardInput * 0.5;
            double moveZ = Math.cos(yaw) * Math.cos(pitch) * speedMultiplier * (double)forwardInput;
            Vec3 currentMotion = player.m_20184_();
            Vec3 newMotion = currentMotion.m_82520_(moveX += Math.cos(yaw) * speedMultiplier * (double)sideInput * 0.8, moveY, moveZ += Math.sin(yaw) * speedMultiplier * (double)sideInput * 0.8);
            double maxSpeed = 0.5;
            double horizontalSpeed = Math.sqrt(newMotion.f_82479_ * newMotion.f_82479_ + newMotion.f_82481_ * newMotion.f_82481_);
            if (horizontalSpeed > maxSpeed) {
                double scale = maxSpeed / horizontalSpeed;
                newMotion = new Vec3(newMotion.f_82479_ * scale, newMotion.f_82480_, newMotion.f_82481_ * scale);
            }
            player.m_20256_(newMotion);
        }
    }

    @Inject(method={"updatePlayerPose"}, at={@At(value="HEAD")}, cancellable=true)
    private void cfi_preventSwimmingPoseWhileSprinting(CallbackInfo ci) {
        if (this.cfi_underwaterSprintActive) {
            Player player = (Player)this;
            player.m_6210_();
            ci.cancel();
        }
    }
}

