/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin;

import com.simibubi.create.content.processing.basin.BasinOperatingBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin.FoundryBasinBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.foundry_basin.FoundryBasinRecipe;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public abstract class FoundryBasinOperatingBE
extends BasinOperatingBlockEntity {
    public FoundryBasinOperatingBE(BlockEntityType<?> typeIn, BlockPos pos, BlockState state) {
        super(typeIn, pos, state);
    }

    protected void applyBasinRecipe() {
        if (this.currentRecipe == null) {
            return;
        }
        Optional optionalBasin = this.getBasin();
        if (optionalBasin.isEmpty()) {
            return;
        }
        FoundryBasinBlockEntity basin = (FoundryBasinBlockEntity)((Object)optionalBasin.get());
        boolean wasEmpty = basin.canContinueProcessing();
        if (!FoundryBasinRecipe.apply(basin, this.currentRecipe)) {
            return;
        }
        this.getProcessedRecipeTrigger().ifPresent(arg_0 -> ((FoundryBasinOperatingBE)this).award(arg_0));
        basin.inputTank.sendDataImmediately();
        if (wasEmpty && this.matchBasinRecipe(this.currentRecipe)) {
            this.continueWithPreviousRecipe();
            this.sendData();
        }
        basin.notifyChangeOfContents();
    }

    protected <C extends Container> boolean matchBasinRecipe(Recipe<C> recipe) {
        if (recipe == null) {
            return false;
        }
        Optional basin = this.getBasin();
        return basin.filter(basinBlockEntity -> FoundryBasinRecipe.match((FoundryBasinBlockEntity)((Object)basinBlockEntity), recipe)).isPresent();
    }
}

