/*
 * Decompiled with CFR 0.152.
 */
package fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible;

import com.simibubi.create.content.fluids.tank.FluidTankBlockEntity;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlock;
import fr.lucreeper74.createmetallurgy.content.blocks.industrial_crucible.CrucibleBlockEntity;
import fr.lucreeper74.createmetallurgy.registries.CMBlockEntityTypes;
import fr.lucreeper74.createmetallurgy.utils.CMConnectivityHandler;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fluids.FluidStack;

public class CrucibleBlockItem
extends BlockItem {
    public CrucibleBlockItem(Block pBlock, Item.Properties pProperties) {
        super(pBlock, pProperties);
    }

    public InteractionResult m_40576_(BlockPlaceContext ctx) {
        InteractionResult initialResult = super.m_40576_(ctx);
        if (!initialResult.m_19077_()) {
            return initialResult;
        }
        this.tryMultiPlace(ctx);
        return initialResult;
    }

    protected boolean m_7274_(BlockPos pos, Level level, @Nullable Player player, ItemStack stack, BlockState state) {
        MinecraftServer minecraftserver = level.m_7654_();
        if (minecraftserver == null) {
            return false;
        }
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            FluidStack fluid;
            nbt.m_128473_("Luminosity");
            nbt.m_128473_("Size");
            nbt.m_128473_("Height");
            nbt.m_128473_("Controller");
            nbt.m_128473_("LastKnownPos");
            if (nbt.m_128441_("TankContent") && !(fluid = FluidStack.loadFluidStackFromNBT((CompoundTag)nbt.m_128469_("TankContent"))).isEmpty()) {
                fluid.setAmount(Math.min(FluidTankBlockEntity.getCapacityMultiplier(), fluid.getAmount()));
                nbt.m_128365_("TankContent", (Tag)fluid.writeToNBT(new CompoundTag()));
            }
        }
        return super.m_7274_(pos, level, player, stack, state);
    }

    private void tryMultiPlace(BlockPlaceContext ctx) {
        BlockState blockState;
        BlockPos offsetPos;
        int zOffset;
        int xOffset;
        BlockPos startPos;
        BlockPos pos;
        BlockPos placedOnPos;
        Player player = ctx.m_43723_();
        if (player == null) {
            return;
        }
        if (player.m_6144_()) {
            return;
        }
        Direction face = ctx.m_43719_();
        if (!face.m_122434_().m_122478_()) {
            return;
        }
        ItemStack stack = ctx.m_43722_();
        Level world = ctx.m_43725_();
        BlockState placedOnState = world.m_8055_(placedOnPos = (pos = ctx.m_8083_()).m_121945_(face.m_122424_()));
        if (!CrucibleBlock.isLadle(placedOnState)) {
            return;
        }
        CrucibleBlockEntity ladleAt = (CrucibleBlockEntity)((Object)CMConnectivityHandler.partAt((BlockEntityType)CMBlockEntityTypes.INDUSTRIAL_LADLE.get(), (BlockGetter)world, placedOnPos));
        if (ladleAt == null) {
            return;
        }
        CrucibleBlockEntity controllerBE = ladleAt.getControllerBE();
        if (controllerBE == null) {
            return;
        }
        int width = controllerBE.width;
        if (width == 1) {
            return;
        }
        int tanksToPlace = 0;
        BlockPos blockPos = startPos = face == Direction.DOWN ? controllerBE.m_58899_().m_7495_() : controllerBE.m_58899_().m_6630_(controllerBE.height);
        if (startPos.m_123342_() != pos.m_123342_()) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (CrucibleBlock.isLadle(blockState)) continue;
                if (!blockState.m_247087_()) {
                    return;
                }
                ++tanksToPlace;
            }
        }
        if (!player.m_7500_() && stack.m_41613_() < tanksToPlace) {
            return;
        }
        for (xOffset = 0; xOffset < width; ++xOffset) {
            for (zOffset = 0; zOffset < width; ++zOffset) {
                offsetPos = startPos.m_7918_(xOffset, 0, zOffset);
                blockState = world.m_8055_(offsetPos);
                if (CrucibleBlock.isLadle(blockState)) continue;
                BlockPlaceContext context = BlockPlaceContext.m_43644_((BlockPlaceContext)ctx, (BlockPos)offsetPos, (Direction)face);
                player.getPersistentData().m_128379_("SilenceTankSound", true);
                super.m_40576_(context);
                player.getPersistentData().m_128473_("SilenceTankSound");
            }
        }
    }
}

