/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.jm;

import com.tom.createores.recipe.VeinRecipe;
import journeymap.client.api.display.PolygonOverlay;
import journeymap.client.api.model.MapPolygon;
import journeymap.client.api.model.ShapeProperties;
import journeymap.client.api.model.TextProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class OreDistanceInfo {
    private long time;
    private PolygonOverlay overlay;

    public OreDistanceInfo(ResourceKey<Level> dim, BlockPos center, int radius, VeinRecipe vein, long time) {
        this.time = time;
        BlockPos[] c = new BlockPos[36];
        int x = center.m_123341_();
        int z = center.m_123343_();
        for (int i = 0; i < 36; ++i) {
            double r = Math.toRadians(i * 10);
            c[i] = new BlockPos(x + (int)(Math.cos(r) * (double)radius), 1, z + (int)(Math.sin(r) * (double)radius));
        }
        MapPolygon polygon = new MapPolygon(c);
        int color = -65536;
        String displayId = "coe_vein_dist_" + x + "," + z + "," + radius;
        ShapeProperties shapeProps = new ShapeProperties().setStrokeWidth(radius > 50 ? 4.0f : 2.0f).setStrokeColor(color).setFillColor(color).setFillOpacity(0.1f);
        TextProperties textProps = new TextProperties().setColor(color).setOpacity(1.0f).setFontShadow(true);
        this.overlay = new PolygonOverlay("createoreexcavation", displayId, dim, shapeProps, polygon);
        this.overlay.setOverlayGroupName("COE Veins").setLabel(Component.m_237110_((String)"chat.coe.veinFinder.distance", (Object[])new Object[]{vein.getName(), radius}).getString()).setTextProperties(textProps);
    }

    public PolygonOverlay getOverlay() {
        return this.overlay;
    }

    public boolean timedOut(long time) {
        return this.time < time;
    }
}

