/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.item.SmartInventory;
import com.tom.createores.CreateOreExcavation;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public abstract class ExcavatingRecipe
implements Recipe<SmartInventory> {
    public ResourceLocation id;
    public RecipeType<?> type;
    public RecipeSerializer<?> serializer;
    public ResourceLocation veinId;
    public Ingredient drill;
    public int priority;
    public int ticks;
    public int stressMul;
    public FluidIngredient drillingFluid;
    protected boolean isNet;

    public ExcavatingRecipe(ResourceLocation id, RecipeType<?> type, RecipeSerializer<?> serializer) {
        this.id = id;
        this.type = type;
        this.serializer = serializer;
    }

    public boolean matches(SmartInventory pContainer, Level pLevel) {
        return false;
    }

    public ItemStack assemble(SmartInventory p_44001_, RegistryAccess p_267165_) {
        return this.m_8043_(p_267165_);
    }

    public boolean m_8004_(int pWidth, int pHeight) {
        return true;
    }

    public ItemStack m_8043_(RegistryAccess p_267052_) {
        return ItemStack.f_41583_;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.serializer;
    }

    public RecipeType<?> m_6671_() {
        return this.type;
    }

    public Ingredient getDrill() {
        return this.drill;
    }

    public int getTicks() {
        return this.ticks;
    }

    public abstract String m_6076_();

    public int getStress() {
        return this.stressMul;
    }

    public FluidIngredient getDrillingFluid() {
        return this.drillingFluid;
    }

    protected abstract void fromJson(JsonObject var1);

    protected abstract void toJson(JsonObject var1);

    protected abstract void fromNetwork(FriendlyByteBuf var1);

    protected abstract void toNetwork(FriendlyByteBuf var1);

    @FunctionalInterface
    public static interface RecipeFactory<T extends ExcavatingRecipe> {
        public T create(ResourceLocation var1, RecipeType<?> var2, RecipeSerializer<?> var3);
    }

    public static class Serializer<T extends ExcavatingRecipe>
    implements RecipeSerializer<T> {
        private final CreateOreExcavation.RecipeTypeGroup<?> type;
        private final RecipeFactory<T> create;

        public Serializer(CreateOreExcavation.RecipeTypeGroup<?> type, RecipeFactory<T> create) {
            this.type = type;
            this.create = create;
        }

        public T fromJson(ResourceLocation pRecipeId, JsonObject json) {
            T r = this.create.create(pRecipeId, this.type.getRecipeType(), this);
            ((ExcavatingRecipe)r).drill = Ingredient.m_43917_((JsonElement)json.get("drill"));
            ((ExcavatingRecipe)r).ticks = GsonHelper.m_13927_((JsonObject)json, (String)"ticks");
            ((ExcavatingRecipe)r).priority = GsonHelper.m_13824_((JsonObject)json, (String)"priority", (int)0);
            ((ExcavatingRecipe)r).stressMul = GsonHelper.m_13824_((JsonObject)json, (String)"stress", (int)256);
            ((ExcavatingRecipe)r).veinId = new ResourceLocation(GsonHelper.m_13906_((JsonObject)json, (String)"vein_id"));
            ((ExcavatingRecipe)r).drillingFluid = FluidIngredient.EMPTY;
            if (GsonHelper.m_13900_((JsonObject)json, (String)"fluid")) {
                ((ExcavatingRecipe)r).drillingFluid = FluidIngredient.deserialize((JsonElement)json.get("fluid"));
            }
            ((ExcavatingRecipe)r).fromJson(json);
            return r;
        }

        public void toJson(T recipe, JsonObject json) {
            json.add("drill", ((ExcavatingRecipe)recipe).drill.m_43942_());
            json.addProperty("ticks", (Number)((ExcavatingRecipe)recipe).ticks);
            json.addProperty("stress", (Number)((ExcavatingRecipe)recipe).stressMul);
            json.addProperty("priority", (Number)((ExcavatingRecipe)recipe).priority);
            json.addProperty("vein_id", ((ExcavatingRecipe)recipe).veinId.toString());
            if (((ExcavatingRecipe)recipe).drillingFluid != FluidIngredient.EMPTY) {
                json.add("fluid", (JsonElement)((ExcavatingRecipe)recipe).drillingFluid.serialize());
            }
            ((ExcavatingRecipe)recipe).toJson(json);
        }

        public T fromNetwork(ResourceLocation pRecipeId, FriendlyByteBuf buffer) {
            T r = this.create.create(pRecipeId, this.type.getRecipeType(), this);
            ((ExcavatingRecipe)r).drill = Ingredient.m_43940_((FriendlyByteBuf)buffer);
            ((ExcavatingRecipe)r).ticks = buffer.m_130242_();
            ((ExcavatingRecipe)r).stressMul = buffer.m_130242_();
            ((ExcavatingRecipe)r).priority = buffer.m_130242_();
            ((ExcavatingRecipe)r).veinId = buffer.m_130281_();
            ((ExcavatingRecipe)r).fromNetwork(buffer);
            ((ExcavatingRecipe)r).drillingFluid = buffer.readBoolean() ? FluidIngredient.read((FriendlyByteBuf)buffer) : FluidIngredient.EMPTY;
            ((ExcavatingRecipe)r).isNet = true;
            return r;
        }

        public void toNetwork(FriendlyByteBuf buffer, T recipe) {
            ((ExcavatingRecipe)recipe).drill.m_43923_(buffer);
            buffer.m_130130_(((ExcavatingRecipe)recipe).ticks);
            buffer.m_130130_(((ExcavatingRecipe)recipe).stressMul);
            buffer.m_130130_(((ExcavatingRecipe)recipe).priority);
            buffer.m_130085_(((ExcavatingRecipe)recipe).veinId);
            ((ExcavatingRecipe)recipe).toNetwork(buffer);
            if (((ExcavatingRecipe)recipe).drillingFluid.getRequiredAmount() == 0) {
                buffer.writeBoolean(false);
            } else {
                buffer.writeBoolean(true);
                ((ExcavatingRecipe)recipe).drillingFluid.write(buffer);
            }
        }
    }
}

