/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.PassengerInformationDetailedSettings;
import de.mrjulsen.crn.block.properties.ETimeDisplay;
import de.mrjulsen.crn.client.CRNGui;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.lang.CustomLanguage;
import de.mrjulsen.crn.config.ModClientConfig;
import de.mrjulsen.crn.data.TrainExitSide;
import de.mrjulsen.crn.data.train.portable.NextConnectionsDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainDisplayData;
import de.mrjulsen.crn.data.train.portable.TrainStopDisplayData;
import de.mrjulsen.crn.registry.ModAccessorTypes;
import de.mrjulsen.crn.registry.data.NextConnectionsRequestData;
import de.mrjulsen.crn.util.ESpeedUnit;
import de.mrjulsen.crn.util.ModUtils;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.client.ber.RenderGraphics;
import de.mrjulsen.mcdragonlib.client.util.BERUtils;
import de.mrjulsen.mcdragonlib.util.ColorUtils;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class BERPassengerInfoInformative
implements AbstractAdvancedDisplayRenderer<PassengerInformationDetailedSettings> {
    private final MutableComponent textTrainTerminates = CustomLanguage.translate("block.createrailwaysnavigator.advanced_display.ber.train_terminates");
    private static final ResourceLocation CARRIAGE_ICON = new ResourceLocation("create:textures/gui/assemble.png");
    private static final ResourceLocation ICONS = new ResourceLocation("createrailwaysnavigator", "textures/gui/icons.png");
    private static final String keyDate = "gui.createrailwaysnavigator.route_overview.date";
    private static final String keyNextStop = "gui.createrailwaysnavigator.route_overview.next_stop";
    private static final String keyNextConnections = "gui.createrailwaysnavigator.route_overview.next_connections";
    private static final int MAX_LINES = 4;
    private NextConnectionsDisplayData nextConnections = null;
    private boolean nextStopAnnounced = false;
    private TrainExitSide exitSide = TrainExitSide.UNKNOWN;
    private final BERLabel timeLabel = new BERLabel().setScale(0.25f, 0.25f).setYScale(0.25f);
    private final BERLabel carriageLabel = new BERLabel().setScale(0.25f, 0.25f).setYScale(0.25f);
    private final BERLabel trainLineLabel = new BERLabel().setPos(3.0f, 2.5f).setScale(0.25f, 0.15f).setYScale(0.25f);
    private final BERLabel speedLabel = new BERLabel().setPos(3.0f, 6.0f).setScale(0.25f, 0.2f).setYScale(0.3f).setCentered(true);
    private final BERLabel dateLabel = new BERLabel().setPos(3.0f, 9.0f).setScale(0.2f, 0.15f).setYScale(0.2f).setCentered(true);
    private final BERLabel carriageInfoLabel = new BERLabel().setPos(4.5f, 11.0f).setScale(0.2f, 0.15f).setYScale(0.2f).setCentered(true);
    private final BERLabel nextConnectionsTitleLabel = new BERLabel((Component)CustomLanguage.translate("gui.createrailwaysnavigator.route_overview.next_connections").m_130940_(ChatFormatting.BOLD)).setPos(3.0f, 5.5f).setScale(0.15f, 0.15f).setYScale(0.15f);
    private final BERLabel pageIndicatorLabel = new BERLabel().setPos(3.0f, 12.5f).setScale(0.15f, 0.15f).setYScale(0.15f).setCentered(true);
    private BERLabel[][] scheduleLines;
    private BERLabel[][] nextConnectionsLines = new BERLabel[3][];
    private float listDestinationLabelX = 0.0f;

    private boolean shouldRenderNextConnections() {
        return this.nextConnections != null && !this.nextConnections.getConnections().isEmpty() && this.nextStopAnnounced;
    }

    private String generatePageIndexString(int current, int max) {
        int i;
        StringBuilder sb = new StringBuilder();
        for (i = 0; i < current; ++i) {
            sb.append(" \u25a1");
        }
        sb.append(" \u25a0");
        for (i = current + 1; i < max; ++i) {
            sb.append(" \u25a1");
        }
        return sb.toString();
    }

    @Override
    public void renderTick(float deltaTime) {
        this.timeLabel.renderTick();
        this.dateLabel.renderTick();
        this.trainLineLabel.renderTick();
        this.speedLabel.renderTick();
        this.carriageInfoLabel.renderTick();
        this.nextConnectionsTitleLabel.renderTick();
        this.pageIndicatorLabel.renderTick();
        DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> {
                    for (int j = 0; j < ((BERLabel[])y).length; ++j) {
                        DLUtils.doIfNotNull((Object)y[j], z -> z.renderTick());
                    }
                });
            }
        });
        DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
            for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                DLUtils.doIfNotNull((Object)x[i], y -> {
                    for (int j = 0; j < ((BERLabel[])y).length; ++j) {
                        DLUtils.doIfNotNull((Object)y[j], z -> z.renderTick());
                    }
                });
            }
        });
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        this.timeLabel.setText((Component)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)).m_130940_(ChatFormatting.BOLD) : TextUtils.empty())).setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - this.timeLabel.getTextWidth() - (float)(this.exitSide != TrainExitSide.UNKNOWN ? 4 : 0), 2.5f).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
    }

    public void renderHeader(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        float uv255 = 0.00390625f;
        TrainExitSide side = this.exitSide;
        if (backSide) {
            side = side.getOpposite();
        }
        graphics.poseStack().m_85836_();
        if (side == TrainExitSide.LEFT) {
            graphics.poseStack().m_252880_(4.0f, 0.0f, 0.0f);
        }
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() > 1 && !this.nextStopAnnounced) {
            this.timeLabel.render(graphics, light);
            BERUtils.renderTexture((ResourceLocation)ICONS, graphics, (boolean)false, (float)(this.timeLabel.getX() - 2.5f), (float)2.5f, (float)0.0f, (float)2.0f, (float)2.0f, (float)0.88671875f, (float)0.07421875f, (float)0.92578125f, (float)0.11328125f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
        }
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isOutOfService()) {
            graphics.poseStack().m_85849_();
            return;
        }
        this.trainLineLabel.render(graphics, light);
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() > 2 && !this.nextStopAnnounced) {
            this.carriageLabel.render(graphics, light);
            BERUtils.renderTexture((ResourceLocation)CARRIAGE_ICON, graphics, (boolean)false, (float)(this.carriageLabel.getX() - 3.5f), (float)2.5f, (float)0.0f, (float)3.0f, (float)2.0f, (float)0.0859375f, (float)0.90234375f, (float)0.13671875f, (float)0.921875f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
        }
        graphics.poseStack().m_85849_();
        if (this.nextStopAnnounced || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isWaitingAtStation()) {
            switch (side) {
                case RIGHT: {
                    BERUtils.renderTexture((ResourceLocation)ModGuiIcons.ICON_LOCATION, graphics, (boolean)false, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 3 - 3), (float)2.05f, (float)0.0f, (float)3.0f, (float)3.0f, (float)(0.00390625f * (float)ModGuiIcons.ARROW_RIGHT.getU()), (float)(0.00390625f * (float)ModGuiIcons.ARROW_RIGHT.getV()), (float)(0.00390625f * (float)(ModGuiIcons.ARROW_RIGHT.getU() + 16)), (float)(0.00390625f * (float)(ModGuiIcons.ARROW_RIGHT.getV() + 16)), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor()), (int)light);
                    break;
                }
                case LEFT: {
                    BERUtils.renderTexture((ResourceLocation)ModGuiIcons.ICON_LOCATION, graphics, (boolean)false, (float)3.0f, (float)2.05f, (float)0.0f, (float)3.0f, (float)3.0f, (float)(0.00390625f * (float)ModGuiIcons.ARROW_LEFT.getU()), (float)(0.00390625f * (float)ModGuiIcons.ARROW_LEFT.getV()), (float)(0.00390625f * (float)(ModGuiIcons.ARROW_LEFT.getU() + 16)), (float)(0.00390625f * (float)(ModGuiIcons.ARROW_LEFT.getV() + 16)), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor()), (int)light);
                    break;
                }
            }
        }
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float partialTick, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        float uv255 = 0.00390625f;
        this.renderHeader(graphics, partialTick, parent, light, backSide);
        BERUtils.fillColor(graphics, (float)2.5f, (float)5.0f, (float)0.01f, (float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16 - 5), (float)0.25f, (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)light);
        if (((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData() == null || ((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().getState().isOutOfService()) {
            return;
        }
        if (this.shouldRenderNextConnections()) {
            DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
                for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                    DLUtils.doIfNotNull((Object)x[i], a -> {
                        for (int j = 0; j < ((BERLabel[])a).length; ++j) {
                            DLUtils.doIfNotNull((Object)a[j], b -> b.render((RenderGraphics)graphics, light));
                        }
                    });
                }
            });
            this.nextConnectionsTitleLabel.render(graphics, light);
            this.pageIndicatorLabel.render(graphics, light);
        } else if (((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).showStats() && DragonLib.getCurrentWorldTime() % 500L < 200L && !((AdvancedDisplayBlockEntity)graphics.blockEntity()).getTrainData().isWaitingAtStation()) {
            this.speedLabel.render(graphics, light);
            this.dateLabel.render(graphics, light);
            this.carriageInfoLabel.render(graphics, light);
            BERUtils.renderTexture((ResourceLocation)CARRIAGE_ICON, graphics, (boolean)false, (float)((float)(((AdvancedDisplayBlockEntity)graphics.blockEntity()).getXSizeScaled() * 16) / 2.0f - this.carriageInfoLabel.getTextWidth() / 2.0f - 1.5f), (float)this.carriageInfoLabel.getY(), (float)0.0f, (float)2.25f, (float)1.5f, (float)0.0859375f, (float)0.90234375f, (float)0.13671875f, (float)0.921875f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
        } else {
            DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
                for (int i = 0; i < ((BERLabel[][])x).length; ++i) {
                    int idx = i;
                    DLUtils.doIfNotNull((Object)x[i], a -> {
                        for (int j = 0; j < ((BERLabel[])a).length; ++j) {
                            DLUtils.doIfNotNull((Object)a[j], b -> b.render((RenderGraphics)graphics, light));
                        }
                        float uv32 = 0.015625f;
                        if (idx == 0 && this.scheduleLines.length > 1) {
                            BERUtils.renderTexture((ResourceLocation)CRNGui.GUI, (RenderGraphics)graphics, (boolean)false, (float)(this.listDestinationLabelX - 2.0f), (float)(a[LineComponent.SCHEDULED_TIME.i()].getY() - 1.0f), (float)0.0f, (float)1.0f, (float)2.0f, (float)0.328125f, (float)0.46875f, (float)0.4375f, (float)0.6875f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
                        } else if (idx >= 3) {
                            BERUtils.renderTexture((ResourceLocation)CRNGui.GUI, (RenderGraphics)graphics, (boolean)false, (float)(this.listDestinationLabelX - 2.0f), (float)(a[LineComponent.SCHEDULED_TIME.i()].getY() - 1.0f), (float)0.0f, (float)1.0f, (float)2.0f, (float)0.546875f, (float)0.46875f, (float)0.65625f, (float)0.6875f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
                        } else {
                            BERUtils.renderTexture((ResourceLocation)CRNGui.GUI, (RenderGraphics)graphics, (boolean)false, (float)(this.listDestinationLabelX - 2.0f), (float)(a[LineComponent.SCHEDULED_TIME.i()].getY() - 1.0f), (float)0.0f, (float)1.0f, (float)2.0f, (float)0.4375f, (float)0.46875f, (float)0.546875f, (float)0.6875f, (Direction)((Direction)((AdvancedDisplayBlockEntity)graphics.blockEntity()).m_58900_().m_61143_((Property)HorizontalDirectionalBlock.f_54117_)), (int)(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings((AdvancedDisplayBlockEntity)graphics.blockEntity())).getFontColor() & 0xFFFFFF), (int)light);
                        }
                    });
                }
            });
        }
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        boolean oos = blockEntity.getTrainData() == null || blockEntity.getTrainData().getState().isOutOfService();
        TrainDisplayData data = blockEntity.getTrainData();
        boolean wasNextStopAnnounced = this.nextStopAnnounced;
        boolean bl = this.nextStopAnnounced = !data.isWaitingAtStation() && data.getNextStop().isPresent() && data.getNextStop().get().getRealTimeArrivalTime() - DragonLib.getCurrentWorldTime() < (long)((Integer)ModClientConfig.NEXT_STOP_ANNOUNCEMENT.get()).intValue();
        TrainExitSide trainExitSide = !this.nextStopAnnounced && !data.isWaitingAtStation() || !((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).showExit() ? TrainExitSide.UNKNOWN : (this.exitSide = data.isWaitingAtStation() ? this.exitSide : (TrainExitSide)((Object)blockEntity.relativeExitDirection.get()));
        if (oos) {
            this.nextStopAnnounced = false;
            this.exitSide = TrainExitSide.UNKNOWN;
        }
        this.timeLabel.setText((Component)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)ModUtils.formatTime(DragonLib.getCurrentWorldTime(), false)).m_130940_(ChatFormatting.BOLD) : TextUtils.empty())).setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - this.timeLabel.getTextWidth() - (float)(this.exitSide != TrainExitSide.UNKNOWN ? 4 : 0), 2.5f).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        if (oos) {
            return;
        }
        if (((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).showConnections() && blockEntity.getXSizeScaled() > 1 && this.nextStopAnnounced && !wasNextStopAnnounced && data.getNextStop().isPresent()) {
            DataAccessor.getFromServer((Object)new NextConnectionsRequestData(data.getNextStop().get().getRealTimeStation().stationName(), data.getTrainData().getId()), ModAccessorTypes.GET_NEXT_CONNECTIONS_DISPLAY_DATA, res -> {
                this.nextConnections = res;
                this.updateLayout(blockEntity, data);
                this.updateContent(blockEntity, data);
            });
        }
        if (reason == AdvancedDisplayBlockEntity.EUpdateReason.LAYOUT_CHANGED || !this.nextStopAnnounced) {
            this.updateLayout(blockEntity, data);
            this.nextConnections = null;
        }
        this.updateContent(blockEntity, data);
    }

    private int getCarriageIndex(AdvancedDisplayBlockEntity blockEntity) {
        PassengerInformationDetailedSettings settings = (PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity);
        return (settings.shouldOverwriteCarriageIndex() ? 0 : blockEntity.getCarriageData().index() + 1) + settings.getCarriageIndex();
    }

    private void updateContent(AdvancedDisplayBlockEntity blockEntity, TrainDisplayData displayData) {
        PassengerInformationDetailedSettings settings = (PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity);
        int carriageIndex = this.getCarriageIndex(blockEntity);
        this.carriageLabel.setText((Component)(blockEntity.getXSizeScaled() > 1 && !this.nextStopAnnounced ? TextUtils.text((String)String.format("%02d", carriageIndex)).m_130940_(ChatFormatting.BOLD) : TextUtils.empty())).setPos(this.timeLabel.getX() - 4.0f - this.carriageLabel.getTextWidth(), 2.5f).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        boolean atTerminus = blockEntity.getTrainData().getState() == TrainDisplayData.State.AT_TERMINUS;
        MutableComponent labelText = TextUtils.empty();
        labelText = atTerminus ? this.textTrainTerminates : (this.nextStopAnnounced ? CustomLanguage.translate(keyNextStop, displayData.getNextStop().get().getRealTimeStation().tagName()) : TextUtils.text((String)((String)(settings.getTrainTextComponents().showTrainName() ? displayData.getTrainData().getName() + " " : "") + (settings.getTrainTextComponents().showDestination() ? displayData.getNextStop().get().getDestination() : ""))).m_130940_(ChatFormatting.BOLD));
        this.trainLineLabel.setText((Component)labelText).setMaxWidth(this.nextStopAnnounced ? (float)(blockEntity.getXSizeScaled() * 16 - 6 - (this.exitSide != TrainExitSide.UNKNOWN ? 4 : 0)) : (blockEntity.getXSizeScaled() > 2 ? this.carriageLabel.getX() - 9.0f : this.timeLabel.getX() - 7.0f), BERLabel.BoundsHitReaction.SCALE_SCROLL);
        if (settings.showLineColor() && blockEntity.getTrainData().getTrainData().hasColor() && !this.nextStopAnnounced && !atTerminus) {
            this.trainLineLabel.setBackground(0xFF000000 | blockEntity.getTrainData().getTrainData().getColor() & 0xFFFFFF, false).setColor(ColorUtils.brightnessDependingFontColor((int)blockEntity.getTrainData().getTrainData().getColor(), (int)-1118482, (int)-15658735));
        } else {
            this.trainLineLabel.setBackground(0, false).setColor(0xFF000000 | settings.getFontColor() & 0xFFFFFF);
        }
        this.speedLabel.setText((Component)ModUtils.calcSpeedString(displayData.getSpeed(), (ESpeedUnit)((Object)ModClientConfig.SPEED_UNIT.get())).m_130940_(ChatFormatting.BOLD)).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.dateLabel.setText((Component)CustomLanguage.translate(keyDate, blockEntity.m_58904_().m_46468_() / 24000L, ModUtils.formatTime(DragonLib.getCurrentWorldTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        this.carriageInfoLabel.setText((Component)TextUtils.text((String)String.format("%02d", carriageIndex))).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
        if (this.shouldRenderNextConnections() && !this.nextConnections.getConnections().isEmpty()) {
            int pages = (int)Math.ceil((float)this.nextConnections.getConnections().size() / 3.0f);
            int page = (int)(DragonLib.getCurrentWorldTime() % (long)(100 * pages) / 100L);
            this.pageIndicatorLabel.setText((Component)TextUtils.text((String)this.generatePageIndexString(page, pages))).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
            this.nextConnectionsTitleLabel.setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 6), BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
            DLUtils.doIfNotNull((Object)this.nextConnectionsLines, x -> {
                for (int i = 0; i < 3; ++i) {
                    int k = i;
                    int connectionIdx = i + page * 3;
                    DLUtils.doIfNotNull((Object)this.nextConnectionsLines[i], a -> {
                        if (connectionIdx >= this.nextConnections.getConnections().size()) {
                            a[LineComponent.SCHEDULED_TIME.i()].setText((Component)TextUtils.empty());
                            if (a[LineComponent.REAL_TIME.i()] != null) {
                                a[LineComponent.REAL_TIME.i()].setText((Component)TextUtils.empty());
                            }
                            a[LineComponent.TRAIN_NAME.i()].setText((Component)TextUtils.empty());
                            a[LineComponent.DESTINATION.i()].setText((Component)TextUtils.empty());
                            a[LineComponent.PLATFORM.i()].setText((Component)TextUtils.empty());
                            return;
                        }
                        TrainStopDisplayData stop = this.nextConnections.getConnections().get(connectionIdx);
                        a[LineComponent.PLATFORM.i()].setText((Component)TextUtils.text((String)stop.getRealTimeStation().info().platform())).setPos((float)(blockEntity.getXSizeScaled() * 16 - 3) - a[LineComponent.PLATFORM.i()].getTextWidth(), 7.5f + (float)k * 1.7f).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                        if (a[LineComponent.REAL_TIME.i()] != null) {
                            a[LineComponent.SCHEDULED_TIME.i()].setPos(3.0f, 7.5f + (float)k * 1.7f).setText((Component)TextUtils.text((String)ModUtils.formatTime(stop.getScheduledDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                            a[LineComponent.REAL_TIME.i()].setPos(a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getTextWidth() + 1.0f, 7.5f + (float)k * 1.7f).setText((Component)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(stop.isDepartureDelayed() ? -48574 : -15013281);
                        } else {
                            a[LineComponent.SCHEDULED_TIME.i()].setPos(3.0f, 7.5f + (float)k * 1.7f).setText((Component)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeDepartureTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(stop.isDepartureDelayed() ? -48574 : -15013281);
                        }
                        float pX = a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getTextWidth() + 1.0f + (a[LineComponent.REAL_TIME.i()] == null ? 0.0f : a[LineComponent.REAL_TIME.i()].getTextWidth() + 1.0f);
                        a[LineComponent.TRAIN_NAME.i()].setPos(pX, 7.5f + (float)k * 1.7f).setText((Component)TextUtils.text((String)stop.getTrainName())).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                        a[LineComponent.DESTINATION.i()].setPos(pX + 7.0f, 7.5f + (float)k * 1.7f).setText((Component)TextUtils.text((String)stop.getDestination())).setMaxWidth(a[LineComponent.PLATFORM.i()].getX() - 1.0f - pX - 7.0f, BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                    });
                }
            });
        } else {
            DLUtils.doIfNotNull((Object)this.scheduleLines, x -> {
                int k;
                int j;
                int i;
                int totalStationsCount = displayData.getStopsFromCurrentStation().size();
                int linesCount = Math.min(this.scheduleLines.length, totalStationsCount);
                this.listDestinationLabelX = 0.0f;
                for (i = 0; i < linesCount; ++i) {
                    j = i;
                    k = i >= linesCount - 1 ? totalStationsCount - 1 : i;
                    DLUtils.doIfNotNull((Object)this.scheduleLines[i], a -> {
                        boolean showDeparture;
                        TrainStopDisplayData stop = displayData.getStopsFromCurrentStation().get(k);
                        boolean bl = showDeparture = displayData.isWaitingAtStation() && displayData.getCurrentScheduleIndex() == stop.getStationEntryIndex();
                        if (a[LineComponent.REAL_TIME.i()] != null) {
                            a[LineComponent.SCHEDULED_TIME.i()].setText((Component)TextUtils.text((String)ModUtils.formatTime(showDeparture ? stop.getScheduledDepartureTime() : stop.getScheduledArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                            a[LineComponent.REAL_TIME.i()].setPos(a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getTextWidth() + 1.0f, (float)(6 + j * 2)).setText((Component)TextUtils.text((String)ModUtils.formatTime(showDeparture ? stop.getRealTimeDepartureTime() : stop.getRealTimeArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(stop.isArrivalDelayed() ? -48574 : -15013281);
                        } else {
                            a[LineComponent.SCHEDULED_TIME.i()].setText((Component)TextUtils.text((String)ModUtils.formatTime(stop.getRealTimeArrivalTime(), ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getTimeDisplay() == ETimeDisplay.ETA))).setColor(stop.isArrivalDelayed() ? -48574 : -15013281);
                        }
                        this.listDestinationLabelX = Math.max(this.listDestinationLabelX, a[LineComponent.SCHEDULED_TIME.i()].getX() + a[LineComponent.SCHEDULED_TIME.i()].getTextWidth() + 3.0f + (a[LineComponent.REAL_TIME.i()] == null ? 0.0f : a[LineComponent.REAL_TIME.i()].getTextWidth() + 1.0f));
                    });
                }
                for (i = 0; i < linesCount; ++i) {
                    j = i;
                    k = i >= linesCount - 1 ? totalStationsCount - 1 : i;
                    DLUtils.doIfNotNull((Object)this.scheduleLines[i], a -> {
                        TrainStopDisplayData stop = displayData.getStopsFromCurrentStation().get(k);
                        a[LineComponent.DESTINATION.i()].setPos(this.listDestinationLabelX, (float)(6 + j * 2)).setText((Component)TextUtils.text((String)stop.getRealTimeStation().tagName()).m_130940_(j >= linesCount - 1 ? ChatFormatting.BOLD : ChatFormatting.RESET)).setMaxWidth((float)(blockEntity.getXSizeScaled() * 16 - 3) - this.listDestinationLabelX, BERLabel.BoundsHitReaction.SCALE_SCROLL).setColor(0xFF000000 | ((PassengerInformationDetailedSettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF);
                    });
                }
            });
        }
    }

    private BERLabel[] createStationLine(AdvancedDisplayBlockEntity blockEntity, int index) {
        BERLabel timeLabel = new BERLabel().setPos(3.0f, (float)(6 + index * 2)).setScale(0.15f, 0.1f).setYScale(0.15f).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        BERLabel realTimeLabel = null;
        if (blockEntity.getXSizeScaled() > 1) {
            realTimeLabel = new BERLabel().setScale(0.15f, 0.1f).setYScale(0.15f).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        }
        BERLabel destinationLabel = new BERLabel().setScale(0.15f, 0.08f).setYScale(0.15f);
        return new BERLabel[]{timeLabel, realTimeLabel, null, destinationLabel};
    }

    private BERLabel[] createNextConnectionsLine(AdvancedDisplayBlockEntity blockEntity, int index) {
        BERLabel timeLabel = new BERLabel().setPos(3.0f, (float)(7 + index * 2)).setScale(0.15f, 0.1f).setYScale(0.15f).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        BERLabel realTimeLabel = null;
        if (blockEntity.getXSizeScaled() > 2) {
            realTimeLabel = new BERLabel().setScale(0.15f, 0.1f).setYScale(0.15f).setMaxWidth(6.0f, BERLabel.BoundsHitReaction.CUT_OFF);
        }
        BERLabel trainNameLabel = new BERLabel().setScale(0.15f, 0.08f).setYScale(0.15f);
        BERLabel destinationLabel = new BERLabel().setScale(0.15f, 0.08f).setYScale(0.15f);
        BERLabel platformLabel = new BERLabel().setScale(0.15f, 0.08f).setYScale(0.15f);
        return new BERLabel[]{timeLabel, realTimeLabel, trainNameLabel, destinationLabel, platformLabel};
    }

    private void updateLayout(AdvancedDisplayBlockEntity blockEntity, TrainDisplayData data) {
        if (this.shouldRenderNextConnections()) {
            for (int i = 0; i < 3; ++i) {
                this.nextConnectionsLines[i] = this.createNextConnectionsLine(blockEntity, i);
            }
            return;
        }
        int totalStationsCount = data.getStopsFromCurrentStation().size();
        int linesCount = Math.min(4, totalStationsCount);
        this.scheduleLines = new BERLabel[linesCount][];
        for (int i = 0; i < linesCount; ++i) {
            this.scheduleLines[i] = this.createStationLine(blockEntity, i);
        }
    }

    private static enum LineComponent {
        SCHEDULED_TIME(0),
        REAL_TIME(1),
        TRAIN_NAME(2),
        DESTINATION(3),
        PLATFORM(4);

        int i;

        private LineComponent(int i) {
            this.i = i;
        }

        public int i() {
            return this.i;
        }
    }
}

