/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.ber.variants;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import de.mrjulsen.crn.block.blockentity.AdvancedDisplayBlockEntity;
import de.mrjulsen.crn.block.display.properties.StaticTextDisplaySettings;
import de.mrjulsen.crn.block.display.properties.components.ITextWidthSetting;
import de.mrjulsen.crn.client.ber.AdvancedDisplayRenderInstance;
import de.mrjulsen.crn.client.ber.variants.AbstractAdvancedDisplayRenderer;
import de.mrjulsen.crn.util.VariableManager;
import de.mrjulsen.mcdragonlib.client.ber.BERGraphics;
import de.mrjulsen.mcdragonlib.client.ber.BERLabel;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class BERRichText
implements AbstractAdvancedDisplayRenderer<StaticTextDisplaySettings> {
    private BERLabel[] labels = new BERLabel[0];

    @Override
    public void renderTick(float deltaTime) {
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].renderTick();
        }
    }

    @Override
    public void tick(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent) {
        for (int i = 0; i < this.labels.length && i < ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getComponents().size(); ++i) {
            StaticTextDisplaySettings.TextComponent component = ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getComponents().get(i);
            MutableComponent text = this.getText(component.getStaticText());
            this.labels[i].setText((Component)text);
        }
    }

    @Override
    public void render(BERGraphics<AdvancedDisplayBlockEntity> graphics, float pPartialTicks, AdvancedDisplayRenderInstance parent, int light, boolean backSide) {
        for (int i = 0; i < this.labels.length; ++i) {
            this.labels[i].render(graphics, light);
        }
    }

    private MutableComponent getText(String input) {
        String staticText = VariableManager.replacePlaceholders(input);
        MutableComponent text = TextUtils.empty();
        if (staticText != null) {
            try {
                JsonElement elem = JsonParser.parseString((String)staticText);
                text = Component.Serializer.m_130714_((String)staticText);
            }
            catch (Exception e) {
                text = TextUtils.text((String)staticText);
            }
        }
        if (text == null) {
            text = TextUtils.empty();
        }
        return text;
    }

    @Override
    public void update(Level level, BlockPos pos, BlockState state, AdvancedDisplayBlockEntity blockEntity, AdvancedDisplayRenderInstance parent, AdvancedDisplayBlockEntity.EUpdateReason reason) {
        if (!blockEntity.isController()) {
            this.labels = new BERLabel[0];
            return;
        }
        ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).verifyComponents();
        List<StaticTextDisplaySettings.TextComponent> components = ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getComponents();
        this.labels = new BERLabel[components.size()];
        for (int i = 0; i < components.size(); ++i) {
            StaticTextDisplaySettings.TextComponent component = components.get(i);
            BERLabel label = new BERLabel();
            MutableComponent text = this.getText(component.getStaticText());
            label.setScrollingSpeed(2.0f).setColor(0xFF000000 | ((StaticTextDisplaySettings)this.getDisplaySettings(blockEntity)).getFontColor() & 0xFFFFFF).setText((Component)text).setYScale(component.getYScale()).setForceScrolling(component.getBoundsAction() == ITextWidthSetting.TextScaleBounds.SCROLL).setScale(component.getXScale(), component.getMinXScale()).setPos(3.0f + component.getX(), 3.0f + component.getY()).setCentered(component.getTextAlignment() == EAlignment.CENTER);
            label.setMaxWidth(Math.min((float)(blockEntity.getXSizeScaled() * 16 - 3) - label.getX(), component.getTextMaxWidth() > 250.0f ? Float.MAX_VALUE : component.getTextMaxWidth()), component.getBoundsAction().hit());
            if (component.getTextAlignment() == EAlignment.RIGHT && !label.isForceScrolling()) {
                label.setPos(label.getX() + label.getMaxWidth() - Math.min(label.getTextWidth(), label.getMaxWidth()), label.getY());
            }
            float f = label.getX();
            float f2 = label.getY();
            float f3 = blockEntity.getYSize() * 16 - 2;
            float f4 = label.getYScale();
            Objects.requireNonNull(Minecraft.m_91087_().f_91062_);
            label.setPos(f, Math.min(f2, f3 - f4 * 9.0f)).setBackground(component.getTextBackgroundColor(), label.isForceScrolling() || component.isFullLabelBackgroundColor() && component.getTextAlignment() != EAlignment.RIGHT);
            this.labels[i] = label;
        }
    }
}

