/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets.options;

import com.google.common.collect.ImmutableList;
import de.mrjulsen.crn.client.gui.ModGuiIcons;
import de.mrjulsen.crn.client.gui.widgets.options.DataListContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLIconButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLTooltip;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public abstract class AbstractDataListEntry<T, S, E extends AbstractDataSectionDefinition<T, S>>
extends DLWidgetContainer {
    protected final DataListContainer<T, S> parent;
    public final int CONTENT_POS_LEFT = 0;
    public final int CONTENT_POS_RIGHT = 0;
    public final int CONTENT_SPACING = 3;
    public final int TEXT_OFFSET = 3;
    private boolean wasBuild = false;
    private int buttonsXOffset = 0;
    private int sectionsXOffset = 0;
    private List<E> sections = new ArrayList();
    private final Map<DLIconButton, DLTooltip> tooltips = new HashMap<DLIconButton, DLTooltip>();
    protected final S data;
    private String text;
    private final MutableComponent textDelete = TextUtils.translate((String)"gui.createrailwaysnavigator.common.delete");

    public AbstractDataListEntry(DataListContainer<T, S> parent, int x, int y, int width, S data) {
        super(x, y, width, 20);
        this.parent = parent;
        this.data = data;
    }

    public DataListContainer<T, S> getParent() {
        return this.parent;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getText() {
        return this.text;
    }

    public ImmutableList<E> getSections() {
        return ImmutableList.copyOf(this.sections);
    }

    public int getCurrentButtonsXOffset() {
        return this.buttonsXOffset;
    }

    public int getCurrentSectionsXOffset() {
        return this.sectionsXOffset;
    }

    public <W extends IDragonLibWidget & GuiEventListener> W addWidget(W widget) {
        if (this.wasBuild) {
            throw new IllegalStateException("Cannot add elements to this widget after finishing creation.");
        }
        this.addRenderableWidget(widget);
        this.buttonsXOffset += widget.width();
        return widget;
    }

    public DLIconButton addButton(Sprite icon, List<FormattedText> text, DataListEntryContext<DLIconButton, T, S> onClick) {
        if (this.wasBuild) {
            throw new IllegalStateException("Cannot add elements to this widget after finishing creation.");
        }
        DLIconButton btn = (DLIconButton)this.addRenderableWidget((GuiEventListener)new DLIconButton(DLAbstractImageButton.ButtonType.DEFAULT, DynamicGuiRenderer.AreaStyle.FLAT, icon, this.x() + this.width() - 18 - this.buttonsXOffset - 0, this.y() + 1, (Component)TextUtils.empty(), b -> onClick.run((DLIconButton)b, this.parent.getData(), this.data, newData -> newData.ifPresent(a -> this.parent.displayData(a)))));
        btn.setBackColor(0);
        this.buttonsXOffset += btn.width();
        DLTooltip tooltip = DLTooltip.of(text).assignedTo((AbstractWidget)btn);
        this.tooltips.put(btn, tooltip);
        tooltip.setDynamicOffset(() -> (int)this.parent.getParentEntry().getParentList().getXScrollOffset(), () -> (int)this.parent.getParentEntry().getParentList().getYScrollOffset());
        return btn;
    }

    public DLIconButton addDeleteButton(DataListEntryContext<DLIconButton, T, S> onClick) {
        return this.addButton(ModGuiIcons.DELETE.getAsSprite(16, 16), List.of(this.textDelete), onClick);
    }

    public void updateTooltipOf(DLIconButton widget, List<FormattedText> text) {
        DLTooltip tooltip = DLTooltip.of(text).assignedTo((AbstractWidget)widget);
        tooltip.setDynamicOffset(() -> (int)this.parent.getParentEntry().getParentList().getXScrollOffset(), () -> (int)this.parent.getParentEntry().getParentList().getYScrollOffset());
        this.tooltips.put(widget, tooltip);
    }

    protected E createSection(E section) {
        if (this.wasBuild) {
            throw new IllegalStateException("Cannot add elements to this widget after finishing creation.");
        }
        this.sections.add(section);
        this.sectionsXOffset += ((AbstractDataSectionDefinition)section).width + 3;
        return section;
    }

    protected abstract void build();

    public final void buildInternal() {
        this.wasBuild = true;
        this.build();
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderWidgetBase(graphics, mouseX, mouseY, partialTicks);
        for (AbstractDataSectionDefinition section : this.sections) {
            int xCoord = this.x() + this.width() - 0 - 3 - this.buttonsXOffset - section.xOffset - section.width;
            this.renderSection(graphics, mouseX, mouseY, partialTicks, section, new GuiAreaDefinition(xCoord, this.y() + 1, section.width, 18));
        }
        int remainingWidth = this.width() - 0 - 0 - 3 - this.buttonsXOffset - this.sectionsXOffset;
        int xCoord = this.x() + 0;
        this.renderMainSection(graphics, mouseX, mouseY, partialTicks, this.text, new GuiAreaDefinition(xCoord, this.y() + 1, remainingWidth, 18));
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        this.tooltips.values().stream().forEach(x -> {
            IDragonLibWidget dlw;
            AbstractWidget patt0$temp = x.getAssignedWidget();
            if (patt0$temp instanceof IDragonLibWidget && (dlw = (IDragonLibWidget)patt0$temp).isMouseSelected()) {
                x.render(this.parent.getParentScreen(), graphics, mouseX, mouseY);
            }
        });
    }

    protected abstract void renderWidgetBase(Graphics var1, int var2, int var3, float var4);

    protected abstract void renderSection(Graphics var1, int var2, int var3, float var4, E var5, GuiAreaDefinition var6);

    protected abstract void renderMainSection(Graphics var1, int var2, int var3, float var4, String var5, GuiAreaDefinition var6);

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    public boolean consumeScrolling(double mouseX, double mouseY) {
        return false;
    }

    @FunctionalInterface
    public static interface DataListEntryContext<B extends DLButton, T, S> {
        public void run(B var1, T var2, S var3, Consumer<Optional<T>> var4);
    }

    public static abstract class AbstractDataSectionDefinition<T, S> {
        public final int xOffset;
        public final int width;

        public AbstractDataSectionDefinition(int xOffset, int width) {
            this.xOffset = xOffset;
            this.width = width;
        }
    }
}

