/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.lang;

import com.google.common.collect.ImmutableList;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import de.mrjulsen.crn.client.ClientWrapper;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.contents.TranslatableFormatException;
import net.minecraft.world.entity.Entity;

public class ModTranslatableComponent
implements ComponentContents {
    private static final Object[] NO_ARGS = new Object[0];
    private static final FormattedText TEXT_PERCENT = FormattedText.m_130775_((String)"%");
    private static final FormattedText TEXT_NULL = FormattedText.m_130775_((String)"null");
    private final String key;
    private final Object[] args;
    private Language decomposedWith;
    private List<FormattedText> decomposedParts = ImmutableList.of();
    private static final Pattern FORMAT_PATTERN = Pattern.compile("%(?:(\\d+)\\$)?([A-Za-z%]|$)");

    public ModTranslatableComponent(String string) {
        this.key = string;
        this.args = NO_ARGS;
    }

    public ModTranslatableComponent(String string, Object ... objects) {
        this.key = string;
        this.args = objects;
    }

    private void decompose() {
        Language language = ClientWrapper.getCurrentClientLanguage();
        if (language != this.decomposedWith) {
            this.decomposedWith = language;
            String string = language.m_6834_(this.key);
            try {
                ImmutableList.Builder builder = ImmutableList.builder();
                Objects.requireNonNull(builder);
                this.decomposeTemplate(string, arg_0 -> ((ImmutableList.Builder)builder).add(arg_0));
                this.decomposedParts = builder.build();
            }
            catch (TranslatableFormatException var4) {
                this.decomposedParts = ImmutableList.of((Object)FormattedText.m_130775_((String)string));
            }
        }
    }

    private void decomposeTemplate(String string, Consumer<FormattedText> consumer) {
        Matcher matcher = FORMAT_PATTERN.matcher(string);
        int i = 0;
        int j = 0;
        while (matcher.find(j)) {
            String string2;
            int k = matcher.start();
            int l = matcher.end();
            if (k > j) {
                string2 = string.substring(j, k);
                if (string2.indexOf(37) != -1) {
                    throw new IllegalArgumentException();
                }
                consumer.accept(FormattedText.m_130775_((String)string2));
            }
            string2 = matcher.group(2);
            String string3 = string.substring(k, l);
            if ("%".equals(string2) && "%%".equals(string3)) {
                consumer.accept(TEXT_PERCENT);
            } else {
                int m;
                if (!"s".equals(string2)) {
                    throw new IllegalArgumentException("Unsupported format: '" + string3 + "'");
                }
                String string4 = matcher.group(1);
                int n = m = string4 != null ? Integer.parseInt(string4) - 1 : i++;
                if (m < this.args.length) {
                    consumer.accept(this.getArgument(m));
                }
            }
            j = l;
        }
        if (j < string.length()) {
            String string5 = string.substring(j);
            if (string5.indexOf(37) != -1) {
                throw new IllegalArgumentException();
            }
            consumer.accept(FormattedText.m_130775_((String)string5));
        }
    }

    public final FormattedText getArgument(int i) {
        if (i >= this.args.length) {
            throw new IllegalArgumentException();
        }
        Object object = this.args[i];
        if (object instanceof Component) {
            return (Component)object;
        }
        return object == null ? TEXT_NULL : FormattedText.m_130775_((String)object.toString());
    }

    public <T> Optional<T> m_213724_(FormattedText.StyledContentConsumer<T> styledContentConsumer, Style style) {
        FormattedText formattedText;
        Optional optional;
        this.decompose();
        Iterator<FormattedText> var3 = this.decomposedParts.iterator();
        do {
            if (var3.hasNext()) continue;
            return Optional.empty();
        } while (!(optional = (formattedText = var3.next()).m_7451_(styledContentConsumer, style)).isPresent());
        return optional;
    }

    public <T> Optional<T> m_213874_(FormattedText.ContentConsumer<T> contentConsumer) {
        FormattedText formattedText;
        Optional optional;
        this.decompose();
        Iterator<FormattedText> var2 = this.decomposedParts.iterator();
        do {
            if (var2.hasNext()) continue;
            return Optional.empty();
        } while (!(optional = (formattedText = var2.next()).m_5651_(contentConsumer)).isPresent());
        return optional;
    }

    public MutableComponent m_213698_(CommandSourceStack commandSourceStack, Entity entity, int i) throws CommandSyntaxException {
        Object[] objects = new Object[this.args.length];
        for (int j = 0; j < objects.length; ++j) {
            Object object = this.args[j];
            objects[j] = object instanceof Component ? ComponentUtils.m_130731_((CommandSourceStack)commandSourceStack, (Component)((Component)object), (Entity)entity, (int)i) : object;
        }
        return MutableComponent.m_237204_((ComponentContents)new ModTranslatableComponent(this.key, objects));
    }

    public boolean equals(Object object) {
        ModTranslatableComponent ModTranslatableComponent2;
        if (this == object) {
            return true;
        }
        if (object instanceof ModTranslatableComponent && this.key.equals((ModTranslatableComponent2 = (ModTranslatableComponent)object).getKey()) && Arrays.equals(this.args, ModTranslatableComponent2.getArgs())) {
            boolean var10000 = true;
            return var10000;
        }
        boolean var10000 = false;
        return var10000;
    }

    public int hashCode() {
        int i = this.key.hashCode();
        i = 31 * i + Arrays.hashCode(this.args);
        return i;
    }

    public String toString() {
        String var10000 = this.key;
        return "translation{key='" + var10000 + "', args=" + Arrays.toString(this.args) + "}";
    }

    public String getKey() {
        return this.key;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

