/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data.train.portable;

import com.simibubi.create.content.trains.entity.TrainIconType;
import de.mrjulsen.crn.data.train.TrainListener;
import de.mrjulsen.crn.data.train.TrainStatus;
import de.mrjulsen.crn.data.train.TrainStop;
import de.mrjulsen.crn.event.ModCommonEvents;
import de.mrjulsen.crn.exceptions.RuntimeSideException;
import de.mrjulsen.mcdragonlib.data.Cache;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;

public class BasicTrainDisplayData {
    private final UUID id;
    private final String name;
    private final int color;
    private final TrainIconType icon;
    private final Collection<ResourceLocation> statusLocations;
    private final boolean cancelled;
    private final Cache<List<TrainStatus.CompiledTrainStatus>> clientStatus;
    private static final String NBT_ID = "Id";
    private static final String NBT_NAME = "Name";
    private static final String NBT_ICON = "Icon";
    private static final String NBT_COLOR = "Color";
    private static final String NBT_STATUS = "Status";
    private static final String NBT_CANCELLED = "Cancelled";

    private BasicTrainDisplayData(UUID id, String name, int color, TrainIconType icon, Collection<ResourceLocation> statusLocations, boolean cancelled) {
        this.id = id;
        this.name = name;
        this.color = color;
        this.icon = icon;
        this.statusLocations = statusLocations;
        this.cancelled = cancelled;
        this.clientStatus = new Cache(() -> TrainStatus.CompiledTrainStatus.load(statusLocations));
    }

    public static BasicTrainDisplayData empty() {
        return new BasicTrainDisplayData(new UUID(0L, 0L), "", 0, TrainIconType.getDefault(), List.of(), true);
    }

    public static BasicTrainDisplayData of(UUID train) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return TrainListener.getTrainData(train).map(data -> new BasicTrainDisplayData(data.getTrainId(), data.getTrainDisplayName(), data.getCurrentSection().getTrainLine().map(x -> x.getColor()).orElse(0), data.getTrain().icon, new ArrayList<ResourceLocation>(data.getStatus()), data.isCancelled())).orElse(BasicTrainDisplayData.empty());
    }

    public static BasicTrainDisplayData of(TrainStop stop) throws RuntimeSideException {
        if (!ModCommonEvents.hasServer()) {
            throw new RuntimeSideException(false);
        }
        return TrainListener.getTrainData(stop.getTrainId()).map(data -> new BasicTrainDisplayData(stop.getTrainId(), stop.getTrainDisplayName(), data.getSectionForIndex(stop.getScheduleIndex()).getTrainLine().map(x -> x.getColor()).orElse(0), stop.getTrainIcon(), new ArrayList<ResourceLocation>(data.getStatus()), data.isCancelled())).orElse(BasicTrainDisplayData.empty());
    }

    public UUID getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public TrainIconType getIcon() {
        return this.icon;
    }

    public List<TrainStatus.CompiledTrainStatus> getStatus() {
        return (List)this.clientStatus.get();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public int getColor() {
        return this.color;
    }

    public boolean hasColor() {
        return this.color != 0;
    }

    public boolean hasStatusInfo() {
        return !this.getStatus().isEmpty();
    }

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        ListTag statusList = new ListTag();
        for (ResourceLocation s : this.statusLocations) {
            statusList.add((Object)StringTag.m_129297_((String)s.toString()));
        }
        nbt.m_128362_(NBT_ID, this.id);
        nbt.m_128359_(NBT_NAME, this.name);
        nbt.m_128359_(NBT_ICON, this.icon.getId().toString());
        nbt.m_128405_(NBT_COLOR, this.color);
        nbt.m_128365_(NBT_STATUS, (Tag)statusList);
        nbt.m_128379_(NBT_CANCELLED, this.cancelled);
        return nbt;
    }

    public static BasicTrainDisplayData fromNbt(CompoundTag nbt) {
        return new BasicTrainDisplayData(nbt.m_128342_(NBT_ID), nbt.m_128461_(NBT_NAME), nbt.m_128451_(NBT_COLOR), TrainIconType.byId((ResourceLocation)new ResourceLocation(nbt.m_128461_(NBT_ICON))), nbt.m_128437_(NBT_STATUS, 8).stream().map(x -> new ResourceLocation(((StringTag)x).m_7916_())).toList(), nbt.m_128471_(NBT_CANCELLED));
    }

    public final boolean equals(Object obj) {
        BasicTrainDisplayData o;
        return obj instanceof BasicTrainDisplayData && (o = (BasicTrainDisplayData)obj).getId().equals(this.getId());
    }

    public final int hashCode() {
        return Objects.hash(this.getId());
    }
}

