/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WallSide;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;

public class CappedWallBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final EnumProperty<WallSide> PILLAR = BlockStatePropertiesAA.PILLAR_WALL;
    public static final EnumProperty<WallSide> EAST_WALL = BlockStateProperties.f_61378_;
    public static final EnumProperty<WallSide> NORTH_WALL = BlockStateProperties.f_61379_;
    public static final EnumProperty<WallSide> SOUTH_WALL = BlockStateProperties.f_61380_;
    public static final EnumProperty<WallSide> WEST_WALL = BlockStateProperties.f_61381_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private final Map<BlockState, VoxelShape> shapeByIndex;
    private final Map<BlockState, VoxelShape> collisionShapeByIndex;
    private static final VoxelShape POST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape NORTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape SOUTH_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_TEST = Block.m_49796_((double)0.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0);
    private static final VoxelShape EAST_TEST = Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0);

    public CappedWallBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(PILLAR, (Comparable)WallSide.LOW)).m_61124_(NORTH_WALL, (Comparable)WallSide.NONE)).m_61124_(EAST_WALL, (Comparable)WallSide.NONE)).m_61124_(SOUTH_WALL, (Comparable)WallSide.NONE)).m_61124_(WEST_WALL, (Comparable)WallSide.NONE)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.shapeByIndex = this.makeShapes(16.0f, 14.0f);
        this.collisionShapeByIndex = this.makeShapes(24.0f, 24.0f);
    }

    private static VoxelShape applyWallShape(VoxelShape mainShape, WallSide height, VoxelShape newShape, VoxelShape p_235631_3_) {
        if (height == WallSide.TALL) {
            return Shapes.m_83110_((VoxelShape)mainShape, (VoxelShape)p_235631_3_);
        }
        return height == WallSide.LOW ? Shapes.m_83110_((VoxelShape)mainShape, (VoxelShape)newShape) : mainShape;
    }

    private Map<BlockState, VoxelShape> makeShapes(float sizePillarVertical, float sizeWallVertical) {
        float sizePillarStart = 4.0f;
        float sizePillarEnd = 12.0f;
        float sizeWallStart = 5.0f;
        float sizeWallEnd = 11.0f;
        VoxelShape voxelshape = Block.m_49796_((double)sizePillarStart, (double)0.0, (double)sizePillarStart, (double)sizePillarEnd, (double)sizePillarVertical, (double)sizePillarEnd);
        VoxelShape voxelshape1 = Block.m_49796_((double)sizeWallStart, (double)0.0, (double)0.0, (double)sizeWallEnd, (double)sizeWallVertical, (double)sizeWallEnd);
        VoxelShape voxelshape2 = Block.m_49796_((double)sizeWallStart, (double)0.0, (double)sizeWallStart, (double)sizeWallEnd, (double)sizeWallVertical, (double)16.0);
        VoxelShape voxelshape3 = Block.m_49796_((double)0.0, (double)0.0, (double)sizeWallStart, (double)sizeWallEnd, (double)sizeWallVertical, (double)sizeWallEnd);
        VoxelShape voxelshape4 = Block.m_49796_((double)sizeWallStart, (double)0.0, (double)sizeWallStart, (double)16.0, (double)sizeWallVertical, (double)sizeWallEnd);
        VoxelShape voxelshape5 = Block.m_49796_((double)sizeWallStart, (double)0.0, (double)0.0, (double)sizeWallEnd, (double)sizePillarVertical, (double)sizeWallEnd);
        VoxelShape voxelshape6 = Block.m_49796_((double)sizeWallStart, (double)0.0, (double)sizeWallStart, (double)sizeWallEnd, (double)sizePillarVertical, (double)16.0);
        VoxelShape voxelshape7 = Block.m_49796_((double)0.0, (double)0.0, (double)sizeWallStart, (double)sizeWallEnd, (double)sizePillarVertical, (double)sizeWallEnd);
        VoxelShape voxelshape8 = Block.m_49796_((double)sizeWallStart, (double)0.0, (double)sizeWallStart, (double)16.0, (double)sizePillarVertical, (double)sizeWallEnd);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (WallSide pillarStates : PILLAR.m_6908_()) {
            for (WallSide eastState : EAST_WALL.m_6908_()) {
                for (WallSide northState : NORTH_WALL.m_6908_()) {
                    for (WallSide westState : WEST_WALL.m_6908_()) {
                        for (WallSide southState : SOUTH_WALL.m_6908_()) {
                            VoxelShape mainShape = Shapes.m_83040_();
                            mainShape = CappedWallBlock.applyWallShape(mainShape, eastState, voxelshape4, voxelshape8);
                            mainShape = CappedWallBlock.applyWallShape(mainShape, westState, voxelshape3, voxelshape7);
                            mainShape = CappedWallBlock.applyWallShape(mainShape, northState, voxelshape1, voxelshape5);
                            mainShape = CappedWallBlock.applyWallShape(mainShape, southState, voxelshape2, voxelshape6);
                            if (pillarStates != WallSide.NONE) {
                                mainShape = Shapes.m_83110_((VoxelShape)mainShape, (VoxelShape)voxelshape);
                            }
                            BlockState blockstate = (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_(PILLAR, (Comparable)pillarStates)).m_61124_(EAST_WALL, (Comparable)eastState)).m_61124_(WEST_WALL, (Comparable)westState)).m_61124_(NORTH_WALL, (Comparable)northState)).m_61124_(SOUTH_WALL, (Comparable)southState);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))), (Object)mainShape);
                            builder.put((Object)((BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true))), (Object)mainShape);
                        }
                    }
                }
            }
        }
        return builder.build();
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.shapeByIndex.get(state);
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        return this.collisionShapeByIndex.get(state);
    }

    public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType pathType) {
        return false;
    }

    private boolean connectsTo(BlockState state, boolean p_220113_2_, Direction direction) {
        Block block = state.m_60734_();
        boolean flag = block instanceof FenceGateBlock && FenceGateBlock.m_53378_((BlockState)state, (Direction)direction);
        return state.m_204336_(BlockTags.f_13032_) || !CappedWallBlock.m_152463_((BlockState)state) && p_220113_2_ || block instanceof IronBarsBlock || flag;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        FluidState fluidstate = context.m_43725_().m_6425_(context.m_8083_());
        BlockPos posNorth = clickedPos.m_122012_();
        BlockPos posEast = clickedPos.m_122029_();
        BlockPos posSouth = clickedPos.m_122019_();
        BlockPos posWest = clickedPos.m_122024_();
        BlockPos posAbove = clickedPos.m_7494_();
        BlockState blockstate = world.m_8055_(posNorth);
        BlockState blockstate1 = world.m_8055_(posEast);
        BlockState blockstate2 = world.m_8055_(posSouth);
        BlockState blockstate3 = world.m_8055_(posWest);
        BlockState blockstate4 = world.m_8055_(posAbove);
        boolean connectsSouth = this.connectsTo(blockstate, blockstate.m_60783_((BlockGetter)world, posNorth, Direction.SOUTH), Direction.SOUTH);
        boolean connectsWest = this.connectsTo(blockstate1, blockstate1.m_60783_((BlockGetter)world, posEast, Direction.WEST), Direction.WEST);
        boolean connectsNorth = this.connectsTo(blockstate2, blockstate2.m_60783_((BlockGetter)world, posSouth, Direction.NORTH), Direction.NORTH);
        boolean connectsEast = this.connectsTo(blockstate3, blockstate3.m_60783_((BlockGetter)world, posWest, Direction.EAST), Direction.EAST);
        BlockState state = (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
        return this.updateShape((LevelReader)world, state, posAbove, blockstate4, connectsSouth, connectsWest, connectsNorth, connectsEast);
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState p_196271_3_, LevelAccessor world, BlockPos pos, BlockPos p_196271_6_) {
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            world.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)world));
        }
        if (direction == Direction.DOWN) {
            return super.m_7417_(state, direction, p_196271_3_, world, pos, p_196271_6_);
        }
        return direction == Direction.UP ? this.topUpdate((LevelReader)world, state, p_196271_6_, p_196271_3_) : this.sideUpdate((LevelReader)world, pos, state, p_196271_6_, p_196271_3_, direction);
    }

    private static boolean isConnected(BlockState p_235629_0_, Property<WallSide> p_235629_1_) {
        return p_235629_0_.m_61143_(p_235629_1_) != WallSide.NONE;
    }

    private static boolean isCovered(VoxelShape p_235632_0_, VoxelShape p_235632_1_) {
        return !Shapes.m_83157_((VoxelShape)p_235632_1_, (VoxelShape)p_235632_0_, (BooleanOp)BooleanOp.f_82685_);
    }

    private BlockState topUpdate(LevelReader p_235625_1_, BlockState p_235625_2_, BlockPos p_235625_3_, BlockState p_235625_4_) {
        boolean flag = CappedWallBlock.isConnected(p_235625_2_, NORTH_WALL);
        boolean flag1 = CappedWallBlock.isConnected(p_235625_2_, EAST_WALL);
        boolean flag2 = CappedWallBlock.isConnected(p_235625_2_, SOUTH_WALL);
        boolean flag3 = CappedWallBlock.isConnected(p_235625_2_, WEST_WALL);
        return this.updateShape(p_235625_1_, p_235625_2_, p_235625_3_, p_235625_4_, flag, flag1, flag2, flag3);
    }

    private BlockState sideUpdate(LevelReader p_235627_1_, BlockPos p_235627_2_, BlockState p_235627_3_, BlockPos p_235627_4_, BlockState p_235627_5_, Direction p_235627_6_) {
        Direction direction = p_235627_6_.m_122424_();
        boolean flag = p_235627_6_ == Direction.NORTH ? this.connectsTo(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)p_235627_1_, p_235627_4_, direction), direction) : CappedWallBlock.isConnected(p_235627_3_, NORTH_WALL);
        boolean flag1 = p_235627_6_ == Direction.EAST ? this.connectsTo(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)p_235627_1_, p_235627_4_, direction), direction) : CappedWallBlock.isConnected(p_235627_3_, EAST_WALL);
        boolean flag2 = p_235627_6_ == Direction.SOUTH ? this.connectsTo(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)p_235627_1_, p_235627_4_, direction), direction) : CappedWallBlock.isConnected(p_235627_3_, SOUTH_WALL);
        boolean flag3 = p_235627_6_ == Direction.WEST ? this.connectsTo(p_235627_5_, p_235627_5_.m_60783_((BlockGetter)p_235627_1_, p_235627_4_, direction), direction) : CappedWallBlock.isConnected(p_235627_3_, WEST_WALL);
        BlockPos blockpos = p_235627_2_.m_7494_();
        BlockState blockstate = p_235627_1_.m_8055_(blockpos);
        return this.updateShape(p_235627_1_, p_235627_3_, blockpos, blockstate, flag, flag1, flag2, flag3);
    }

    private BlockState updateShape(LevelReader world, BlockState state, BlockPos pos, BlockState stateTop, boolean p_235626_5_, boolean p_235626_6_, boolean p_235626_7_, boolean p_235626_8_) {
        VoxelShape voxelshape = stateTop.m_60812_((BlockGetter)world, pos).m_83263_(Direction.DOWN);
        BlockState blockstate = this.updateSides(state, p_235626_5_, p_235626_6_, p_235626_7_, p_235626_8_, voxelshape);
        return (BlockState)blockstate.m_61124_(PILLAR, (Comparable)this.shouldRaisePost(blockstate, stateTop, voxelshape));
    }

    private WallSide shouldRaisePost(BlockState state, BlockState stateTop, VoxelShape shape) {
        boolean flag6;
        boolean flag5;
        boolean flag;
        boolean bl = flag = stateTop.m_60734_() instanceof WallBlock && (Boolean)stateTop.m_61143_((Property)WallBlock.f_57949_) != false;
        if (flag) {
            return this.getPillarState(stateTop);
        }
        WallSide wallSide = (WallSide)state.m_61143_(NORTH_WALL);
        WallSide wallSide1 = (WallSide)state.m_61143_(SOUTH_WALL);
        WallSide wallSide2 = (WallSide)state.m_61143_(EAST_WALL);
        WallSide wallSide3 = (WallSide)state.m_61143_(WEST_WALL);
        boolean flag1 = wallSide1 == WallSide.NONE;
        boolean flag2 = wallSide3 == WallSide.NONE;
        boolean flag3 = wallSide2 == WallSide.NONE;
        boolean flag4 = wallSide == WallSide.NONE;
        boolean bl2 = flag5 = flag4 && flag1 && flag2 && flag3 || flag4 != flag1 || flag2 != flag3;
        if (flag5) {
            return this.getPillarState(stateTop);
        }
        boolean bl3 = flag6 = wallSide == WallSide.TALL && wallSide1 == WallSide.TALL || wallSide2 == WallSide.TALL && wallSide3 == WallSide.TALL;
        if (flag6) {
            return WallSide.NONE;
        }
        return stateTop.m_204336_(BlockTags.f_13081_) || CappedWallBlock.isCovered(shape, POST_TEST) ? this.getPillarState(stateTop) : WallSide.NONE;
    }

    private WallSide getPillarState(BlockState stateTop) {
        return stateTop.m_204336_(BlockTags.f_13032_) ? WallSide.LOW : WallSide.TALL;
    }

    private BlockState updateSides(BlockState state, boolean p_235630_2_, boolean p_235630_3_, boolean p_235630_4_, boolean p_235630_5_, VoxelShape p_235630_6_) {
        return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_(NORTH_WALL, (Comparable)this.makeWallState(p_235630_2_, p_235630_6_, NORTH_TEST))).m_61124_(EAST_WALL, (Comparable)this.makeWallState(p_235630_3_, p_235630_6_, EAST_TEST))).m_61124_(SOUTH_WALL, (Comparable)this.makeWallState(p_235630_4_, p_235630_6_, SOUTH_TEST))).m_61124_(WEST_WALL, (Comparable)this.makeWallState(p_235630_5_, p_235630_6_, WEST_TEST));
    }

    private WallSide makeWallState(boolean p_235633_1_, VoxelShape shape, VoxelShape p_235633_3_) {
        if (p_235633_1_) {
            return CappedWallBlock.isCovered(shape, p_235633_3_) ? WallSide.TALL : WallSide.LOW;
        }
        return WallSide.NONE;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public boolean m_7420_(BlockState state, BlockGetter world, BlockPos pos) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> container) {
        container.m_61104_(new Property[]{PILLAR, NORTH_WALL, EAST_WALL, WEST_WALL, SOUTH_WALL, WATERLOGGED});
    }

    public BlockState m_6843_(BlockState p_185499_1_, Rotation p_185499_2_) {
        switch (p_185499_2_) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.m_61124_(NORTH_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(SOUTH_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(WEST_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(NORTH_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(EAST_WALL)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.m_61124_(NORTH_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(EAST_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(SOUTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(WEST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(NORTH_WALL)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)p_185499_1_.m_61124_(NORTH_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(WEST_WALL)))).m_61124_(EAST_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(NORTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(EAST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)p_185499_1_.m_61143_(SOUTH_WALL)));
            }
        }
        return p_185499_1_;
    }

    public BlockState m_6943_(BlockState p_185471_1_, Mirror p_185471_2_) {
        switch (p_185471_2_) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)p_185471_1_.m_61124_(NORTH_WALL, (Comparable)((WallSide)p_185471_1_.m_61143_(SOUTH_WALL)))).m_61124_(SOUTH_WALL, (Comparable)((WallSide)p_185471_1_.m_61143_(NORTH_WALL)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)p_185471_1_.m_61124_(EAST_WALL, (Comparable)((WallSide)p_185471_1_.m_61143_(WEST_WALL)))).m_61124_(WEST_WALL, (Comparable)((WallSide)p_185471_1_.m_61143_(EAST_WALL)));
            }
        }
        return super.m_6943_(p_185471_1_, p_185471_2_);
    }
}

