/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import org.dawnoftime.dawnoftime.block.templates.SlabBlockDoT;

public class MixedSlabBlock
extends SlabBlockDoT {
    private final ArrayList<MixedBlockRecipe> listRecipes = new ArrayList();

    public MixedSlabBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public MixedSlabBlock addMixedBlockRecipe(Block secondSlab, Supplier<Block> mixedBlock, boolean thisSlabIsBottom) {
        return this.addMixedBlockRecipe(() -> secondSlab, mixedBlock, thisSlabIsBottom);
    }

    private MixedSlabBlock addMixedBlockRecipe(Supplier<Block> secondSlab, Supplier<Block> mixedBlock, boolean thisSlabIsBottom) {
        this.listRecipes.add(new MixedBlockRecipe(secondSlab, mixedBlock, thisSlabIsBottom));
        return this;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        Direction facing = hit.m_82434_();
        ItemStack itemStack = player.m_21120_(handIn);
        if (!player.m_6047_() && player.m_36204_(pos, facing, itemStack) && facing.m_122434_().m_122478_() && !itemStack.m_41619_()) {
            for (MixedBlockRecipe recipe : this.listRecipes) {
                BlockState madeState;
                if (facing != recipe.getFacingForMerging(false) || !recipe.isConnectibleFirstSlab(state) || itemStack.m_41720_() != recipe.getSecondSlab().m_5456_() || !worldIn.m_7731_(pos, madeState = recipe.getMixedBlock().m_49966_(), 11)) continue;
                this.m_6402_(worldIn, pos, state, (LivingEntity)player, itemStack);
                if (player instanceof ServerPlayer) {
                    CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, itemStack);
                }
                SoundType soundtype = recipe.getMixedBlock().m_49962_(state);
                worldIn.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                if (!player.m_7500_()) {
                    itemStack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
        }
        return super.m_6227_(state, worldIn, pos, player, handIn, hit);
    }

    public static Item getBlockItem(final MixedSlabBlock block) {
        return new BlockItem((Block)block, new Item.Properties()){

            public InteractionResult m_40576_(BlockPlaceContext context) {
                Direction facing = context.m_43719_();
                if (context.m_43723_() != null && context.m_43723_().m_6047_() || !facing.m_122434_().m_122478_()) {
                    return super.m_40576_(context);
                }
                Player player = context.m_43723_();
                ItemStack itemStack = context.m_43722_();
                Level worldIn = context.m_43725_();
                BlockPos pos = context.m_8083_();
                if (!context.m_7058_()) {
                    pos = pos.m_121945_(facing.m_122424_());
                }
                if (player != null && !player.m_36204_(pos, facing, itemStack)) {
                    return super.m_40576_(context);
                }
                if (!itemStack.m_41619_()) {
                    BlockState state = worldIn.m_8055_(pos);
                    for (MixedBlockRecipe recipe : block.listRecipes) {
                        BlockState madeState;
                        if (facing != recipe.getFacingForMerging(true) || !recipe.isConnectibleSecondSlab(state) || (madeState = recipe.getMixedBlock().m_5573_(context)) == null || !worldIn.m_7731_(pos, madeState, 11)) continue;
                        this.m_40614_().m_6402_(worldIn, pos, state, (LivingEntity)player, itemStack);
                        if (player instanceof ServerPlayer) {
                            CriteriaTriggers.f_10591_.m_285767_((ServerPlayer)player, pos, itemStack);
                        }
                        SoundType soundtype = recipe.getMixedBlock().m_49962_(state);
                        worldIn.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                        itemStack.m_41774_(1);
                        return InteractionResult.SUCCESS;
                    }
                }
                return super.m_40576_(context);
            }
        };
    }

    public static class MixedBlockRecipe {
        private final Supplier<Block> secondSlab;
        private final Supplier<Block> mixedBlock;
        private final boolean firstSlabIsBottom;

        private MixedBlockRecipe(Supplier<Block> secondSlab, Supplier<Block> mixedBlock, boolean firstSlabIsBottom) {
            this.secondSlab = secondSlab;
            this.mixedBlock = mixedBlock;
            this.firstSlabIsBottom = firstSlabIsBottom;
        }

        private boolean isConnectibleFirstSlab(BlockState state) {
            return this.firstSlabIsBottom ? state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM : state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP;
        }

        private boolean isConnectibleSecondSlab(BlockState state) {
            if (state.m_60734_() == this.secondSlab.get() && this.secondSlab.get() instanceof SlabBlock) {
                return this.firstSlabIsBottom ? state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.TOP : state.m_61143_((Property)SlabBlock.f_56353_) == SlabType.BOTTOM;
            }
            return false;
        }

        private Direction getFacingForMerging(boolean tryPlacingFirstSlab) {
            if (tryPlacingFirstSlab) {
                return this.firstSlabIsBottom ? Direction.DOWN : Direction.UP;
            }
            return this.firstSlabIsBottom ? Direction.UP : Direction.DOWN;
        }

        protected Block getSecondSlab() {
            return this.secondSlab.get();
        }

        protected Block getMixedBlock() {
            return this.mixedBlock.get();
        }
    }
}

