/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.blockentity;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.dawnoftime.dawnoftime.block.IBlockSpecialDisplay;
import org.dawnoftime.dawnoftime.registry.DoTBBlockEntitiesRegistry;
import org.jetbrains.annotations.NotNull;

public class DisplayerBlockEntity
extends BlockEntity
implements Container {
    private static final int SIZE = 9;
    private final NonNullList<ItemStack> items = NonNullList.m_122780_((int)9, (Object)ItemStack.f_41583_);

    public DisplayerBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(DoTBBlockEntitiesRegistry.INSTANCE.DISPLAYER.get(), pPos, pBlockState);
    }

    @NotNull
    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
        return tag;
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        ContainerHelper.m_18973_((CompoundTag)tag, this.items);
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)tag, this.items);
    }

    public int m_6643_() {
        return 9;
    }

    public boolean m_7983_() {
        return this.items.stream().allMatch(ItemStack::m_41619_);
    }

    @NotNull
    public ItemStack m_8020_(int slot) {
        if (slot >= 9) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(slot);
    }

    @NotNull
    public ItemStack m_7407_(int slot, int amount) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.items, (int)slot, (int)amount);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
            this.synchroniseWithClient();
        }
        return itemstack;
    }

    @NotNull
    public ItemStack m_8016_(int slot) {
        return ContainerHelper.m_18966_(this.items, (int)slot);
    }

    public void m_6836_(int slot, @NotNull ItemStack stack) {
        int quantity = stack.m_41613_();
        this.items.set(slot, (Object)new ItemStack((ItemLike)stack.m_41720_(), 1));
        if (quantity > 0) {
            stack.m_41764_(quantity - 1);
        }
        this.m_6596_();
        this.synchroniseWithClient();
    }

    public boolean m_6542_(@NotNull Player player) {
        return true;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_6211_() {
        this.items.clear();
        this.m_6596_();
        this.synchroniseWithClient();
    }

    public List<ItemStack> removeAllItems() {
        List<ItemStack> list = this.items.stream().filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
        this.m_6211_();
        return list;
    }

    private void synchroniseWithClient() {
        if (this.f_58857_ != null && !this.f_58857_.m_5776_()) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public int m_6893_() {
        return 1;
    }

    public boolean isLit() {
        if (this.m_58904_() == null) {
            return false;
        }
        for (int slot = 0; slot < 9; ++slot) {
            BlockState defaultState;
            IBlockSpecialDisplay displayItem;
            BlockItem blockItem;
            Block block;
            Item item;
            ItemStack itemstack = this.m_8020_(slot);
            if (itemstack.m_41619_() || !((item = itemstack.m_41720_()) instanceof BlockItem) || !((block = (blockItem = (BlockItem)item).m_40614_()) instanceof IBlockSpecialDisplay ? (displayItem = (IBlockSpecialDisplay)block).emitsLight() : (defaultState = block.m_49966_()).m_60791_() > 1)) continue;
            return true;
        }
        return false;
    }
}

