/*
 * Decompiled with CFR 0.152.
 */
package org.dawnoftime.dawnoftime.block.templates;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.dawnoftime.dawnoftime.block.general.WaterSourceTrickleBlock;
import org.dawnoftime.dawnoftime.block.general.WaterTrickleBlock;
import org.dawnoftime.dawnoftime.block.templates.PoolBlock;
import org.dawnoftime.dawnoftime.util.BlockStatePropertiesAA;
import org.dawnoftime.dawnoftime.util.VoxelShapes;
import org.jetbrains.annotations.NotNull;

public class FaucetBlock
extends WaterSourceTrickleBlock {
    public FaucetBlock(BlockBehaviour.Properties propertiesIn) {
        super(propertiesIn);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStatePropertiesAA.ACTIVATED});
    }

    @Override
    public boolean m_6864_(BlockState state, BlockPlaceContext ctx) {
        return !ctx.m_7078_() && ctx.m_43722_().m_150930_(this.m_5456_());
    }

    @Override
    public BlockState m_5573_(BlockPlaceContext ctx) {
        BlockPos pos;
        Level level = ctx.m_43725_();
        BlockState current = level.m_8055_(pos = ctx.m_8083_());
        BlockState out = current.m_60713_((Block)this) ? current : this.m_49966_();
        Direction target = FaucetBlock.pickHorizontalByLocalHit(pos, ctx.m_43720_());
        return (BlockState)out.m_61124_((Property)FaucetBlock.prop(target), (Comparable)Boolean.valueOf(true));
    }

    private static BooleanProperty prop(Direction d) {
        return switch (d) {
            case Direction.NORTH -> BlockStateProperties.f_61368_;
            case Direction.EAST -> BlockStateProperties.f_61369_;
            case Direction.SOUTH -> BlockStateProperties.f_61370_;
            case Direction.WEST -> BlockStateProperties.f_61371_;
            default -> BlockStateProperties.f_61368_;
        };
    }

    private static Direction pickHorizontalByLocalHit(BlockPos pos, Vec3 worldHit) {
        double localX = worldHit.f_82479_ - (double)pos.m_123341_() - 0.5;
        double localZ = worldHit.f_82481_ - (double)pos.m_123343_() - 0.5;
        if (Math.abs(localX) > Math.abs(localZ)) {
            return localX > 0.0 ? Direction.EAST : Direction.WEST;
        }
        return localZ > 0.0 ? Direction.SOUTH : Direction.NORTH;
    }

    @Override
    public boolean[] getWaterTrickleOutPut(BlockState currentState) {
        if (!((Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) {
            return new boolean[]{(Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.NORTH_TRICKLE), (Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.EAST_TRICKLE), (Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.SOUTH_TRICKLE), (Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.WEST_TRICKLE), (Boolean)currentState.m_61143_((Property)BlockStatePropertiesAA.CENTER_TRICKLE)};
        }
        return super.getWaterTrickleOutPut(currentState);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (world.f_46443_) {
            world.m_5594_(player, pos, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.6f);
            world.m_5594_(player, pos, SoundEvents.f_12540_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        boolean activated = (Boolean)state.m_61143_((Property)BlockStatePropertiesAA.ACTIVATED) == false;
        state = (BlockState)state.m_61124_((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(activated));
        if (activated) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(true));
        }
        world.m_7731_(pos, state, 10);
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState m_7417_(BlockState stateIn, Direction directionIn, BlockState facingStateIn, LevelAccessor worldIn, BlockPos currentPosIn, BlockPos facingPosIn) {
        BlockState state = super.m_7417_(stateIn, directionIn, facingStateIn, worldIn, currentPosIn, facingPosIn);
        boolean lastActivation = (Boolean)state.m_61143_((Property)BlockStatePropertiesAA.ACTIVATED);
        switch (directionIn) {
            case NORTH: {
                Block block;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue() || !((block = facingStateIn.m_60734_()) instanceof PoolBlock)) break;
                PoolBlock pb = (PoolBlock)block;
                int level = (Integer)facingStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.m_61124_((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level >= pb.faucetLevel));
                break;
            }
            case SOUTH: {
                Block level;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue() || !((level = facingStateIn.m_60734_()) instanceof PoolBlock)) break;
                PoolBlock pb = (PoolBlock)level;
                int level2 = (Integer)facingStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.m_61124_((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level2 >= pb.faucetLevel));
                break;
            }
            case EAST: {
                Block level2;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue() || !((level2 = facingStateIn.m_60734_()) instanceof PoolBlock)) break;
                PoolBlock pb = (PoolBlock)level2;
                int level3 = (Integer)facingStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.m_61124_((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level3 >= pb.faucetLevel));
                break;
            }
            case WEST: {
                Block level3;
                if (!((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue() || !((level3 = facingStateIn.m_60734_()) instanceof PoolBlock)) break;
                PoolBlock pb = (PoolBlock)level3;
                int level4 = (Integer)facingStateIn.m_61143_((Property)BlockStatePropertiesAA.LEVEL);
                state = (BlockState)state.m_61124_((Property)BlockStatePropertiesAA.ACTIVATED, (Comparable)Boolean.valueOf(level4 >= pb.faucetLevel));
                break;
            }
            case DOWN: {
                if (!((Boolean)state.m_61143_((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue()) break;
                state = facingStateIn.m_60734_() instanceof WaterTrickleBlock ? (BlockState)state.m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(false)) : (BlockState)state.m_61124_((Property)BlockStateProperties.f_61361_, (Comparable)Boolean.valueOf(true));
            }
        }
        if (worldIn.m_5776_() && ((Boolean)state.m_61143_((Property)BlockStatePropertiesAA.ACTIVATED)).booleanValue() && !lastActivation) {
            worldIn.m_5594_(null, currentPosIn, SoundEvents.f_12088_, SoundSource.BLOCKS, 0.3f, 0.6f);
            worldIn.m_5594_(null, currentPosIn, SoundEvents.f_12540_, SoundSource.BLOCKS, 0.3f, 1.0f);
        }
        if (!worldIn.m_5776_() && (Boolean)state.m_61143_((Property)BlockStatePropertiesAA.ACTIVATED) != lastActivation) {
            worldIn.m_186460_(currentPosIn, (Block)this, 5);
        }
        return state;
    }

    @Override
    public int getShapeIndex(@NotNull BlockState state, @NotNull BlockGetter worldIn, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        int index = 0;
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)).booleanValue()) {
            ++index;
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)).booleanValue()) {
            index += 2;
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)).booleanValue()) {
            index += 4;
        }
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)).booleanValue()) {
            index += 8;
        }
        if (index > 14) {
            index = 0;
        }
        return index;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        boolean s = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
        boolean w = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
        boolean n = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
        boolean e = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
        if (!(s || w || n || e)) {
            return Shapes.m_83144_();
        }
        int idx = this.getShapeIndex(state, world, pos, context);
        return VoxelShapes.FAUCET_FOUR_SIDES[idx];
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)));
            }
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)));
            }
        }
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.m_61124_((Property)BlockStateProperties.f_61368_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_)))).m_61124_((Property)BlockStateProperties.f_61369_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_)))).m_61124_((Property)BlockStateProperties.f_61370_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_)))).m_61124_((Property)BlockStateProperties.f_61371_, (Comparable)((Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_)));
            }
            case FRONT_BACK: {
                return state;
            }
        }
        return state;
    }
}

