/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.common.containers;

import com.razz.decocraft_nature.common.ModuleBlocks;
import com.razz.decocraft_nature.common.ModuleContainers;
import com.razz.decocraft_nature.common.ModuleItems;
import com.razz.decocraft_nature.common.tileentities.DecobenchTileEntity;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class DecobenchContainer
extends AbstractContainerMenu {
    public static final int ROWS = 4;
    public static final int COLUMNS = 7;
    public static final int CONTAINER_SLOT_ID = 11;
    private static final SimpleContainer CONTAINER = new SimpleContainer(28);
    private static final int FIRST_ROW = 37;
    private static final int FIRST_COLUMNS = 54;
    private static final int SPACING = 18;
    private static final int INVENTORY_X = 22;
    private static final int INVENTORY_Y = 147;
    public final NonNullList<ItemStack> items = NonNullList.m_122779_();
    public final ContainerLevelAccess access;
    public int[] colors = new int[3];
    public int[] rawMaterial = new int[1];
    public int[] crafting = new int[2];
    private DecobenchTileEntity decobenchTE;
    private Level world;

    public DecobenchContainer(int containerId, Inventory inventory) {
        this(containerId, inventory, ContainerLevelAccess.f_39287_);
    }

    public DecobenchContainer(int containerId, Inventory inventory, ContainerLevelAccess access) {
        super(ModuleContainers.DECOBENCH, containerId);
        int i;
        this.access = access;
        this.access.m_39292_((world, pos) -> {
            this.decobenchTE = (DecobenchTileEntity)world.m_7702_(pos);
            this.world = world;
        });
        for (i = 0; i < 9; ++i) {
            this.m_38897_(new Slot((Container)inventory, i, 22 + i * 18, 147));
        }
        this.m_38897_(new Slot((Container)(this.decobenchTE == null ? new SimpleContainer(1) : this.decobenchTE.getInput()), 0, 14, 16){

            public boolean m_5857_(ItemStack stack) {
                return stack.m_41720_() instanceof DyeItem || stack.m_41720_() == ModuleItems.RAW_MATERIAL;
            }
        });
        this.m_38897_(new Slot((Container)(this.decobenchTE == null ? new SimpleContainer(1) : this.decobenchTE.getResult()), 0, 175, 116){

            public boolean m_5857_(ItemStack stack) {
                return false;
            }
        });
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 7; ++j) {
                this.m_38897_(new Slot((Container)CONTAINER, i * 7 + j, 54 + j * 18, 37 + i * 18){

                    public boolean m_8010_(Player pPlayer) {
                        return false;
                    }
                });
            }
        }
        this.getTabItems("all");
        this.m_38895_(DataSlot.m_39406_((int[])this.colors, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.colors, (int)1));
        this.m_38895_(DataSlot.m_39406_((int[])this.colors, (int)2));
        this.m_38895_(DataSlot.m_39406_((int[])this.rawMaterial, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.crafting, (int)0));
        this.m_38895_(DataSlot.m_39406_((int[])this.crafting, (int)1));
        this.getTEData();
    }

    public void scrollTo(float pos) {
        int rowMax = (this.items.size() + 7 - 1) / 7 - 4;
        int posScrolled = (int)((double)(pos * (float)rowMax) + 0.5);
        if (posScrolled < 0) {
            posScrolled = 0;
        }
        for (int row = 0; row < 4; ++row) {
            for (int column = 0; column < 7; ++column) {
                int item = column + (row + posScrolled) * 7;
                if (item >= 0 && item < this.items.size()) {
                    CONTAINER.m_6836_(column + row * 7, (ItemStack)this.items.get(item));
                    continue;
                }
                CONTAINER.m_6836_(column + row * 7, ItemStack.f_41583_);
            }
        }
        this.m_38946_();
    }

    public boolean m_6875_(Player player) {
        return (Boolean)this.access.m_39299_((world, pos) -> player.m_20275_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5) <= 64.0, (Object)true);
    }

    private void getTEData() {
        if (this.world != null && !this.world.m_5776_()) {
            this.colors[0] = this.decobenchTE.getColorRed();
            this.colors[1] = this.decobenchTE.getColorGreen();
            this.colors[2] = this.decobenchTE.getColorBlue();
            this.rawMaterial[0] = this.decobenchTE.getRawMaterial();
            this.crafting[0] = this.decobenchTE.getCraft();
            this.crafting[1] = this.decobenchTE.getCraftingTimer();
        }
    }

    public void getTabItems(String tabText) {
        this.items.clear();
        if (!ModuleBlocks.BLOCKS_PER_GROUP.containsKey(tabText)) {
            tabText = "all";
        }
        if ("all".equals(tabText)) {
            for (List<Block> tab : ModuleBlocks.BLOCKS_PER_GROUP.values()) {
                this.fillItemList(tab, this.items);
            }
        } else {
            this.fillItemList(ModuleBlocks.BLOCKS_PER_GROUP.get(tabText), this.items);
        }
        this.scrollTo(0.0f);
    }

    private void fillItemList(List<Block> tab, NonNullList<ItemStack> pItems) {
        tab.forEach(block -> pItems.add((Object)new ItemStack((ItemLike)block)));
    }

    public void search(String s) {
        this.items.clear();
        String search = s.toLowerCase();
        for (List<Block> tab : ModuleBlocks.BLOCKS_PER_GROUP.values()) {
            this.fillItemList(tab, this.items);
        }
        this.items.removeIf(stack -> !stack.m_41778_().toLowerCase().contains(search));
        this.scrollTo(0.0f);
    }

    public void craft(int craft) {
        this.decobenchTE.setCraft(craft);
    }

    public boolean canScroll() {
        return this.items.size() > 28;
    }

    public void m_150399_(int pSlotId, int pButton, ClickType pClickType, Player pPlayer) {
        ClickType type = pClickType == ClickType.QUICK_MOVE ? ClickType.PICKUP : pClickType;
        this.m_150430_(pSlotId, pButton, type, pPlayer);
    }

    public void m_38946_() {
        this.getTEData();
        super.m_38946_();
    }

    public ItemStack m_7648_(Player player, int i) {
        return null;
    }
}

