/*
 * Decompiled with CFR 0.152.
 */
package com.razz.decocraft_nature.network.client;

import com.razz.decocraft_nature.common.containers.DecobenchContainer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;

public class CDecobenchCraft {
    public final int craft;

    public CDecobenchCraft(int craft) {
        this.craft = craft;
    }

    public static CDecobenchCraft decoder(FriendlyByteBuf buffer) {
        int craft = buffer.readInt();
        return new CDecobenchCraft(craft);
    }

    public void encoder(FriendlyByteBuf buffer) {
        buffer.writeInt(this.craft);
    }

    public static class Handler {
        public static void handle(CDecobenchCraft message, Supplier<NetworkEvent.Context> ctx) {
            ctx.get().enqueueWork(() -> Handler.handlePacket(message, ctx));
        }

        private static void handlePacket(CDecobenchCraft message, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                ctx.get().setPacketHandled(true);
                return;
            }
            AbstractContainerMenu container = player.f_36096_;
            if (!(container instanceof DecobenchContainer)) {
                ctx.get().setPacketHandled(true);
                return;
            }
            DecobenchContainer decobench = (DecobenchContainer)container;
            decobench.craft(message.craft);
            ctx.get().setPacketHandled(true);
        }
    }
}

