/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.builtin;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.block.WritableSignBlockEntity;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.net.builtin.WritableSignPacket;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Arrays;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import org.joml.Vector3f;

public class WritableSignScreen
extends DLScreen {
    public static final int DEFAULT_LINE_HEIGHT = 10;
    protected final WritableSignBlockEntity sign;
    protected final BlockState blockState;
    protected final WritableSignConfig config;
    protected final ConfiguredLine[] messages;
    protected final int lineCount;
    protected int blinkFrame;
    protected int selectedLine;
    protected TextFieldHelper signTextField;
    protected Button btnDone;

    public WritableSignScreen(WritableSignBlockEntity pSign) {
        this(pSign, pSign.getRenderConfig(), pSign.m_58900_().m_60734_().m_49966_(), WritableSignScreen.getMessages(pSign, pSign.getRenderConfig()));
    }

    protected WritableSignScreen(WritableSignBlockEntity pSign, WritableSignConfig config, BlockState state, ConfiguredLine[] messages) {
        super((Component)TextUtils.translate("sign.edit"));
        this.config = config;
        this.blockState = state;
        this.sign = pSign;
        this.messages = messages;
        this.lineCount = this.messages.length;
    }

    protected static ConfiguredLine[] getMessages(WritableSignBlockEntity pSign, WritableSignConfig config) {
        return (ConfiguredLine[])IntStream.range(0, config.lineData.length).mapToObj(i -> new ConfiguredLine(pSign.getText(i), config.lineData[i])).toArray(ConfiguredLine[]::new);
    }

    @Override
    protected void m_7856_() {
        this.btnDone = this.addButton(this.f_96543_ / 2 - 100, this.f_96544_ / 4 + 120, 200, 20, CommonComponents.f_130655_, p_169820_ -> this.onDone(), null);
        this.signTextField = new TextFieldHelper(() -> this.messages[this.selectedLine].text, text -> {
            this.messages[this.selectedLine].text = text;
            this.sign.setText((String)text, this.selectedLine);
        }, TextFieldHelper.m_95153_((Minecraft)this.f_96541_), TextFieldHelper.m_95182_((Minecraft)this.f_96541_), text -> text == null || (float)this.f_96541_.f_91062_.m_92895_(text) <= this.config.lineData[this.selectedLine].maxLineWidth() * this.config.scale());
    }

    @Override
    public void m_7861_() {
        DragonLib.getDragonLibNetworkManager().CHANNEL.sendToServer((Object)new WritableSignPacket(this.sign.m_58899_(), (String[])Arrays.stream(this.messages).map(x -> x.text).toArray(String[]::new)));
    }

    @Override
    public void m_86600_() {
        ++this.blinkFrame;
        if (!this.sign.m_58903_().m_155262_(this.sign.m_58900_())) {
            this.onDone();
        }
    }

    @Override
    protected void onDone() {
        DragonLib.getDragonLibNetworkManager().CHANNEL.sendToServer((Object)new WritableSignPacket(this.sign.m_58899_(), (String[])Arrays.stream(this.messages).map(x -> x.text).toArray(String[]::new)));
        this.f_96541_.m_91152_(null);
    }

    public boolean m_5534_(char pCodePoint, int pModifiers) {
        this.signTextField.m_95143_(pCodePoint);
        return true;
    }

    public void m_7379_() {
        this.onDone();
    }

    @Override
    public boolean m_7933_(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 265) {
            this.selectedLine = this.selectedLine - 1 & this.lineCount - 1;
            this.signTextField.m_95193_();
            return true;
        }
        if (pKeyCode != 264 && pKeyCode != 257 && pKeyCode != 335) {
            return this.signTextField.m_95145_(pKeyCode) ? true : super.m_7933_(pKeyCode, pScanCode, pModifiers);
        }
        this.selectedLine = this.selectedLine + 1 & this.lineCount - 1;
        this.signTextField.m_95193_();
        return true;
    }

    protected void renderSignBackground(GuiGraphics graphics) {
        MultiBufferSource.BufferSource bufferSource = this.f_96541_.m_91269_().m_110104_();
        PoseStack poseStack = graphics.m_280168_();
        graphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f + this.config.scale / 2.0f + this.config.xCenterOffset * this.config.scale, this.config.y + this.config.scale / 2.0f, 100.0f);
        poseStack.m_85841_(-this.config.scale, -this.config.scale, -1.0f);
        poseStack.m_252781_(Axis.f_252436_.m_252977_(this.config.yRot()));
        BlockRenderDispatcher blockRenderer = Minecraft.m_91087_().m_91289_();
        blockRenderer.m_110912_(this.blockState, graphics.m_280168_(), (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_);
    }

    private void renderSignText(GuiGraphics pGuiGraphics) {
        Vector3f vector3f;
        boolean flag = this.blinkFrame / 6 % 2 == 0;
        int cursorPos = this.signTextField.m_95194_();
        int selectionPos = this.signTextField.m_95197_();
        for (int line = 0; line < this.messages.length; ++line) {
            pGuiGraphics.m_280168_().m_85836_();
            ConfiguredLine configuredLine = this.messages[line];
            vector3f = this.config.screenTextScale(this.f_96547_, this.config.scale(), configuredLine);
            pGuiGraphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f + configuredLine.data.xOffset() * this.config.scale(), this.config.y + configuredLine.data.yOffset() * this.config.scale - (float)((int)(5.0f * this.config.lineData()[0].lineHeightScale())) + (float)this.config.getLineHeightsUntil(line) + (float)this.config.getLineOffset(line, vector3f.y), 105.0f);
            pGuiGraphics.m_280168_().m_85841_(vector3f.x(), vector3f.y(), vector3f.z());
            if (configuredLine != null) {
                if (this.f_96547_.m_92718_()) {
                    configuredLine.text = this.f_96547_.m_92801_(configuredLine.text);
                }
                int xCenter = -this.f_96547_.m_92895_(configuredLine.text) / 2;
                pGuiGraphics.m_280056_(this.f_96547_, configuredLine.text, xCenter, 0, configuredLine.data.color(), false);
                if (line == this.selectedLine && cursorPos >= 0 && flag) {
                    int l1 = this.f_96547_.m_92895_(configuredLine.text.substring(0, Math.max(Math.min(cursorPos, configuredLine.text.length()), 0)));
                    int i2 = l1 - this.f_96547_.m_92895_(configuredLine.text) / 2;
                    if (cursorPos >= configuredLine.text.length()) {
                        pGuiGraphics.m_280056_(this.f_96547_, "_", i2, 0, configuredLine.data.color(), false);
                    }
                }
            }
            pGuiGraphics.m_280168_().m_85849_();
        }
        for (int lineHighlight = 0; lineHighlight < this.messages.length; ++lineHighlight) {
            ConfiguredLine configuredLineH = this.messages[lineHighlight];
            pGuiGraphics.m_280168_().m_85836_();
            vector3f = this.config.screenTextScale(this.f_96547_, this.config.scale(), configuredLineH);
            pGuiGraphics.m_280168_().m_252880_((float)this.f_96543_ / 2.0f + configuredLineH.data.xOffset() * this.config.scale(), this.config.y + configuredLineH.data.yOffset() * this.config.scale - (float)((int)(5.0f * this.config.lineData()[0].lineHeightScale())) + (float)this.config.getLineHeightsUntil(lineHighlight + 1) - this.config.halfLineHeight(lineHighlight) + this.config.getHalfLineHeightScales(lineHighlight, vector3f.y), 105.0f);
            pGuiGraphics.m_280168_().m_85841_(vector3f.x(), vector3f.y(), vector3f.z());
            float lineScale = this.config.lineData()[lineHighlight].lineHeightScale();
            if (configuredLineH != null && lineHighlight == this.selectedLine && cursorPos >= 0) {
                int l3 = this.f_96547_.m_92895_(configuredLineH.text.substring(0, Math.max(Math.min(cursorPos, configuredLineH.text.length()), 0)));
                int i4 = l3 - this.f_96547_.m_92895_(configuredLineH.text) / 2;
                if (flag && cursorPos < configuredLineH.text.length()) {
                    pGuiGraphics.m_280509_(i4, -((int)(10.0f * (lineScale + 1.0f) * 0.5f)), i4 + 1, -((int)(10.0f * (lineScale - 1.0f) * 0.5f)), 0xFF000000 | configuredLineH.data.color());
                }
                if (selectionPos != cursorPos) {
                    int j4 = Math.min(cursorPos, selectionPos);
                    int j2 = Math.max(cursorPos, selectionPos);
                    int k2 = this.f_96547_.m_92895_(configuredLineH.text.substring(0, j4)) - this.f_96547_.m_92895_(configuredLineH.text) / 2;
                    int l2 = this.f_96547_.m_92895_(configuredLineH.text.substring(0, j2)) - this.f_96547_.m_92895_(configuredLineH.text) / 2;
                    int i3 = Math.min(k2, l2);
                    int j3 = Math.max(k2, l2);
                    pGuiGraphics.m_285944_(RenderType.m_285783_(), i3, -((int)(10.0f * (lineScale + 1.0f) * 0.5f)), j3, -((int)(10.0f * (lineScale - 1.0f) * 0.5f)), -16776961);
                }
            }
            pGuiGraphics.m_280168_().m_85849_();
        }
    }

    public void renderSign(GuiGraphics graphics) {
        graphics.m_280168_().m_166856_();
        graphics.m_280168_().m_85836_();
        graphics.m_280168_().m_85836_();
        this.renderSignBackground(graphics);
        graphics.m_280168_().m_85849_();
        this.renderSignText(graphics);
        graphics.m_280168_().m_85849_();
    }

    @Override
    public void m_88315_(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        Lighting.m_84930_();
        this.m_280273_(graphics);
        graphics.m_280653_(this.f_96547_, this.f_96539_, this.f_96543_ / 2, 40, 0xFFFFFF);
        this.renderSign(graphics);
        Lighting.m_84931_();
        super.m_88315_(graphics, pMouseX, pMouseY, pPartialTick);
    }

    public record WritableSignConfig(ConfiguredLineData[] lineData, boolean renderBack, float xCenterOffset, float y, float scale, float yRot, float berX, float berY, float berZ, Function<BlockState, Float> blockEntityRendererRotation, int berColor) {
        public static final int DEFAULT_SCALE = 96;

        public int getLineHeightsUntil(int index) {
            return (int)IntStream.range(0, index).mapToLong(x -> (int)(this.lineData()[x].lineHeightScale() * 10.0f)).sum();
        }

        public int getLineOffset(int index, float currentScaleY) {
            float halfLineHeight = this.halfLineHeight(index);
            return (int)(halfLineHeight - 5.0f * currentScaleY);
        }

        public float lineHeight(int index) {
            return this.lineData()[index].lineHeightScale() * 10.0f;
        }

        public float halfLineHeight(int index) {
            return this.lineData()[index].lineHeightScale() * 10.0f * 0.5f;
        }

        public float getHalfLineHeightScales(int index, float currentScaleY) {
            return this.halfLineHeight(index) * currentScaleY;
        }

        public Vector3f screenTextScale(Font font, float scale, ConfiguredLine line) {
            float scaleX = (float)MathUtils.getScale(font.m_92895_(line.text), line.data.maxLineWidth() * scale, line.data.minScale().f_82470_, line.data.maxScale().f_82470_);
            float scaleY = (float)MathUtils.getScale(font.m_92895_(line.text), line.data.maxLineWidth() * scale, line.data.minScale().f_82471_, line.data.maxScale().f_82471_);
            return new Vector3f(scaleX, scaleY, 1.0f);
        }

        public Vector3f berTextScale(String text, Font font, float scale, ConfiguredLineData data) {
            float scaleX = (float)MathUtils.getScale((float)font.m_92895_(text) * scale, data.maxLineWidth(), data.minScale().f_82470_, data.maxScale().f_82470_);
            float scaleY = (float)MathUtils.getScale((float)font.m_92895_(text) * scale, data.maxLineWidth(), data.minScale().f_82471_, data.maxScale().f_82471_);
            return new Vector3f(scaleX, scaleY, 1.0f);
        }
    }

    protected static class ConfiguredLine {
        public String text;
        public final ConfiguredLineData data;

        public ConfiguredLine(String text, ConfiguredLineData data) {
            this.text = text;
            this.data = data;
        }
    }

    public record ConfiguredLineData(float xOffset, float yOffset, Vec2 minScale, Vec2 maxScale, float maxLineWidth, float lineHeightScale, int color) {
    }
}

