/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui;

import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLNumberSelector;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.ColorObject;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Locale;
import java.util.function.Consumer;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;

public class DLColorPickerScreen
extends DLScreen {
    public static final Component title = TextUtils.translate("gui.dragonlib.colorpicker.title");
    private static final int WIDTH = 250;
    private static final int HEIGHT = 185;
    private static final int SELECTION_W = 9;
    private static final int SELECTION_H = 22;
    private static final int SELECTION_Y = 0;
    private static final int COLOR_PICKER_WIDTH = 180;
    private int guiLeft;
    private int guiTop;
    private boolean scrollingH = false;
    private boolean scrollingS = false;
    private boolean scrollingV = false;
    private final Screen lastScreen;
    private final Consumer<ColorObject> result;
    private final int currentColor;
    private final boolean vanillaStyle;
    private double h = 0.0;
    private double s = 0.0;
    private double v = 0.0;
    private DLNumberSelector hBox;
    private DLNumberSelector sBox;
    private DLNumberSelector vBox;
    private DLNumberSelector rBox;
    private DLNumberSelector gBox;
    private DLNumberSelector bBox;
    private DLEditBox colorIntBox;
    private boolean rgbNoUpdate = false;
    private boolean initialized = false;
    private Component textHSV = TextUtils.translate("gui.dragonlib.colorpicker.hsv");
    private Component textRGB = TextUtils.translate("gui.dragonlib.colorpicker.rgb");
    private Component textInteger = TextUtils.translate("gui.dragonlib.colorpicker.hex");
    private static final ResourceLocation gui = new ResourceLocation("dragonlib", "textures/gui/color_picker.png");

    public DLColorPickerScreen(Screen lastScreen, int currentColor, Consumer<ColorObject> result, boolean vanillaLookAndFeel) {
        super(title);
        this.lastScreen = lastScreen;
        this.currentColor = currentColor;
        this.result = result;
        this.vanillaStyle = vanillaLookAndFeel;
        float[] hsv = ColorObject.fromInt(currentColor).toHSV();
        this.h = hsv[0];
        this.s = hsv[1];
        this.v = hsv[2];
    }

    public void m_7379_() {
        if (this.lastScreen != null) {
            this.f_96541_.m_91152_(this.lastScreen);
        } else {
            super.m_7379_();
        }
    }

    public boolean m_7043_() {
        return true;
    }

    @Override
    public void m_7856_() {
        super.m_7856_();
        this.initialized = false;
        this.guiLeft = this.f_96543_ / 2 - 125;
        this.guiTop = this.f_96544_ / 2 - 104;
        DLButton btn1 = this.addButton(this.guiLeft + 250 - 8 - 160 - 4, this.guiTop + 185 - 28, 80, 20, CommonComponents.f_130655_, p -> this.onDone(), null);
        DLButton btn2 = this.addButton(this.guiLeft + 250 - 8 - 80, this.guiTop + 185 - 28, 80, 20, CommonComponents.f_130656_, p -> this.m_7379_(), null);
        if (!this.vanillaStyle) {
            btn1.setRenderStyle(DynamicGuiRenderer.AreaStyle.DRAGONLIB);
            btn1.setBackColor(-15371546);
            btn2.setRenderStyle(DynamicGuiRenderer.AreaStyle.DRAGONLIB);
        }
        this.hBox = this.m_142416_(new DLNumberSelector(this.guiLeft + 196, this.guiTop + 40, 46, 18, this.h * 360.0, false, (box, val) -> {
            this.h = val / 360.0;
        }){

            @Override
            public void onFocusChangeEvent(boolean focus) {
                super.onFocusChangeEvent(focus);
                if (!focus) {
                    DLColorPickerScreen.this.updateInputBoxes();
                }
            }
        });
        this.hBox.setNumberBounds(0.0, 360.0);
        this.sBox = this.m_142416_(new DLNumberSelector(this.guiLeft + 196, this.guiTop + 66, 46, 18, this.s * 100.0, false, (box, val) -> {
            this.s = val / 100.0;
        }){

            @Override
            public void onFocusChangeEvent(boolean focus) {
                super.onFocusChangeEvent(focus);
                if (!focus) {
                    DLColorPickerScreen.this.updateInputBoxes();
                }
            }
        });
        this.sBox.setNumberBounds(0.0, 100.0);
        this.vBox = this.m_142416_(new DLNumberSelector(this.guiLeft + 196, this.guiTop + 92, 46, 18, this.v * 100.0, false, (box, val) -> {
            this.v = val / 100.0;
        }){

            @Override
            public void onFocusChangeEvent(boolean focus) {
                super.onFocusChangeEvent(focus);
                if (!focus) {
                    DLColorPickerScreen.this.updateInputBoxes();
                }
            }
        });
        this.vBox.setNumberBounds(0.0, 100.0);
        this.rgbNoUpdate = true;
        this.rBox = this.m_142416_(new DLNumberSelector(this.guiLeft + 49, this.guiTop + 114, 34, 18, 0.0, false, (box, val) -> {
            if (this.rgbNoUpdate) {
                return;
            }
            ColorObject c = new ColorObject(val.intValue(), this.gBox.getAsInt(), this.bBox.getAsInt());
            float[] hsv = c.toHSV();
            this.h = hsv[0];
            this.s = hsv[1];
            this.v = hsv[2];
        }){

            @Override
            public void onFocusChangeEvent(boolean focus) {
                super.onFocusChangeEvent(focus);
                if (!focus) {
                    DLColorPickerScreen.this.updateInputBoxes();
                }
            }
        });
        this.rBox.setNumberBounds(0.0, 255.0);
        this.gBox = this.m_142416_(new DLNumberSelector(this.guiLeft + 50 + 31, this.guiTop + 114, 34, 18, 0.0, false, (box, val) -> {
            if (this.rgbNoUpdate) {
                return;
            }
            ColorObject c = new ColorObject(this.rBox.getAsInt(), val.intValue(), this.bBox.getAsInt());
            float[] hsv = c.toHSV();
            this.h = hsv[0];
            this.s = hsv[1];
            this.v = hsv[2];
        }){

            @Override
            public void onFocusChangeEvent(boolean focus) {
                super.onFocusChangeEvent(focus);
                if (!focus) {
                    DLColorPickerScreen.this.updateInputBoxes();
                }
            }
        });
        this.gBox.setNumberBounds(0.0, 255.0);
        this.bBox = this.m_142416_(new DLNumberSelector(this.guiLeft + 50 + 63, this.guiTop + 114, 34, 18, 0.0, false, (box, val) -> {
            if (this.rgbNoUpdate) {
                return;
            }
            ColorObject c = new ColorObject(this.rBox.getAsInt(), this.gBox.getAsInt(), val.intValue());
            float[] hsv = c.toHSV();
            this.h = hsv[0];
            this.s = hsv[1];
            this.v = hsv[2];
        }){

            @Override
            public void onFocusChangeEvent(boolean focus) {
                super.onFocusChangeEvent(focus);
                if (!focus) {
                    DLColorPickerScreen.this.updateInputBoxes();
                }
            }
        });
        this.bBox.setNumberBounds(0.0, 255.0);
        this.colorIntBox = this.addEditBox(this.guiLeft + 50, this.guiTop + 135, 48, 16, "0", (Component)TextUtils.empty(), true, x -> {
            if (this.rgbNoUpdate) {
                return;
            }
            ColorObject c = ColorObject.fromInt((int)Long.parseLong(this.nullCheck((String)x), 16));
            float[] hsv = c.toHSV();
            this.h = hsv[0];
            this.s = hsv[1];
            this.v = hsv[2];
        }, (box, focusLost) -> {
            if (focusLost.booleanValue()) {
                this.updateInputBoxes();
            }
        }, null);
        this.colorIntBox.m_94153_(this::editBoxHexFilter);
        this.colorIntBox.m_94199_(6);
        this.initialized = true;
        this.updateInputBoxes();
        this.rgbNoUpdate = false;
    }

    private String nullCheck(String in) {
        return in == null || in.isEmpty() || in.equals("-") ? "0" : in;
    }

    private boolean editBoxHexFilter(String input) {
        if (input.isEmpty()) {
            return true;
        }
        try {
            Integer.parseInt(input, 16);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    protected void onDone() {
        this.result.accept(ColorObject.fromHSV(this.h, this.s, this.v));
        this.m_7379_();
    }

    @Override
    public void renderBackLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        this.renderScreenBackground(graphics);
        DynamicGuiRenderer.renderWindow(graphics, this.guiLeft, this.guiTop, 250, 185, this.vanillaStyle ? -1 : -13619152, this.vanillaStyle);
        DynamicGuiRenderer.renderArea(graphics, this.guiLeft + 196, this.guiTop + 9, 46, 26, this.vanillaStyle ? -1 : -13619152, DynamicGuiRenderer.AreaStyle.GRAY, DynamicGuiRenderer.ButtonState.DOWN);
        DynamicGuiRenderer.renderArea(graphics, this.guiLeft + 8, this.guiTop + 40, 182, 18, this.vanillaStyle ? -1 : -13619152, DynamicGuiRenderer.AreaStyle.GRAY, DynamicGuiRenderer.ButtonState.DOWN);
        DynamicGuiRenderer.renderArea(graphics, this.guiLeft + 8, this.guiTop + 66, 182, 18, this.vanillaStyle ? -1 : -13619152, DynamicGuiRenderer.AreaStyle.GRAY, DynamicGuiRenderer.ButtonState.DOWN);
        DynamicGuiRenderer.renderArea(graphics, this.guiLeft + 8, this.guiTop + 92, 182, 18, this.vanillaStyle ? -1 : -13619152, DynamicGuiRenderer.AreaStyle.GRAY, DynamicGuiRenderer.ButtonState.DOWN);
        for (int i = 0; i < 180; ++i) {
            ColorObject ch = DLColorPickerScreen.getH(i, 180);
            ColorObject cs = DLColorPickerScreen.getS(this.h, i, 180);
            ColorObject cv = DLColorPickerScreen.getV(this.h, i, 180);
            GuiUtils.fill(graphics, this.guiLeft + 9 + i, this.guiTop + 41, 1, 16, ch.toInt());
            GuiUtils.fill(graphics, this.guiLeft + 9 + i, this.guiTop + 67, 1, 16, cs.toInt());
            GuiUtils.fill(graphics, this.guiLeft + 9 + i, this.guiTop + 93, 1, 16, cv.toInt());
        }
        GuiUtils.fill(graphics, this.guiLeft + 197, this.guiTop + 10, 22, 24, ColorObject.fromHSV(this.h, this.s, this.v).toInt());
        GuiUtils.fill(graphics, this.guiLeft + 197 + 22, this.guiTop + 10, 22, 24, this.currentColor);
        String title = this.m_96636_().getString();
        GuiUtils.drawString(graphics, this.f_96547_, this.guiLeft + 9, this.guiTop + 28, (FormattedText)this.textHSV, this.vanillaStyle ? -12566464 : -1, EAlignment.LEFT, false);
        GuiUtils.drawString(graphics, this.f_96547_, this.guiLeft + 125 - this.f_96547_.m_92895_(title) / 2, this.guiTop + 6, (FormattedText)TextUtils.text(title), this.vanillaStyle ? -12566464 : -1, EAlignment.LEFT, false);
        GuiUtils.drawString(graphics, this.f_96547_, this.guiLeft + 9, this.guiTop + 119, (FormattedText)this.textRGB, this.vanillaStyle ? -12566464 : -1, EAlignment.LEFT, false);
        GuiUtils.drawString(graphics, this.f_96547_, this.guiLeft + 9, this.guiTop + 139, (FormattedText)this.textInteger, this.vanillaStyle ? -12566464 : -1, EAlignment.LEFT, false);
        GuiUtils.drawTexture(gui, graphics, this.guiLeft + 5 + (int)(this.h * 180.0), this.guiTop + 38, 9, 22, this.inSliderH(mouseX, mouseY) ? 9 : 0, 0, 9, 22, 32, 32);
        GuiUtils.drawTexture(gui, graphics, this.guiLeft + 5 + (int)(this.s * 180.0), this.guiTop + 64, 9, 22, this.inSliderS(mouseX, mouseY) ? 9 : 0, 0, 9, 22, 32, 32);
        GuiUtils.drawTexture(gui, graphics, this.guiLeft + 5 + (int)(this.v * 180.0), this.guiTop + 90, 9, 22, this.inSliderV(mouseX, mouseY) ? 9 : 0, 0, 9, 22, 32, 32);
        super.renderBackLayer(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (button == 0 && this.inSliderH(mouseX, mouseY)) {
            this.scrollingH = true;
            this.setH(this.setMouseValue(mouseX));
        } else if (button == 0 && this.inSliderS(mouseX, mouseY)) {
            this.scrollingS = true;
            this.setS(this.setMouseValue(mouseX));
        } else if (button == 0 && this.inSliderV(mouseX, mouseY)) {
            this.scrollingV = true;
            this.setV(this.setMouseValue(mouseX));
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    @Override
    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (this.m_6913_() && p_keyPressed_1_ == 256 || this.f_96541_.f_91066_.f_92092_.m_90857_()) {
            this.m_7379_();
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        if (pButton == 0) {
            this.scrollingH = false;
            this.scrollingS = false;
            this.scrollingV = false;
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    public boolean m_7979_(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        double fh = 0.0;
        if (this.scrollingH || this.scrollingS || this.scrollingV) {
            fh = this.setMouseValue(pMouseX);
        }
        if (this.scrollingH) {
            this.setH(fh);
            return true;
        }
        if (this.scrollingS) {
            this.setS(fh);
            return true;
        }
        if (this.scrollingV) {
            this.setV(fh);
            return true;
        }
        return super.m_7979_(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private void setH(double d) {
        this.h = MathUtils.clamp(d, 0.0, 1.0);
        this.updateInputBoxes();
    }

    private void setS(double d) {
        this.s = MathUtils.clamp(d, 0.0, 1.0);
        this.updateInputBoxes();
    }

    private void setV(double d) {
        this.v = MathUtils.clamp(d, 0.0, 1.0);
        this.updateInputBoxes();
    }

    private void updateInputBoxes() {
        if (!this.initialized) {
            return;
        }
        this.rgbNoUpdate = true;
        this.hBox.setValue(this.h * 360.0, true);
        this.sBox.setValue(this.s * 100.0, true);
        this.vBox.setValue(this.v * 100.0, true);
        ColorObject c = ColorObject.fromHSV(this.h, this.s, this.v);
        this.rBox.setValue(c.getR(), true);
        this.gBox.setValue(c.getG(), true);
        this.bBox.setValue(c.getB(), true);
        this.colorIntBox.m_94144_(DLColorPickerScreen.convertToHex(c.toInt()));
        this.rgbNoUpdate = false;
    }

    private static String convertToHex(int rgbValue) {
        Object hexString = Integer.toHexString(rgbValue & 0xFFFFFF);
        while (((String)hexString).length() < 6) {
            hexString = "0" + (String)hexString;
        }
        return ((String)hexString).toUpperCase(Locale.ENGLISH);
    }

    private double setMouseValue(double mouseX) {
        return (mouseX - (double)(this.guiLeft + 9)) / 179.0;
    }

    public static ColorObject getH(int i, int w) {
        float hue = (float)i / (float)w;
        return ColorObject.fromHSV(hue, 1.0f, 1.0f);
    }

    public static ColorObject getS(double h, int i, int w) {
        float hue = (float)i / (float)w;
        return ColorObject.fromHSV(h, (double)hue, 1.0);
    }

    public static ColorObject getV(double h, int i, int w) {
        float hue = (float)i / (float)w;
        return ColorObject.fromHSV(h, 1.0, (double)hue);
    }

    protected boolean inSliderH(double mouseX, double mouseY) {
        int x = 9;
        int y = 42;
        int w = 180;
        int h = 16;
        int x1 = this.guiLeft + x;
        int y1 = this.guiTop + y;
        int x2 = x1 + w;
        int y2 = y1 + h;
        return mouseX >= (double)x1 && mouseY >= (double)y1 && mouseX < (double)x2 && mouseY < (double)y2;
    }

    protected boolean inSliderS(double mouseX, double mouseY) {
        int x = 9;
        int y = 68;
        int w = 180;
        int h = 16;
        int x1 = this.guiLeft + x;
        int y1 = this.guiTop + y;
        int x2 = x1 + w;
        int y2 = y1 + h;
        return mouseX >= (double)x1 && mouseY >= (double)y1 && mouseX < (double)x2 && mouseY < (double)y2;
    }

    protected boolean inSliderV(double mouseX, double mouseY) {
        int x = 9;
        int y = 94;
        int w = 180;
        int h = 16;
        int x1 = this.guiLeft + x;
        int y1 = this.guiTop + y;
        int x2 = x1 + w;
        int y2 = y1 + h;
        return mouseX >= (double)x1 && mouseY >= (double)y1 && mouseX < (double)x2 && mouseY < (double)y2;
    }
}

