/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IExtendedAreaWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;

public abstract class DLAbstractScrollBar<T extends DLAbstractScrollBar<T>>
extends DLButton
implements IExtendedAreaWidget {
    public static final int DEFAULT_STEP_SIZE = 1;
    public static final int DEFAULT_SCROLLBAR_THICKNESS = 14;
    public static final int MIN_SCROLLBAR_THICKNESS = 7;
    public static final int MIN_SCROLLER_SIZE = 5;
    protected GuiAreaDefinition scrollArea;
    protected double scrollPercentage;
    protected double scroll;
    protected int maxScroll = 2;
    protected boolean isScrolling = false;
    protected int maxUnitsPerPage = 1;
    protected int scrollerSize = 15;
    protected int stepSize = 1;
    protected boolean autoScrollerSize = false;
    public Consumer<T> onValueChanged;
    protected DLContextMenu menu = new DLContextMenu(() -> GuiAreaDefinition.of(this), () -> {
        DLContextMenuItem.Builder builder = new DLContextMenuItem.Builder();
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.scrollbar.here"), Sprite.empty(), true, b -> this.scrollToMouse(this.getMouseScrollDirection(b.x(), b.y())), null));
        builder.addSeparator();
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.scrollbar.top"), Sprite.empty(), this.getScrollValue() > 0.0, b -> this.scrollToTop(), null));
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.scrollbar.bottom"), Sprite.empty(), this.getScrollValue() < (double)this.getMaxScroll(), b -> this.scrollToBottom(), null));
        builder.addSeparator();
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.scrollbar.page_up"), Sprite.empty(), this.getScrollValue() > 0.0, b -> this.setScrollValue(this.getScrollValue() - (double)this.getScreenSize()), null));
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.scrollbar.page_down"), Sprite.empty(), this.getScrollValue() < (double)this.getMaxScroll(), b -> this.setScrollValue(this.getScrollValue() + (double)this.getScreenSize()), null));
        builder.addSeparator();
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.scrollbar.step_up"), Sprite.empty(), this.getScrollValue() > 0.0, b -> this.setScrollValue(this.getScrollValue() - (double)this.stepSize), null));
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.scrollbar.step_down"), Sprite.empty(), this.getScrollValue() < (double)this.getMaxScroll(), b -> this.setScrollValue(this.getScrollValue() + (double)this.stepSize), null));
        return builder;
    });

    public DLAbstractScrollBar(int x, int y, int w, int h, GuiAreaDefinition scrollArea) {
        super(x, y, Math.max(7, w), Math.max(7, h), null);
        this.scrollArea = scrollArea;
        this.setRenderStyle(DynamicGuiRenderer.AreaStyle.GRAY);
        this.setMenu(this.menu);
    }

    public DLAbstractScrollBar(int x, int y, int w, int h) {
        this(x, y, w, h, (GuiAreaDefinition)null);
    }

    private T self() {
        return (T)this;
    }

    public T setStepSize(int c) {
        this.stepSize = Math.max(1, c);
        return this.self();
    }

    public T setScreenSize(int c) {
        this.maxUnitsPerPage = Math.max(1, c);
        return this.self();
    }

    public T setAutoScrollerSize(boolean b) {
        this.autoScrollerSize = b;
        return this.self();
    }

    public T setScrollerSize(int w) {
        this.scrollerSize = Math.max(5, w);
        return this.self();
    }

    public T setMaxScroll(int max) {
        this.maxScroll = Math.max(max - this.maxUnitsPerPage, 0);
        if (this.autoScrollerSize) {
            this.scrollerSize = Math.max((int)((float)(this.getScrollbarLength() - 2) / Math.max((float)max / (float)this.maxUnitsPerPage, 1.0f)), 5);
        }
        this.setScrollValue(this.getScrollValue());
        return this.self();
    }

    @Deprecated(forRemoval=true)
    public T updateMaxScroll(int max) {
        return this.setMaxScroll(max);
    }

    public T withOnValueChanged(Consumer<T> event) {
        this.onValueChanged = event;
        return this.self();
    }

    public T setScrollArea(GuiAreaDefinition area) {
        this.scrollArea = area;
        return this.self();
    }

    public boolean getAutoScrollerSize() {
        return this.autoScrollerSize;
    }

    public double getScrollValue() {
        return this.scroll;
    }

    public int getMaxScroll() {
        return this.maxScroll;
    }

    public int getScreenSize() {
        return this.maxUnitsPerPage;
    }

    public GuiAreaDefinition getScrollArea() {
        return this.scrollArea;
    }

    public void m_5716_(double pMouseX, double pMouseY) {
        if (this.m_5953_(pMouseX, pMouseY) && this.canScroll()) {
            this.isScrolling = true;
            this.scrollToMouse(this.getMouseScrollDirection(pMouseX, pMouseY));
        }
    }

    protected void m_7212_(double pMouseX, double pMouseY, double pDragX, double pDragY) {
        if (this.isScrolling) {
            this.scrollToMouse(this.getMouseScrollDirection(pMouseX, pMouseY));
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (this.canScroll()) {
            this.scroll = MathUtils.clamp(this.scroll - pDelta * (double)this.stepSize, 0.0, (double)this.maxScroll);
            int i = this.maxScroll;
            this.scrollPercentage -= pDelta * (double)this.stepSize / (double)i;
            this.scrollPercentage = MathUtils.clamp(this.scrollPercentage, 0.0, 1.0);
            if (this.onValueChanged != null) {
                this.onValueChanged.accept(this.self());
            }
            return true;
        }
        return false;
    }

    public void m_7691_(double pMouseX, double pMouseY) {
        this.isScrolling = false;
    }

    private void scrollToMouse(double mousePos) {
        int i = this.getXorY() + 1;
        int j = i + this.getScrollbarLength() - 2;
        this.scrollPercentage = (mousePos - (double)i - (double)this.scrollerSize / 2.0) / (double)(j - i - this.scrollerSize);
        this.scrollPercentage = MathUtils.clamp(this.scrollPercentage, 0.0, 1.0);
        this.scroll = Math.max(0L, Math.round(this.scrollPercentage * (double)this.maxScroll));
        if (this.onValueChanged != null) {
            this.onValueChanged.accept(this.self());
        }
    }

    public void scrollTo(int pos) {
        this.scroll = MathUtils.clamp(pos, 0, this.getMaxScroll());
        if (this.onValueChanged != null) {
            this.onValueChanged.accept(this.self());
        }
    }

    public boolean canScroll() {
        return this.maxScroll > 0;
    }

    public void setScrollValue(double scroll) {
        this.scroll = MathUtils.clamp(scroll, 0.0, (double)this.maxScroll);
        this.scrollPercentage = 1.0 / (double)this.maxScroll * this.scroll;
        DLUtils.doIfNotNull(this.onValueChanged, x -> x.accept(this.self()));
    }

    public void scrollToTop() {
        this.setScrollValue(0.0);
    }

    public void scrollToBottom() {
        this.setScrollValue(this.maxScroll);
    }

    protected abstract double getMouseScrollDirection(double var1, double var3);

    protected abstract int getScrollbarLength();

    protected abstract int getXorY();

    @Override
    public abstract void renderMainLayer(Graphics var1, int var2, int var3, float var4);

    @Override
    public boolean isInArea(double mouseX, double mouseY) {
        return this.scrollArea == null || this.m_5953_(mouseX, mouseY) || this.scrollArea.isInBounds(mouseX, mouseY);
    }
}

