/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLButton
extends Button
implements IDragonLibWidget {
    private DLContextMenu menu;
    private boolean mouseSelected;
    protected final Font font;
    protected DynamicGuiRenderer.AreaStyle style = DynamicGuiRenderer.AreaStyle.NATIVE;
    protected boolean textShadow = true;
    protected EAlignment textAlign = EAlignment.CENTER;
    protected int fontColor = -1;
    protected int backColor = -1;

    public <T extends DLButton> DLButton(int pX, int pY, int pWidth, int pHeight, Component pMessage, Consumer<T> pOnPress) {
        super(pX, pY, pWidth, pHeight, pMessage, btn -> pOnPress.accept((DLButton)btn), f_252438_);
        this.font = Minecraft.m_91087_().f_91062_;
    }

    public DLButton(int pX, int pY, int pWidth, int pHeight, Component pMessage) {
        this(pX, pY, pWidth, pHeight, pMessage, btn -> {});
    }

    @Override
    public void setMenu(DLContextMenu menu) {
        this.menu = menu;
    }

    public void onHoverChange(int mouseX, int mouseY, boolean isHovering) {
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.setTint(1.0f, 1.0f, 1.0f, this.f_93625_);
        this.renderMainLayer(new Graphics(graphics, graphics.m_280168_()), mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTick) {
        DynamicGuiRenderer.renderArea(graphics, this.x(), this.y(), this.width(), this.height(), this.getBackColor(), this.getStyle(), this.m_142518_() ? (this.m_93696_() || this.isMouseSelected() ? DynamicGuiRenderer.ButtonState.SELECTED : DynamicGuiRenderer.ButtonState.BUTTON) : DynamicGuiRenderer.ButtonState.DISABLED);
        int j = this.active() ? this.getFontColor() : -6381922;
        GuiUtils.drawString(graphics, this.font, this.x() + this.width() / 2, this.y() + (this.height() - 8) / 2, (FormattedText)this.m_6035_(), j, this.getTextAlignment(), this.isRenderingTextShadow());
    }

    @Override
    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        IDragonLibWidget.super.renderFrontLayer(graphics, mouseX, mouseY, partialTicks);
        boolean wasHovering = this.f_93622_;
        this.setHovered(mouseX, mouseY);
        if (wasHovering != this.f_93622_) {
            this.onHoverChange(mouseX, mouseY, this.f_93622_);
        }
    }

    public boolean setHovered(int mouseX, int mouseY) {
        this.f_93622_ = mouseX >= this.x() && mouseX < this.x() + this.m_5711_() && mouseY >= this.y() && mouseY < this.y() + this.m_93694_();
        return this.f_93622_;
    }

    public void setRenderStyle(DynamicGuiRenderer.AreaStyle style) {
        this.style = style;
        if (style.isCustom()) {
            this.setBackColor(-12040120);
        }
    }

    public DynamicGuiRenderer.AreaStyle getStyle() {
        return this.style;
    }

    public void setTextShadow(boolean b) {
        this.textShadow = b;
    }

    public boolean isRenderingTextShadow() {
        return this.textShadow;
    }

    public void setTextAlignment(EAlignment alignment) {
        this.textAlign = alignment;
    }

    public EAlignment getTextAlignment() {
        return this.textAlign;
    }

    @Override
    public DLContextMenu getContextMenu() {
        return this.menu;
    }

    @Override
    public void onFocusChangeEvent(boolean focus) {
        this.m_93692_(focus);
    }

    @Override
    public boolean isMouseSelected() {
        return this.mouseSelected;
    }

    @Override
    public void setMouseSelected(boolean selected) {
        this.mouseSelected = selected;
    }

    public int getBackColor() {
        return this.backColor;
    }

    public int getFontColor() {
        return this.fontColor;
    }

    public void setBackColor(int color) {
        this.backColor = color;
    }

    public void setFontColor(int color) {
        this.fontColor = color;
    }

    @Override
    public int x() {
        return this.m_252754_();
    }

    @Override
    public int y() {
        return this.m_252907_();
    }

    @Override
    public void set_x(int x) {
        this.m_252865_(x);
    }

    @Override
    public void set_y(int y) {
        this.m_253211_(y);
    }

    @Override
    public void set_width(int w) {
        this.f_93618_ = w;
    }

    @Override
    public void set_height(int h) {
        this.f_93619_ = h;
    }

    @Override
    public void set_visible(boolean b) {
        this.f_93624_ = b;
    }

    @Override
    public boolean visible() {
        return this.f_93624_;
    }

    @Override
    public void set_active(boolean b) {
        this.f_93623_ = b;
    }

    @Override
    public boolean active() {
        return super.m_142518_();
    }

    @Override
    public int width() {
        return this.f_93618_;
    }

    @Override
    public int height() {
        return this.f_93619_;
    }
}

