/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLAbstractImageButton;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.client.util.WidgetsCollection;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class DLIconButton
extends DLAbstractImageButton<DLIconButton> {
    public static final int DEFAULT_BUTTON_WIDTH = 18;
    public static final int DEFAULT_BUTTON_HEIGHT = 18;
    private Sprite sprite;

    public DLIconButton(DLAbstractImageButton.ButtonType type, DynamicGuiRenderer.AreaStyle color, Sprite sprite, WidgetsCollection collection, int pX, int pY, int w, int h, Component pMessage, Consumer<DLIconButton> onClick) {
        super(type, color, collection, pX, pY, w, h, pMessage, onClick);
        this.sprite = sprite;
        if (color == DynamicGuiRenderer.AreaStyle.NATIVE) {
            this.setFontColor(-1);
        } else {
            this.setFontColor(-12566464);
        }
    }

    public DLIconButton(DLAbstractImageButton.ButtonType type, DynamicGuiRenderer.AreaStyle color, Sprite sprite, int x, int y, int w, int h, Component pMessage, Consumer<DLIconButton> onClick) {
        this(type, color, sprite, null, x, y, w, h, pMessage, onClick);
    }

    public DLIconButton(DLAbstractImageButton.ButtonType type, DynamicGuiRenderer.AreaStyle color, Sprite sprite, WidgetsCollection collection, int x, int y, Component pMessage, Consumer<DLIconButton> onClick) {
        this(type, color, sprite, collection, x, y, 18, 18, pMessage, onClick);
    }

    public DLIconButton(DLAbstractImageButton.ButtonType type, DynamicGuiRenderer.AreaStyle color, Sprite sprite, int x, int y, Component pMessage, Consumer<DLIconButton> onClick) {
        this(type, color, sprite, x, y, 18, 18, pMessage, onClick);
    }

    @Override
    public void renderImage(Graphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        int labelWidth = 0;
        switch (this.getAlignment()) {
            case LEFT: {
                this.sprite.render(graphics, this.x() + 2, this.y() + this.height() / 2 - this.sprite.getHeight() / 2);
                if (this.m_6035_() == null) break;
                int n = this.x() + 2 + (this.sprite.isEmpty() ? 0 : this.sprite.getWidth() + 4);
                int n2 = this.y() + this.height() / 2;
                Objects.requireNonNull(this.font);
                GuiUtils.drawString(graphics, this.font, n, n2 - 9 / 2, (FormattedText)this.m_6035_(), this.getFontColor(), EAlignment.LEFT, this.isRenderingTextShadow());
                break;
            }
            case RIGHT: {
                if (this.m_6035_() != null && !this.m_6035_().getString().isEmpty()) {
                    labelWidth = this.font.m_92852_((FormattedText)this.m_6035_()) + 4;
                }
                this.sprite.render(graphics, this.x() + this.width() - 2 - labelWidth - this.sprite.getWidth(), this.y() + this.height() / 2 - this.sprite.getHeight() / 2);
                if (this.m_6035_() == null) break;
                int n = this.x() + this.width() - 2;
                int n3 = this.y() + this.height() / 2;
                Objects.requireNonNull(this.font);
                GuiUtils.drawString(graphics, this.font, n, n3 - 9 / 2, (FormattedText)this.m_6035_(), this.getFontColor(), EAlignment.LEFT, this.isRenderingTextShadow());
                break;
            }
            default: {
                if (this.m_6035_() != null && !this.m_6035_().getString().isEmpty()) {
                    labelWidth = this.font.m_92852_((FormattedText)this.m_6035_()) + 4;
                }
                this.sprite.render(graphics, this.x() + this.width() / 2 - this.sprite.getWidth() / 2 - labelWidth / 2, this.y() + this.height() / 2 - this.sprite.getHeight() / 2);
                if (this.m_6035_() == null) break;
                int n = this.x() + this.width() / 2 + this.sprite.getWidth() / 2 - labelWidth / 2 + (this.sprite.isEmpty() ? 0 : 4);
                int n4 = this.y() + this.height() / 2;
                Objects.requireNonNull(this.font);
                GuiUtils.drawString(graphics, this.font, n, n4 - 9 / 2, (FormattedText)this.m_6035_(), this.getFontColor(), EAlignment.LEFT, this.isRenderingTextShadow());
            }
        }
    }

    public void setSprite(Sprite sprite) {
        this.sprite = sprite;
    }

    public Sprite getSprite() {
        return this.sprite;
    }
}

