/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.DLButton;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenuItem;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLEditBox;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLWidgetContainer;
import de.mrjulsen.mcdragonlib.client.render.DynamicGuiRenderer;
import de.mrjulsen.mcdragonlib.client.render.Sprite;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.MathUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;

public class DLNumberSelector
extends DLWidgetContainer {
    private static final int DROP_DOWN_BUTTON_WIDTH = 13;
    private DLEditBox innerTextBox;
    private double min = 0.0;
    private double max = 100.0;
    private double value = 0.0;
    private boolean useDecimals = false;
    private final BiConsumer<DLNumberSelector, Double> onNumberChanged;
    private final DLNumberSelector instance = this;
    protected DLContextMenu menu = new DLContextMenu(() -> GuiAreaDefinition.of(this), () -> {
        DLContextMenuItem.Builder builder = new DLContextMenuItem.Builder();
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.menu.cut"), Sprite.empty(), this.innerTextBox.m_94204_() && !this.innerTextBox.m_94173_().isEmpty(), b -> {
            Minecraft.m_91087_().f_91068_.m_90911_(this.innerTextBox.m_94173_());
            if (this.innerTextBox.m_94204_()) {
                this.innerTextBox.m_94164_("");
            }
        }, null));
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.menu.copy"), Sprite.empty(), this.innerTextBox.m_94204_() && !this.innerTextBox.m_94173_().isEmpty(), b -> Minecraft.m_91087_().f_91068_.m_90911_(this.innerTextBox.m_94173_()), null));
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.menu.paste"), Sprite.empty(), this.innerTextBox.m_94204_(), b -> {
            if (this.innerTextBox.m_94204_()) {
                this.innerTextBox.m_94164_(Minecraft.m_91087_().f_91068_.m_90876_());
            }
        }, null));
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.menu.delete"), Sprite.empty(), !this.innerTextBox.m_94155_().isEmpty(), b -> this.innerTextBox.m_94144_(""), null));
        builder.addSeparator();
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.menu.select_all"), Sprite.empty(), true, b -> {
            this.innerTextBox.m_94201_();
            this.innerTextBox.m_94208_(0);
        }, null));
        builder.addSeparator();
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.menu.decrement"), Sprite.empty(), true, b -> this.decrement(), null));
        builder.add(new DLContextMenuItem.ContextMenuItemData((Component)TextUtils.translate("gui.dragonlib.menu.increment"), Sprite.empty(), true, b -> this.increment(), null));
        return builder;
    });
    private boolean isUpdating = true;

    public DLNumberSelector(int x, int y, int width, int height, double initialValue, boolean showButtons, BiConsumer<DLNumberSelector, Double> onNumberChanged) {
        super(x, y, width, height);
        this.innerTextBox = new DLEditBox(this.font, x + 1, y + 1, width - 2 - (showButtons ? 13 : 0), height - 2, (Component)TextUtils.empty()){

            @Override
            public void setMouseSelected(boolean selected) {
                super.setMouseSelected(selected);
                DLNumberSelector.this.instance.setMouseSelected(selected);
            }
        };
        this.innerTextBox.setMenu(null);
        this.innerTextBox.m_94153_(this::isNumber);
        this.innerTextBox.m_94151_(text -> {
            if (!this.isUpdating) {
                this.setValue((String)text, false);
            }
            this.isUpdating = false;
        });
        this.innerTextBox.withOnFocusChanged((box, focus) -> {
            if (!focus.booleanValue()) {
                this.setValue(box.m_94155_(), true);
            }
        });
        this.setValue(initialValue, true);
        this.addRenderableWidget(this.innerTextBox);
        if (showButtons) {
            int usableHeight = height - 2;
            int heightA = usableHeight / 2;
            DLButton btn1 = this.addRenderableWidget(new DLButton(x + width - 13, y + 1, 12, heightA, (Component)TextUtils.text("+"), btn -> this.increment()){

                @Override
                public void setMouseSelected(boolean selected) {
                    super.setMouseSelected(selected);
                    DLNumberSelector.this.instance.setMouseSelected(selected);
                }
            });
            btn1.setRenderStyle(DynamicGuiRenderer.AreaStyle.GRAY);
            DLButton btn2 = this.addRenderableWidget(new DLButton(x + width - 13, y + 1 + heightA, 12, usableHeight - heightA, (Component)TextUtils.text("-"), btn -> this.decrement()){

                @Override
                public void setMouseSelected(boolean selected) {
                    super.setMouseSelected(selected);
                    DLNumberSelector.this.instance.setMouseSelected(selected);
                }
            });
            btn2.setRenderStyle(DynamicGuiRenderer.AreaStyle.GRAY);
        }
        this.setMenu(this.menu);
        this.onNumberChanged = onNumberChanged;
    }

    public void setNumberBounds(double min, double max) {
        this.min = min;
        this.max = max;
    }

    protected boolean isNumber(String input) {
        if (input.isEmpty()) {
            return true;
        }
        String i = input;
        if (input.equals("-")) {
            i = "-0";
        }
        try {
            double d = this.useDecimals ? Double.parseDouble(i) : (double)Integer.parseInt(i);
            return d >= this.min && d <= this.max;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public double getValue() {
        return this.value;
    }

    public int getAsInt() {
        return (int)this.value;
    }

    public void setValue(String text, boolean updateTextbox) {
        double d = 0.0;
        try {
            d = Double.parseDouble(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setValue(d, updateTextbox);
    }

    public void setValue(double value, boolean updateTextbox) {
        this.value = value;
        if (updateTextbox) {
            this.innerTextBox.m_94144_(this.useDecimals ? String.valueOf(value) : String.valueOf((int)value));
        }
        if (this.onNumberChanged != null) {
            this.onNumberChanged.accept(this, value);
        }
    }

    public double increment() {
        double val = MathUtils.clamp(this.value += 1.0, this.min, this.max);
        this.setValue(val, true);
        return val;
    }

    public double decrement() {
        double val = MathUtils.clamp(this.value -= 1.0, this.min, this.max);
        this.setValue(val, true);
        return val;
    }

    @Override
    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.fill(graphics, this.x, this.y, this.width, this.height, this.innerTextBox.m_93696_() ? -1 : -6381922);
        GuiUtils.fill(graphics, this.x + 1, this.y + 1, this.width - 2, this.height - 2, -16777216);
        super.renderMainLayer(graphics, mouseX, mouseY, partialTicks);
    }

    public NarratableEntry.NarrationPriority m_142684_() {
        return NarratableEntry.NarrationPriority.HOVERED;
    }

    public void m_142291_(NarrationElementOutput narrationElementOutput) {
    }

    @Override
    public DLContextMenu getContextMenu() {
        return this.menu;
    }

    @Override
    public boolean consumeScrolling(double mouseX, double mouseY) {
        return true;
    }
}

