/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.FormattedText;

public class DLTooltip {
    public static final int WIDTH_UNDEFINED = -1;
    private final List<FormattedText> lines;
    protected int maxWidth = -1;
    protected GuiAreaDefinition assignedArea = null;
    protected AbstractWidget assignedWidget = null;
    protected boolean visible = true;
    protected Supplier<Integer> dynamicOffsetX;
    protected Supplier<Integer> dynamicOffsetY;

    protected DLTooltip(List<FormattedText> lines) {
        this.lines = lines;
    }

    public static DLTooltip empty() {
        return DLTooltip.of((FormattedText)null);
    }

    public static DLTooltip of(String text) {
        return new DLTooltip(text == null ? null : List.of(TextUtils.text(text)));
    }

    public static DLTooltip of(Collection<String> text) {
        return new DLTooltip(text.stream().map(x -> TextUtils.text(x)).toList());
    }

    public static DLTooltip of(String ... texts) {
        return new DLTooltip(Arrays.stream(texts).map(x -> TextUtils.text(x)).toList());
    }

    public static DLTooltip of(FormattedText formattedText) {
        return new DLTooltip(formattedText == null ? null : List.of(formattedText));
    }

    public static DLTooltip of(List<FormattedText> formattedTexts) {
        return new DLTooltip(formattedTexts);
    }

    public static DLTooltip of(FormattedText ... formattedTexts) {
        return new DLTooltip(Arrays.stream(formattedTexts).toList());
    }

    public static <E extends Enum<E>> DLTooltip of(String modid, Class<E> enumClass) {
        return new DLTooltip(GuiUtils.getEnumTooltipData(modid, enumClass).stream().map(x -> x).toList());
    }

    public DLTooltip withMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
        return this;
    }

    public DLTooltip assignedTo(AbstractWidget widget) {
        this.assignedWidget = widget;
        return this;
    }

    public DLTooltip assignedTo(GuiAreaDefinition area) {
        this.assignedArea = area;
        return this;
    }

    public DLTooltip withVisibility(boolean b) {
        this.visible = b;
        return this;
    }

    public GuiAreaDefinition getAssignedArea() {
        return this.assignedArea;
    }

    public AbstractWidget getAssignedWidget() {
        return this.assignedWidget;
    }

    public List<FormattedText> getLines() {
        return this.lines;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setDynamicOffset(Supplier<Integer> offsetX, Supplier<Integer> offsetY) {
        this.dynamicOffsetX = offsetX;
        this.dynamicOffsetY = offsetY;
    }

    public Supplier<Integer> getDynamicOffsetX() {
        return this.dynamicOffsetX;
    }

    public Supplier<Integer> getDynamicOffsetY() {
        return this.dynamicOffsetY;
    }

    public void render(Screen screen, Graphics graphics, int mouseX, int mouseY) {
        this.render(screen, graphics, mouseX + 8, mouseY - 16, mouseX, mouseY, this.getDynamicOffsetX() == null ? 0 : this.getDynamicOffsetX().get(), this.getDynamicOffsetY() == null ? 0 : this.getDynamicOffsetY().get());
    }

    public void render(Screen screen, Graphics graphics, int x, int y, int mouseX, int mouseY, int xOffset, int yOffset) {
        if (this.lines.size() <= 0) {
            return;
        }
        if (this.assignedWidget != null) {
            IDragonLibWidget wgt;
            AbstractWidget abstractWidget = this.assignedWidget;
            if (abstractWidget instanceof IDragonLibWidget && (wgt = (IDragonLibWidget)abstractWidget).isMouseSelected() || this.assignedWidget.f_93624_ && this.assignedWidget.m_5953_((double)mouseX, (double)mouseY)) {
                GuiUtils.renderTooltipAt(screen, GuiAreaDefinition.of(this.assignedWidget), this.getLines(), this.getMaxWidth() > 0 ? this.getMaxWidth() : screen.f_96543_, graphics, x, y, mouseX, mouseY, xOffset, yOffset);
            }
        } else if (this.assignedArea != null) {
            GuiUtils.renderTooltipAt(screen, this.assignedArea, this.getLines(), this.getMaxWidth() > 0 ? this.getMaxWidth() : screen.f_96543_, graphics, x, y, mouseX, mouseY, xOffset, yOffset);
        } else {
            GuiUtils.renderTooltipAt(screen, GuiAreaDefinition.of(screen), this.getLines(), this.getMaxWidth() > 0 ? this.getMaxWidth() : screen.f_96543_, graphics, x, y, mouseX, mouseY, xOffset, yOffset);
        }
    }
}

