/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.client.gui.widgets;

import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IExtendedAreaWidget;
import de.mrjulsen.mcdragonlib.client.util.GuiAreaDefinition;
import de.mrjulsen.mcdragonlib.data.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.navigation.ScreenPosition;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.client.gui.screens.Screen;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector2i;

public interface IDragonLibContainer<T extends ContainerEventHandler & IDragonLibContainer<T>>
extends IDragonLibWidget {
    public static final int DEFAULT_LAYER_INDEX = 0;

    private T get() {
        return (T)((ContainerEventHandler)this);
    }

    public void setAllowedLayer(int var1);

    public int getAllowedLayer();

    public void setWidgetLayerIndex(int var1);

    public int getWidgetLayerIndex();

    default public void mouseSelectEvent(int mouseX, int mouseY) {
        GuiEventListener guiEventListener;
        this.unselectAll();
        Optional<GuiEventListener> listener = ((IDragonLibContainer)this.get()).getChildAtImpl(mouseX, mouseY);
        if (listener.isPresent() && (guiEventListener = listener.get()) instanceof IDragonLibWidget) {
            IDragonLibWidget widget = (IDragonLibWidget)guiEventListener;
            widget.setMouseSelected(true);
        }
    }

    public boolean consumeScrolling(double var1, double var3);

    private void unselectAll() {
        this.childrenLayered().forEach(x -> {
            if (x instanceof IDragonLibWidget) {
                IDragonLibWidget widget = (IDragonLibWidget)x;
                if (widget instanceof IDragonLibContainer) {
                    IDragonLibContainer container = (IDragonLibContainer)widget;
                    container.unselectAll();
                }
                widget.setMouseSelected(false);
            }
        });
    }

    default public Optional<GuiEventListener> getChildAtImpl(int mouseX, int mouseY) {
        Optional<GuiEventListener> menu = this.getContextMenuChildAtImpl(mouseX, mouseY);
        if (menu.isPresent()) {
            return menu;
        }
        ListIterator<GuiEventListener> iterator = this.childrenLayered().listIterator(this.childrenLayered().size());
        while (iterator.hasPrevious()) {
            IDragonLibContainer handler;
            Optional<GuiEventListener> child;
            GuiEventListener guiEventListener = iterator.previous();
            if (!guiEventListener.m_5953_((double)mouseX, (double)mouseY)) continue;
            if (guiEventListener instanceof IDragonLibContainer && (child = (handler = (IDragonLibContainer)guiEventListener).getChildAtImpl(mouseX, mouseY)).isPresent()) {
                return child;
            }
            return Optional.of(guiEventListener);
        }
        return Optional.empty();
    }

    default public Optional<GuiEventListener> getContextMenuChildAtImpl(int mouseX, int mouseY) {
        if (this.getContextMenu() != null && this.getContextMenu().isOpen()) {
            return Optional.of(this.getContextMenu());
        }
        ListIterator<GuiEventListener> iterator = this.childrenLayered().listIterator(this.childrenLayered().size());
        while (iterator.hasPrevious()) {
            IDragonLibWidget widget;
            Optional<GuiEventListener> listener;
            GuiEventListener guiEventListener = iterator.previous();
            if (guiEventListener instanceof IDragonLibContainer && (listener = (widget = (IDragonLibContainer)guiEventListener).getContextMenuChildAtImpl(mouseX, mouseY)).isPresent()) {
                return listener;
            }
            if (!(guiEventListener instanceof IDragonLibWidget) || (widget = (IDragonLibWidget)guiEventListener).getContextMenu() == null || !widget.getContextMenu().isOpen()) continue;
            return Optional.of(widget.getContextMenu());
        }
        return Optional.empty();
    }

    default public List<GuiEventListener> getWidgetsReversed() {
        LinkedList<GuiEventListener> listeners = new LinkedList<GuiEventListener>(this.childrenLayered());
        Collections.reverse(listeners);
        IDragonLibContainer iDragonLibContainer = this;
        if (iDragonLibContainer instanceof GuiEventListener) {
            GuiEventListener l = (GuiEventListener)iDragonLibContainer;
            listeners.add(l);
        }
        return listeners;
    }

    default public List<? extends GuiEventListener> childrenLayered() {
        return this.get().m_6702_().stream().filter(x -> {
            IDragonLibContainer container;
            if (!(x instanceof IDragonLibContainer) || (container = (IDragonLibContainer)x).getWidgetLayerIndex() < this.getAllowedLayer()) {
                if (this.getAllowedLayer() != 0) return false;
            }
            if (x instanceof IDragonLibWidget) {
                IDragonLibWidget wdgt = (IDragonLibWidget)x;
                if (wdgt.visible()) return true;
            }
            if (!(x instanceof AbstractWidget)) return false;
            AbstractWidget absw = (AbstractWidget)x;
            if (!absw.f_93624_) return false;
            return true;
        }).toList();
    }

    default public boolean checkWidgetBounds() {
        return false;
    }

    default public Pair<Double, Double> checkWidgetBoundsOffset() {
        return Pair.of(0.0, 0.0);
    }

    default public boolean contextMenuMouseClickEvent(Screen screen, IDragonLibContainer<?> parent, int mouseX, int mouseY, int xOffset, int yOffset, int button, GuiAreaDefinition openingBounds) {
        List<GuiEventListener> listeners = this.getWidgetsReversed();
        for (GuiEventListener listener : listeners) {
            IDragonLibWidget widget;
            if (listener instanceof IDragonLibContainer) {
                IDragonLibContainer container = (IDragonLibContainer)listener;
                if (listener != this && container.contextMenuMouseClickEvent(screen, container, mouseX, mouseY, xOffset, yOffset, button, openingBounds)) {
                    return true;
                }
            }
            if (!(listener instanceof IDragonLibWidget) || !(widget = (IDragonLibWidget)listener).contextMenuMouseClickHandler(mouseX, mouseY, button, xOffset, yOffset, openingBounds)) continue;
            this.closeAllContextMenus((ContainerEventHandler)screen, widget);
            return true;
        }
        if (parent == screen) {
            this.closeAllContextMenus((ContainerEventHandler)screen, null);
        }
        return false;
    }

    default public void closeAllContextMenus(ContainerEventHandler container, IDragonLibWidget excluded) {
        IDragonLibContainer cont;
        container.m_6702_().forEach(x -> {
            IDragonLibWidget widget;
            IDragonLibContainer dlContainer;
            if (x == excluded) {
                return;
            }
            if (x instanceof IDragonLibContainer && (dlContainer = (IDragonLibContainer)x) instanceof ContainerEventHandler) {
                ContainerEventHandler childContainer = (ContainerEventHandler)dlContainer;
                this.closeAllContextMenus(childContainer, excluded);
            }
            if (x instanceof IDragonLibWidget && (widget = (IDragonLibWidget)x).getContextMenu() != null) {
                widget.getContextMenu().close();
            }
        });
        if (container != excluded && container instanceof IDragonLibContainer && (cont = (IDragonLibContainer)container).getContextMenu() != null) {
            cont.getContextMenu().close();
        }
    }

    default public boolean containerMouseScrolled(double mouseX, double mouseY, double delta) {
        List<GuiEventListener> listeners = this.childrenLayered();
        for (GuiEventListener listener : listeners) {
            IDragonLibWidget widget;
            if (listener instanceof IDragonLibContainer) {
                IDragonLibContainer container = (IDragonLibContainer)listener;
                if (listener != this && listener.m_5953_(mouseX, mouseY) && container.containerMouseScrolled(mouseX, mouseY, delta)) {
                    return true;
                }
            }
            if (listener instanceof IDragonLibWidget) {
                IExtendedAreaWidget ext;
                widget = (IDragonLibWidget)listener;
                if ((listener instanceof IExtendedAreaWidget && (ext = (IExtendedAreaWidget)listener).isInArea(mouseX, mouseY) || widget.isMouseSelected()) && listener.m_6050_(mouseX, mouseY, delta)) {
                    return true;
                }
            }
            if (!(listener instanceof AbstractWidget) || !(widget = (AbstractWidget)listener).m_5953_(mouseX, mouseY) || !widget.m_6050_(mouseX, mouseY, delta)) continue;
            return true;
        }
        return this.consumeScrolling(mouseX, mouseY);
    }

    default public ComponentPath dragonlib$nextFocusPath(FocusNavigationEvent event) {
        ComponentPath componentPath;
        GuiEventListener guiEventListener = this.get().m_7222_();
        if (guiEventListener != null && (componentPath = guiEventListener.m_264064_(event)) != null) {
            return ComponentPath.m_264334_(this.get(), (ComponentPath)componentPath);
        }
        if (event instanceof FocusNavigationEvent.TabNavigation) {
            FocusNavigationEvent.TabNavigation tabNavigation = (FocusNavigationEvent.TabNavigation)event;
            return this.dragonlib$handleTabNavigation(tabNavigation);
        }
        if (event instanceof FocusNavigationEvent.ArrowNavigation) {
            FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)event;
            return this.dragonlib$handleArrowNavigation(arrowNavigation);
        }
        return null;
    }

    private ComponentPath dragonlib$handleTabNavigation(FocusNavigationEvent.TabNavigation pTabNavigation) {
        Supplier<GuiEventListener> supplier;
        BooleanSupplier booleansupplier;
        boolean flag = pTabNavigation.f_263782_();
        GuiEventListener guieventlistener = this.get().m_7222_();
        ArrayList<GuiEventListener> list = new ArrayList<GuiEventListener>(this.childrenLayered());
        Collections.sort(list, Comparator.comparingInt(p_289623_ -> p_289623_.m_267579_()));
        int j = list.indexOf(guieventlistener);
        int i = guieventlistener != null && j >= 0 ? j + (flag ? 1 : 0) : (flag ? 0 : list.size());
        ListIterator listiterator = list.listIterator(i);
        BooleanSupplier booleanSupplier = flag ? listiterator::hasNext : (booleansupplier = listiterator::hasPrevious);
        Supplier<GuiEventListener> supplier2 = flag ? listiterator::next : (supplier = listiterator::previous);
        while (booleansupplier.getAsBoolean()) {
            GuiEventListener guieventlistener1 = supplier.get();
            ComponentPath componentpath = guieventlistener1.m_264064_((FocusNavigationEvent)pTabNavigation);
            if (componentpath == null) continue;
            return ComponentPath.m_264334_(this.get(), (ComponentPath)componentpath);
        }
        return null;
    }

    private ComponentPath dragonlib$handleArrowNavigation(FocusNavigationEvent.ArrowNavigation pArrowNavigation) {
        GuiEventListener guieventlistener = this.get().m_7222_();
        if (guieventlistener == null) {
            ScreenDirection screendirection = pArrowNavigation.f_263812_();
            ScreenRectangle screenrectangle1 = this.get().m_264198_().m_264525_(screendirection.m_264089_());
            return ComponentPath.m_264334_(this.get(), (ComponentPath)this.nextFocusPathInDirection(screenrectangle1, screendirection, null, (FocusNavigationEvent)pArrowNavigation));
        }
        ScreenRectangle screenrectangle = guieventlistener.m_264198_();
        return ComponentPath.m_264334_(this.get(), (ComponentPath)this.nextFocusPathInDirection(screenrectangle, pArrowNavigation.f_263812_(), guieventlistener, (FocusNavigationEvent)pArrowNavigation));
    }

    private ComponentPath nextFocusPathInDirection(ScreenRectangle pRectangle, ScreenDirection pDirection, @Nullable GuiEventListener pListener, FocusNavigationEvent pEvent) {
        ScreenAxis screenaxis = pDirection.m_264093_();
        ScreenAxis screenaxis1 = screenaxis.m_264385_();
        ScreenDirection screendirection = screenaxis1.m_264292_();
        int i = pRectangle.m_264095_(pDirection.m_264089_());
        ArrayList<GuiEventListener> list = new ArrayList<GuiEventListener>();
        for (GuiEventListener guieventlistener : this.childrenLayered()) {
            ScreenRectangle screenrectangle;
            if (guieventlistener == pListener || !(screenrectangle = guieventlistener.m_264198_()).m_264632_(pRectangle, screenaxis1)) continue;
            int j = screenrectangle.m_264095_(pDirection.m_264089_());
            if (pDirection.m_264526_(j, i)) {
                list.add(guieventlistener);
                continue;
            }
            if (j != i || !pDirection.m_264526_(screenrectangle.m_264095_(pDirection), pRectangle.m_264095_(pDirection))) continue;
            list.add(guieventlistener);
        }
        Comparator<GuiEventListener> comparator = Comparator.comparing(p_264674_ -> p_264674_.m_264198_().m_264095_(pDirection.m_264089_()), pDirection.m_264394_());
        Comparator<GuiEventListener> comparator1 = Comparator.comparing(p_264676_ -> p_264676_.m_264198_().m_264095_(screendirection.m_264089_()), screendirection.m_264394_());
        list.sort(comparator.thenComparing(comparator1));
        for (GuiEventListener guieventlistener1 : list) {
            ComponentPath componentpath = guieventlistener1.m_264064_(pEvent);
            if (componentpath == null) continue;
            return componentpath;
        }
        return this.nextFocusPathVaguelyInDirection(pRectangle, pDirection, pListener, pEvent);
    }

    private ComponentPath nextFocusPathVaguelyInDirection(ScreenRectangle pRectangle, ScreenDirection pDirection, @Nullable GuiEventListener pListener, FocusNavigationEvent pEvent) {
        ScreenAxis screenaxis = pDirection.m_264093_();
        ScreenAxis screenaxis1 = screenaxis.m_264385_();
        ArrayList<Pair> list = new ArrayList<Pair>();
        ScreenPosition screenposition = ScreenPosition.m_264208_((ScreenAxis)screenaxis, (int)pRectangle.m_264095_(pDirection), (int)pRectangle.m_264037_(screenaxis1));
        for (GuiEventListener guieventlistener : this.childrenLayered()) {
            ScreenRectangle screenrectangle;
            ScreenPosition screenposition1;
            if (guieventlistener == pListener || !pDirection.m_264526_((screenposition1 = ScreenPosition.m_264208_((ScreenAxis)screenaxis, (int)(screenrectangle = guieventlistener.m_264198_()).m_264095_(pDirection.m_264089_()), (int)screenrectangle.m_264037_(screenaxis1))).m_264196_(screenaxis), screenposition.m_264196_(screenaxis))) continue;
            long i = Vector2i.distanceSquared((int)screenposition.f_263719_(), (int)screenposition.f_263694_(), (int)screenposition1.f_263719_(), (int)screenposition1.f_263694_());
            list.add(Pair.of(guieventlistener, i));
        }
        list.sort(Comparator.comparingDouble(Pair::getSecond));
        for (Pair pair : list) {
            ComponentPath componentpath = ((GuiEventListener)pair.getFirst()).m_264064_(pEvent);
            if (componentpath == null) continue;
            return componentpath;
        }
        return null;
    }

    public void close() throws Exception;
}

