/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.data;

import de.mrjulsen.mcdragonlib.config.ECachingPriority;
import java.util.Optional;
import java.util.function.Supplier;

public class Cache<T> {
    private T obj = null;
    private final transient Supplier<T> provider;
    private final transient ECachingPriority priority;

    public Cache(Supplier<T> provider, ECachingPriority priority) {
        this.provider = provider;
        this.priority = priority;
    }

    public Cache(Supplier<T> provider) {
        this(provider, ECachingPriority.NORMAL);
    }

    public boolean isCached() {
        return this.obj != null;
    }

    public T get() {
        if (!this.priority.shouldCache()) {
            this.clear();
            return this.provider.get();
        }
        return !this.isCached() ? (this.obj = this.provider.get()) : this.obj;
    }

    public Optional<T> getIfAvailable() {
        return !this.isCached() ? Optional.empty() : Optional.of(this.obj);
    }

    public void clear() {
        this.obj = null;
    }
}

