/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.platform.NativeImage;
import de.mrjulsen.mcdragonlib.DragonLib;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.function.Consumer;
import javax.imageio.ImageIO;
import net.minecraft.advancements.Advancement;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.codec.binary.Base64;

public final class DLUtils {
    public static UUID getPlayerUUID(String playername) {
        try {
            URL url = new URL("https://api.mojang.com/users/profiles/minecraft/" + playername);
            Scanner scan = new Scanner(url.openStream());
            Object str = "";
            while (scan.hasNext()) {
                str = (String)str + scan.nextLine();
            }
            scan.close();
            JsonObject player = (JsonObject)new Gson().fromJson((String)str, JsonObject.class);
            return UUID.fromString(player.get("id").getAsString());
        }
        catch (Exception e) {
            DragonLib.LOGGER.warn("Could not get UUID for player with username " + playername, (Throwable)e);
            return new UUID(0L, 0L);
        }
    }

    public static String getPlayerName(UUID uuid) {
        try {
            URL url = new URL("https://sessionserver.mojang.com/session/minecraft/profile/" + String.valueOf(uuid));
            Scanner scan = new Scanner(url.openStream());
            Object str = "";
            while (scan.hasNext()) {
                str = (String)str + scan.nextLine();
            }
            scan.close();
            JsonObject player = (JsonObject)new Gson().fromJson((String)str, JsonObject.class);
            String username = player.get("name").getAsString();
            return username;
        }
        catch (Exception e) {
            DragonLib.LOGGER.warn("Could not get username for player with UUID " + String.valueOf(uuid), (Throwable)e);
            return "Unknown User";
        }
    }

    @Deprecated(forRemoval=true)
    public static String getUUID(String playername) {
        return DLUtils.getPlayerUUID(playername).toString();
    }

    @Deprecated(forRemoval=true)
    public static String getPlayerName(String uuid) {
        return DLUtils.getPlayerName(UUID.fromString(uuid));
    }

    public static void giveAdvancement(ServerPlayer player, String modid, String name, String criteriaKey) {
        Advancement adv = player.m_20194_().m_129889_().m_136041_(new ResourceLocation(modid, name));
        player.m_8960_().m_135988_(adv, criteriaKey);
    }

    public static int coordsToInt(byte x, byte y) {
        int coords = (x & 0xFF) << 16 | y & 0xFF;
        return coords;
    }

    public static byte[] intToCoords(int coords) {
        byte x = (byte)(coords >> 16 & 0xFF);
        byte y = (byte)(coords & 0xFF);
        return new byte[]{x, y};
    }

    public static String textureToBase64(NativeImage image) {
        try {
            return Base64.encodeBase64String((byte[])image.m_85121_());
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static InputStream scaleImage(InputStream inputStream, int width, int height) throws IOException {
        BufferedImage originalImage = ImageIO.read(inputStream);
        BufferedImage scaledImage = new BufferedImage(width, height, 2);
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
        g2d.drawImage(originalImage, 0, 0, width, height, null);
        g2d.dispose();
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)scaledImage, "png", outputStream);
        byte[] imageBytes = outputStream.toByteArray();
        return new ByteArrayInputStream(imageBytes);
    }

    public static long encodeCoordinates(int x, int y, int z) {
        long encodedValue = 0L;
        encodedValue |= ((long)x & 0xFFFFFFFFL) << 32;
        encodedValue |= ((long)y & 0xFFFFFFFFL) << 16;
        return encodedValue |= (long)z & 0xFFFFFFFFL;
    }

    public static int[] decodeCoordinates(long encodedValue) {
        int x = (int)(encodedValue >> 32);
        int y = (int)(encodedValue >> 16 & 0xFFFFL);
        int z = (int)(encodedValue & 0xFFFFL);
        return new int[]{x, y, z};
    }

    public static boolean rotateBlock(Level world, BlockPos pos, Rotation rotation) {
        BlockState state = world.m_8055_(pos);
        BlockState newState = state.m_60717_(rotation);
        if (newState != state) {
            BlockPos otherPos;
            BlockState otherState;
            world.m_46597_(pos, newState);
            for (Direction d : BlockStateProperties.f_61374_.m_6908_()) {
                BlockState nextState = newState.m_60728_(d, otherState = world.m_8055_(otherPos = pos.m_121945_(d)), (LevelAccessor)world, pos, otherPos);
                if (nextState == newState) continue;
                if (!nextState.m_60795_()) {
                    world.m_46597_(pos, nextState);
                    newState = nextState;
                    continue;
                }
                world.m_46597_(pos, state);
                return false;
            }
            for (Direction d : BlockStateProperties.f_61374_.m_6908_()) {
                otherPos = pos.m_121945_(d);
                otherState = world.m_8055_(otherPos);
                BlockState nextOther = otherState.m_60728_(d.m_122424_(), newState, (LevelAccessor)world, otherPos, pos);
                if (nextOther == otherState) continue;
                world.m_46597_(otherPos, nextOther);
            }
            return true;
        }
        return false;
    }

    public static <T> void doIfNotNull(T obj, Consumer<T> action) {
        if (obj != null) {
            action.accept(obj);
        }
    }

    public static <T> void doIfNotNull(Optional<T> obj, Consumer<T> action) {
        if (obj != null && obj.isPresent()) {
            action.accept(obj.get());
        }
    }

    public static boolean rectanglesIntersecting(double x1, double y1, double w1, double h1, double x2, double y2, double w2, double h2) {
        return x1 < x2 + w2 && y1 < y2 + h2 && x1 + w1 > x2 && y1 + h1 > y2;
    }

    public static void putNbtBlockPos(CompoundTag compound, String name, BlockPos pos) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("X", pos.m_123341_());
        nbt.m_128405_("Y", pos.m_123342_());
        nbt.m_128405_("Z", pos.m_123343_());
        compound.m_128365_(name, (Tag)nbt);
    }

    public static SectionPos getNbtSectionPos(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return SectionPos.m_123173_((int)nbt.m_128451_("X"), (int)nbt.m_128451_("Y"), (int)nbt.m_128451_("Z"));
    }

    public static void putNbtSectionPos(CompoundTag compound, String name, SectionPos pos) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("X", pos.m_123341_());
        nbt.m_128405_("Y", pos.m_123342_());
        nbt.m_128405_("Z", pos.m_123343_());
        compound.m_128365_(name, (Tag)nbt);
    }

    public static ChunkPos getNbtChunkPos(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new ChunkPos(nbt.m_128451_("X"), nbt.m_128451_("Z"));
    }

    public static void putNbtChunkPos(CompoundTag compound, String name, ChunkPos pos) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("X", pos.f_45578_);
        nbt.m_128405_("Z", pos.f_45579_);
        compound.m_128365_(name, (Tag)nbt);
    }

    public static BlockPos getNbtBlockPos(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new BlockPos(nbt.m_128451_("X"), nbt.m_128451_("Y"), nbt.m_128451_("Z"));
    }

    public static void putNbtVec3(CompoundTag compound, String name, Vec3 vec) {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128347_("X", vec.m_7096_());
        nbt.m_128347_("Y", vec.m_7098_());
        nbt.m_128347_("Z", vec.m_7094_());
        compound.m_128365_(name, (Tag)nbt);
    }

    public static Vec3 getNbtVec3(CompoundTag compound, String name) {
        CompoundTag nbt = compound.m_128469_(name);
        return new Vec3(nbt.m_128459_("X"), nbt.m_128459_("Y"), nbt.m_128459_("Z"));
    }

    public boolean isSectionInChunk(SectionPos section, ChunkPos chunk) {
        return section.m_123341_() == chunk.f_45578_ && section.m_123343_() == chunk.f_45579_;
    }

    public ChunkPos getChunkOfSection(SectionPos section) {
        return new ChunkPos(section.m_123341_(), section.m_123343_());
    }
}

