/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.mcdragonlib.util.accessor;

import de.mrjulsen.mcdragonlib.DragonLib;
import de.mrjulsen.mcdragonlib.data.Single;
import de.mrjulsen.mcdragonlib.net.IPacketBase;
import de.mrjulsen.mcdragonlib.util.WorkerAsync;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessor;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessorResponsePacket;
import de.mrjulsen.mcdragonlib.util.accessor.DataAccessorType;
import dev.architectury.networking.NetworkManager;
import java.lang.reflect.InvocationTargetException;
import java.util.NoSuchElementException;
import java.util.UUID;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public abstract class AbstractDataAccessorPacket<T extends AbstractDataAccessorPacket<T, I, C, O>, I, C, O>
implements IPacketBase<T> {
    protected UUID requestId;
    protected I param;
    protected DataAccessorType<I, C, O> type;
    protected boolean sendToClient;

    public T setData(UUID id, I param, DataAccessorType<I, C, O> type, boolean sendToClient) {
        this.requestId = id;
        this.param = param;
        this.type = type;
        this.sendToClient = sendToClient;
        return (T)this;
    }

    @Override
    public void encode(T packet, FriendlyByteBuf buf) {
        buf.m_130077_(((AbstractDataAccessorPacket)packet).requestId);
        CompoundTag nbt = new CompoundTag();
        ((AbstractDataAccessorPacket)packet).encodeParam(((AbstractDataAccessorPacket)packet).param, nbt);
        buf.m_130079_(nbt);
        buf.m_130085_(((AbstractDataAccessorPacket)packet).type.getId());
        buf.writeBoolean(((AbstractDataAccessorPacket)packet).sendToClient);
    }

    @Override
    public T decode(FriendlyByteBuf buf) {
        try {
            UUID id = buf.m_130259_();
            CompoundTag nbt = buf.m_130260_();
            DataAccessorType type = DataAccessorType.get(buf.m_130281_()).get();
            boolean sendToClient = buf.readBoolean();
            return ((AbstractDataAccessorPacket)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0])).setData(id, this.decodeParam(nbt, type), type, sendToClient);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | NoSuchElementException e) {
            throw new IllegalStateException("Unable to decode network packet.", e);
        }
    }

    @Override
    public void handle(T packet, Supplier<NetworkManager.PacketContext> contextSupplier) {
        contextSupplier.get().queue(() -> {
            WorkerAsync worker = DataAccessor.getWorker(packet.sendToClient);
            worker.queueTask(() -> this.lambda$handle$0((Supplier)contextSupplier, packet));
        });
    }

    public abstract void encodeParam(I var1, CompoundTag var2);

    public abstract I decodeParam(CompoundTag var1, DataAccessorType<I, C, O> var2);

    public abstract boolean processServer(Player var1, I var2, DataAccessorType<I, C, O> var3, Single.MutableSingle<Object> var4, CompoundTag var5, int var6);

    public abstract C receiveChunk(boolean var1, C var2, int var3, CompoundTag var4);

    public abstract O processClient(C var1);

    private /* synthetic */ void lambda$handle$0(Supplier contextSupplier, AbstractDataAccessorPacket packet) {
        Single.MutableSingle<Object> tempData = new Single.MutableSingle<Object>(null);
        boolean hasMore = true;
        int iteration = 0;
        do {
            CompoundTag nbt = new CompoundTag();
            hasMore = this.processServer(((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), packet.param, packet.type, tempData, nbt, iteration);
            DataAccessorResponsePacket newPacket = new DataAccessorResponsePacket(packet.requestId, hasMore, iteration, nbt);
            if (packet.sendToClient) {
                DragonLib.getDragonLibNetworkManager().CHANNEL.sendToPlayer((ServerPlayer)((NetworkManager.PacketContext)contextSupplier.get()).getPlayer(), (Object)newPacket);
            } else {
                DragonLib.getDragonLibNetworkManager().CHANNEL.sendToServer((Object)newPacket);
            }
            ++iteration;
        } while (hasMore);
    }
}

