/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easymobfarm.gametest;

import de.markusbordihn.easymobfarm.block.MobFarmBlock;
import de.markusbordihn.easymobfarm.block.MobFarmTemplateBlock;
import de.markusbordihn.easymobfarm.gametest.GameTestHelpers;
import de.markusbordihn.easymobfarm.item.MobFarmBlockItem;
import de.markusbordihn.easymobfarm.item.MobFarmTemplateItem;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class MobFarmBlockItemTestHelper {
    private MobFarmBlockItemTestHelper() {
    }

    public static void testMobFarmBlockItem(GameTestHelper helper, Item item, Block block) {
        MobFarmBlockItemTestHelper.testMobFarmBlockItem(helper, item, -1, block);
    }

    public static void testMobFarmBlockItem(GameTestHelper helper, Item item, int tierLevel, Block block) {
        BlockPos blockPos = new BlockPos(0, 1, 0);
        ItemStack itemStack = new ItemStack((ItemLike)item);
        if (tierLevel >= 0) {
            CompoundTag tag = itemStack.m_41784_();
            tag.m_128405_("TierLevel", tierLevel);
            tag.m_128405_("CustomModelData", tierLevel);
            itemStack.m_41751_(tag);
        }
        if (itemStack.m_41720_() instanceof MobFarmBlockItem && block instanceof MobFarmBlock) {
            MobFarmBlock mobFarmBlock = (MobFarmBlock)block;
            MobFarmBlockItemTestHelper.useAndTestMobFarmBlockItem(helper, itemStack, (Block)mobFarmBlock, blockPos);
        } else if (itemStack.m_41720_() instanceof MobFarmTemplateItem && block instanceof MobFarmTemplateBlock) {
            MobFarmTemplateBlock mobFarmTemplateBlock = (MobFarmTemplateBlock)block;
            MobFarmBlockItemTestHelper.useAndTestMobFarmBlockItem(helper, itemStack, mobFarmTemplateBlock, blockPos);
        } else {
            helper.m_177284_("Item " + String.valueOf(itemStack.m_41720_()) + " is not a MobFarmBlockItem or Block " + String.valueOf(block) + " is not a MobFarmBlock");
            return;
        }
        if (tierLevel >= 0) {
            BlockState blockState = helper.m_177232_(blockPos);
            GameTestHelpers.assertTrue(helper, "Expected tier level " + tierLevel + " but found " + MobFarmBlock.getTierLevel(blockState), MobFarmBlock.getTierLevel(blockState) == tierLevel);
        }
    }

    public static void useMobFarmBlockItem(GameTestHelper helper, ItemStack mobFarmBlockItemStack, BlockPos blockPos) {
        Player player = helper.m_177368_();
        player.m_21008_(player.m_7655_(), mobFarmBlockItemStack);
        UseOnContext useOnContext = new UseOnContext(player, player.m_7655_(), new BlockHitResult(helper.m_177227_(new Vec3((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_())), Direction.UP, helper.m_177449_(blockPos), false));
        mobFarmBlockItemStack.m_41661_(useOnContext);
    }

    public static void useAndTestMobFarmBlockItem(GameTestHelper helper, ItemStack mobFarmBlockItemStack, Block mobFarmBlock, BlockPos blockPos) {
        MobFarmBlockItemTestHelper.useMobFarmBlockItem(helper, mobFarmBlockItemStack, blockPos);
        helper.m_177208_(mobFarmBlock, blockPos);
    }
}

