/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.capability;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.network.PacketDistributor;
import nl.requios.effortlessbuilding.CommonConfig;
import nl.requios.effortlessbuilding.capability.IPowerLevel;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.network.PowerLevelPacket;

public class CapabilityHandler {
    public static final ResourceLocation POWER_LEVEL_CAP = new ResourceLocation("effortlessbuilding", "power_level");
    public static final Capability<IPowerLevel> POWER_LEVEL_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPowerLevel>(){});

    public static void syncToClient(Player player) {
        IPowerLevel powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null);
        if (powerLevel == null) {
            return;
        }
        PacketHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new PowerLevelPacket(powerLevel.getPowerLevel()));
    }

    public static boolean canReplaceBlocks(Player player) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.canReplaceBlocks(player);
        }
        return false;
    }

    public static int getMaxBlocksPerAxis(Player player, boolean nextPowerLevel) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.getMaxBlocksPerAxis(player, nextPowerLevel);
        }
        return (Integer)CommonConfig.maxBlocksPerAxis.level0.get();
    }

    public static int getMaxBlocksPlacedAtOnce(Player player, boolean nextPowerLevel) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.getMaxBlocksPlacedAtOnce(player, nextPowerLevel);
        }
        return (Integer)CommonConfig.maxBlocksPlacedAtOnce.level0.get();
    }

    public static int getMaxMirrorRadius(Player player, boolean nextPowerLevel) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.getMaxMirrorRadius(player, nextPowerLevel);
        }
        return (Integer)CommonConfig.maxMirrorRadius.level0.get();
    }

    public static int getBuildModeReach(Player player) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.getBuildModeReach(player);
        }
        return (Integer)CommonConfig.maxMirrorRadius.level0.get() + 6;
    }

    public static int getPlacementReach(Player player, boolean nextPowerLevel) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.getPlacementReach(player, nextPowerLevel);
        }
        return (Integer)CommonConfig.reach.level0.get();
    }

    public static int getPowerLevel(Player player) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.getPowerLevel();
        }
        return 0;
    }

    public static int getNextPowerLevel(Player player) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.getNextPowerLevel();
        }
        return 0;
    }

    public static boolean canIncreasePowerLevel(Player player) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.canIncreasePowerLevel();
        }
        return false;
    }

    public static boolean isDisabled(Player player) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.isDisabled(player);
        }
        return false;
    }

    public static boolean canBreakFar(Player player) {
        IPowerLevel powerLevel;
        if (player != null && (powerLevel = (IPowerLevel)player.getCapability(POWER_LEVEL_CAPABILITY).orElse(null)) != null) {
            return powerLevel.canBreakFar(player);
        }
        return false;
    }
}

