/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.compatibility;

import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.items.IItemHandler;
import nl.requios.effortlessbuilding.create.foundation.item.ItemHelper;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;

public class CompatHelper {
    public static void setup() {
    }

    public static boolean isItemBlockProxy(ItemStack stack) {
        return CompatHelper.isItemBlockProxy(stack, true);
    }

    public static boolean isItemBlockProxy(ItemStack stack, boolean seeBlockItemsAsProxies) {
        Item item = stack.m_41720_();
        if (item instanceof BlockItem) {
            return seeBlockItemsAsProxies;
        }
        return item instanceof AbstractRandomizerBagItem;
    }

    public static ItemStack getItemBlockFromStack(ItemStack proxy) {
        Item proxyItem = proxy.m_41720_();
        if (proxyItem instanceof BlockItem) {
            return proxy;
        }
        if (proxyItem instanceof AbstractRandomizerBagItem) {
            ItemStack itemStack = proxy;
            while (!(itemStack.m_41720_() instanceof BlockItem) && !itemStack.m_41619_()) {
                if (!(itemStack.m_41720_() instanceof AbstractRandomizerBagItem)) continue;
                AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)itemStack.m_41720_();
                itemStack = randomizerBagItem.pickRandomStack(randomizerBagItem.getBagInventory(itemStack));
            }
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    public static ItemStack getItemBlockByState(ItemStack stack, BlockState state) {
        if (state == null) {
            return ItemStack.f_41583_;
        }
        Item blockItem = Item.m_41439_((Block)state.m_60734_());
        if (stack.m_41720_() instanceof BlockItem) {
            return stack;
        }
        if (stack.m_41720_() instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)stack.m_41720_();
            IItemHandler bagInventory = randomizerBagItem.getBagInventory(stack);
            return randomizerBagItem.findStack(bagInventory, blockItem);
        }
        return ItemStack.f_41583_;
    }

    public static boolean containsBlock(ItemStack stack, Block block) {
        if (stack == null || stack.m_41619_() || !CompatHelper.isItemBlockProxy(stack)) {
            return block == null || block == Blocks.f_50016_;
        }
        if (stack.m_41720_() instanceof BlockItem) {
            return ((BlockItem)stack.m_41720_()).m_40614_() == block;
        }
        Item item = stack.m_41720_();
        if (item instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)item;
            IItemHandler bagInventory = randomizerBagItem.getBagInventory(stack);
            ItemStack firstMatch = ItemHelper.findFirstMatch(bagInventory, s -> s.m_41720_() instanceof BlockItem);
            return firstMatch != null && !firstMatch.m_41619_();
        }
        return false;
    }
}

