/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.buildmodifier;

import java.text.DecimalFormat;
import java.util.Vector;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.AllGuiTextures;
import nl.requios.effortlessbuilding.AllIcons;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.capability.CapabilityHandler;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.IconButton;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.ScrollInput;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;
import nl.requios.effortlessbuilding.gui.buildmodifier.BaseModifierEntry;
import nl.requios.effortlessbuilding.gui.buildmodifier.ModifiersScreen;
import nl.requios.effortlessbuilding.gui.elements.LabeledScrollInput;
import nl.requios.effortlessbuilding.utilities.MathHelper;

@OnlyIn(value=Dist.CLIENT)
public class MirrorEntry
extends BaseModifierEntry<Mirror> {
    protected Vector<ScrollInput> positionInputs;
    protected IconButton playerPositionButton;
    protected IconButton toggleOffsetButton;
    protected Vector<IconButton> axisButtons;
    protected ScrollInput radiusInput;
    protected IconButton showLinesButton;
    protected IconButton showAreasButton;
    protected DecimalFormat df = new DecimalFormat("#.#");

    public MirrorEntry(ModifiersScreen screen, BaseModifier mirror) {
        super(screen, (Mirror)mirror, (Component)Component.m_237113_((String)"Mirror"), AllGuiTextures.MIRROR_ENTRY);
        int index;
        int i;
        this.positionInputs = new Vector();
        this.axisButtons = new Vector();
        for (i = 0; i < 3; ++i) {
            index = i;
            ScrollInput scrollInput = new LabeledScrollInput(0, 0, 36, 18).showControlScrollsSlowerTooltip().titled(Component.m_237113_((String)(i == 0 ? "X Position" : (i == 1 ? "Y Position" : "Z Position")))).format(integer -> Component.m_237113_((String)this.df.format((double)integer.intValue() / 2.0))).withStepFunction(stepContext -> stepContext.shift ? 20 : (stepContext.control ? 1 : 2)).calling(value -> {
                ((Mirror)this.modifier).position = MathHelper.with(((Mirror)this.modifier).position, index, (double)value.intValue() / 2.0);
                this.onValueChanged();
            });
            scrollInput.setState((int)(MathHelper.get(((Mirror)this.modifier).position, index) * 2.0));
            this.positionInputs.add(scrollInput);
        }
        this.listeners.addAll(this.positionInputs);
        this.playerPositionButton = (IconButton)new IconButton(0, 0, AllIcons.I_PLAYER).withCallback(() -> {
            ((Mirror)this.modifier).position = Vec3.m_82528_((Vec3i)Minecraft.m_91087_().f_91074_.m_20183_());
            this.onValueChanged();
        });
        this.playerPositionButton.setToolTip((Component)Components.literal("Set to player position"));
        this.listeners.add(this.playerPositionButton);
        this.toggleOffsetButton = (IconButton)new IconButton(0, 0, AllIcons.I_BLOCK_CENTER).withCallback(() -> {
            ((Mirror)this.modifier).position = ((Mirror)this.modifier).position.f_82479_ == Math.floor(((Mirror)this.modifier).position.f_82479_) ? new Vec3(Math.floor(((Mirror)this.modifier).position.f_82479_) + 0.5, Math.floor(((Mirror)this.modifier).position.f_82480_) + 0.5, Math.floor(((Mirror)this.modifier).position.f_82481_) + 0.5) : new Vec3(Math.floor(((Mirror)this.modifier).position.f_82479_), Math.floor(((Mirror)this.modifier).position.f_82480_), Math.floor(((Mirror)this.modifier).position.f_82481_));
            this.onValueChanged();
        });
        this.listeners.add(this.toggleOffsetButton);
        for (i = 0; i < 3; ++i) {
            index = i;
            IconButton button = (IconButton)new IconButton(0, 0, i == 0 ? AllIcons.I_X_ON : (i == 1 ? AllIcons.I_Y_OFF : AllIcons.I_Z_OFF)).withCallback(() -> {
                ((Mirror)this.modifier).toggleMirrorAxis(index);
                this.onValueChanged();
            });
            button.setToolTip((Component)Components.literal(i == 0 ? "X Axis" : (i == 1 ? "Y Axis" : "Z Axis")));
            this.axisButtons.add(button);
        }
        this.listeners.addAll(this.axisButtons);
        this.radiusInput = new LabeledScrollInput(0, 0, 27, 18).withRange(0, CapabilityHandler.getMaxMirrorRadius((Player)Minecraft.m_91087_().f_91074_, false)).titled(Minecraft.m_91087_().f_91074_.m_7500_() ? Component.m_237113_((String)"Radius") : Component.m_237113_((String)"Radius. Use Reach Upgrade items to increase maximum.")).calling(value -> {
            ((Mirror)this.modifier).radius = value;
            this.onValueChanged();
        });
        this.radiusInput.setState(((Mirror)this.modifier).radius);
        this.listeners.add(this.radiusInput);
        this.showLinesButton = (IconButton)new IconButton(0, 0, AllIcons.I_SHOW_LINES).withCallback(() -> {
            ((Mirror)this.modifier).drawLines = !((Mirror)this.modifier).drawLines;
            this.onValueChanged();
        });
        this.listeners.add(this.showLinesButton);
        this.showAreasButton = (IconButton)new IconButton(0, 0, AllIcons.I_SHOW_AREAS).withCallback(() -> {
            ((Mirror)this.modifier).drawPlanes = !((Mirror)this.modifier).drawPlanes;
            this.onValueChanged();
        });
        this.listeners.add(this.showAreasButton);
        for (ScrollInput positionInput : this.positionInputs) {
            positionInput.onChanged();
        }
        this.radiusInput.onChanged();
    }

    @Override
    public void m_6311_(GuiGraphics guiGraphics, int index, int y, int x, int width, int height, int mouseX, int mouseY, boolean p_230432_9_, float partialTicks) {
        int i;
        super.m_6311_(guiGraphics, index, y, x, width, height, mouseX, mouseY, p_230432_9_, partialTicks);
        for (i = 0; i < 3; ++i) {
            ScrollInput input = this.positionInputs.get(i);
            input.m_252865_(this.left + 49 + 38 * i);
            input.m_253211_(this.top + 19);
            input.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.playerPositionButton.m_252865_(this.left + 163);
        this.playerPositionButton.m_253211_(this.top + 19);
        this.playerPositionButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.toggleOffsetButton.m_252865_(this.left + 183);
        this.toggleOffsetButton.m_253211_(this.top + 19);
        this.toggleOffsetButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        for (i = 0; i < 3; ++i) {
            IconButton button = this.axisButtons.get(i);
            button.m_252865_(this.left + 49 + 18 * i);
            button.m_253211_(this.top + 41);
            button.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.radiusInput.m_252865_(this.left + 134);
        this.radiusInput.m_253211_(this.top + 41);
        this.radiusInput.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.showLinesButton.m_252865_(this.left + 163);
        this.showLinesButton.m_253211_(this.top + 41);
        this.showLinesButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.showAreasButton.m_252865_(this.left + 183);
        this.showAreasButton.m_253211_(this.top + 41);
        this.showAreasButton.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
    }

    @Override
    public void onValueChanged() {
        int i;
        super.onValueChanged();
        for (i = 0; i < 3; ++i) {
            ScrollInput input = this.positionInputs.get(i);
            input.setState((int)(MathHelper.get(((Mirror)this.modifier).position, i) * 2.0));
        }
        if (((Mirror)this.modifier).position.f_82479_ == Math.floor(((Mirror)this.modifier).position.f_82479_)) {
            this.toggleOffsetButton.setIcon(AllIcons.I_BLOCK_CENTER);
            this.toggleOffsetButton.setToolTip((Component)Components.literal("Set position to center of block, for uneven numbered builds."));
        } else {
            this.toggleOffsetButton.setIcon(AllIcons.I_BLOCK_CORNER);
            this.toggleOffsetButton.setToolTip((Component)Components.literal("Set position to corner of block, for even numbered builds."));
        }
        for (i = 0; i < 3; ++i) {
            IconButton button = this.axisButtons.get(i);
            if (((Mirror)this.modifier).getMirrorAxis(i)) {
                button.setIcon(i == 0 ? AllIcons.I_X_ON : (i == 1 ? AllIcons.I_Y_ON : AllIcons.I_Z_ON));
                continue;
            }
            button.setIcon(i == 0 ? AllIcons.I_X_OFF : (i == 1 ? AllIcons.I_Y_OFF : AllIcons.I_Z_OFF));
        }
        if (((Mirror)this.modifier).drawLines) {
            this.showLinesButton.setIcon(AllIcons.I_SHOW_LINES);
            this.showLinesButton.setToolTip((Component)Components.literal("Show mirror lines"));
        } else {
            this.showLinesButton.setIcon(AllIcons.I_HIDE_LINES);
            this.showLinesButton.setToolTip((Component)Components.literal("Show mirror lines"));
        }
        if (((Mirror)this.modifier).drawPlanes) {
            this.showAreasButton.setIcon(AllIcons.I_SHOW_AREAS);
            this.showAreasButton.setToolTip((Component)Components.literal("Show mirror areas"));
        } else {
            this.showAreasButton.setIcon(AllIcons.I_HIDE_AREAS);
            this.showAreasButton.setToolTip((Component)Components.literal("Show mirror areas"));
        }
    }
}

