/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network;

import java.util.function.Supplier;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;

public class ModifierSettingsPacket {
    private static final String DATA_KEY = "effortlessbuilding:buildModifiers";
    private CompoundTag modifiersTag;

    public ModifierSettingsPacket() {
    }

    public ModifierSettingsPacket(CompoundTag modifiersTag) {
        this.modifiersTag = modifiersTag;
    }

    public ModifierSettingsPacket(Player player) {
        this.modifiersTag = player.getPersistentData().m_128469_(DATA_KEY);
    }

    public static void encode(ModifierSettingsPacket message, FriendlyByteBuf buf) {
        buf.m_130079_(message.modifiersTag);
    }

    public static ModifierSettingsPacket decode(FriendlyByteBuf buf) {
        return new ModifierSettingsPacket(buf.m_130260_());
    }

    public static class Handler {
        public static void handle(ModifierSettingsPacket message, Supplier<NetworkEvent.Context> ctx) {
            if (ctx.get().getDirection().getReceptionSide().isServer()) {
                ctx.get().enqueueWork(() -> {
                    ServerPlayer player = ((NetworkEvent.Context)ctx.get()).getSender();
                    player.getPersistentData().m_128365_(ModifierSettingsPacket.DATA_KEY, (Tag)message.modifiersTag);
                });
            } else {
                ctx.get().enqueueWork(() -> EffortlessBuildingClient.BUILD_MODIFIERS.deserializeNBT(message.modifiersTag));
            }
            ctx.get().setPacketHandled(true);
        }
    }
}

