/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.utilities.BlockUtilities;
import nl.requios.effortlessbuilding.utilities.MyPlaceContext;

public class BlockEntry {
    public final BlockPos blockPos;
    public boolean mirrorX;
    public boolean mirrorY;
    public boolean mirrorZ;
    public Rotation rotation = Rotation.NONE;
    public BlockState existingBlockState;
    public BlockState newBlockState;
    public Item item;
    public boolean invalid = false;

    public BlockEntry(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public BlockEntry(BlockPos blockPos, BlockState blockState, Item item) {
        this.blockPos = blockPos;
        this.newBlockState = blockState;
        this.item = item;
    }

    public void copyRotationSettingsFrom(BlockEntry blockEntry) {
        this.mirrorX = blockEntry.mirrorX;
        this.mirrorY = blockEntry.mirrorY;
        this.mirrorZ = blockEntry.mirrorZ;
        this.rotation = blockEntry.rotation;
    }

    public void setItemAndFindNewBlockState(ItemStack itemStack, Level world, Direction originalDirection, Direction clickedFace, Vec3 relativeHitVec) {
        this.item = itemStack.m_41720_();
        Block block = Block.m_49814_((Item)this.item);
        Direction direction = originalDirection;
        if (this.rotation != null) {
            direction = this.rotation.m_55954_(direction);
        }
        direction = this.applyMirror(direction);
        MyPlaceContext blockPlaceContext = new MyPlaceContext(world, this.blockPos, direction, itemStack, clickedFace, relativeHitVec);
        this.newBlockState = block.m_5573_((BlockPlaceContext)blockPlaceContext);
        this.applyMirrorToBlockState();
    }

    private Direction applyMirror(Direction direction) {
        if (this.mirrorX && direction.m_122434_() == Direction.Axis.X) {
            direction = direction.m_122424_();
        }
        if (this.mirrorY && direction.m_122434_() == Direction.Axis.Y) {
            direction = direction.m_122424_();
        }
        if (this.mirrorZ && direction.m_122434_() == Direction.Axis.Z) {
            direction = direction.m_122424_();
        }
        return direction;
    }

    private void applyMirrorToBlockState() {
        if (this.mirrorY) {
            this.newBlockState = BlockUtilities.getVerticalMirror(this.newBlockState);
        }
    }

    public static void encode(FriendlyByteBuf buf, BlockEntry block) {
        buf.m_130064_(block.blockPos);
        buf.m_236821_((Object)block.newBlockState, (buffer, blockState) -> buffer.m_130079_(NbtUtils.m_129202_((BlockState)blockState)));
        buf.writeInt(Item.m_41393_((Item)block.item));
    }

    public static BlockEntry decode(FriendlyByteBuf buf) {
        BlockEntry block = new BlockEntry(buf.m_130135_());
        block.newBlockState = (BlockState)buf.m_236868_(buffer -> {
            CompoundTag nbt = buf.m_130260_();
            if (nbt == null) {
                return null;
            }
            return NbtUtils.m_247651_((HolderGetter)BuiltInRegistries.f_256975_.m_255303_(), (CompoundTag)nbt);
        });
        block.item = Item.m_41445_((int)buf.readInt());
        return block;
    }
}

