/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.gl.shader;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderConstants;
import me.jellysquid.mods.sodium.client.gl.shader.ShaderLoader;
import net.minecraft.resources.ResourceLocation;

public class ShaderParser {
    private static final Pattern IMPORT_PATTERN = Pattern.compile("#import <(?<namespace>.*):(?<path>.*)>");

    public static String parseShader(String src, ShaderConstants constants) {
        List<String> lines = ShaderParser.parseShader(src);
        lines.addAll(1, constants.getDefineStrings());
        return String.join((CharSequence)"\n", lines);
    }

    public static List<String> parseShader(String src) {
        LinkedList<String> builder = new LinkedList<String>();
        try (BufferedReader reader = new BufferedReader(new StringReader(src));){
            String line;
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#import")) {
                    builder.addAll(ShaderParser.resolveImport(line));
                    continue;
                }
                builder.add(line);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read shader sources", e);
        }
        return builder;
    }

    private static List<String> resolveImport(String line) {
        Matcher matcher = IMPORT_PATTERN.matcher(line);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Malformed import statement (expected format: " + String.valueOf(IMPORT_PATTERN) + ")");
        }
        String namespace = matcher.group("namespace");
        String path = matcher.group("path");
        ResourceLocation identifier = new ResourceLocation(namespace, path);
        String source = ShaderLoader.getShaderSource(identifier);
        return ShaderParser.parseShader(source);
    }
}

