/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling.mixin;

import dev.tr7zw.entityculling.EntityCullingModBase;
import dev.tr7zw.entityculling.NMSCullingHelper;
import dev.tr7zw.entityculling.mixin.DisplayAccessor;
import dev.tr7zw.entityculling.versionless.access.Cullable;
import dev.tr7zw.transition.mc.GeneralUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.warden.AngerLevel;
import net.minecraft.world.entity.monster.warden.Warden;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ClientLevel.class})
public class ClientWorldMixin {
    private Minecraft mc = Minecraft.m_91087_();

    @Inject(method={"tickNonPassenger"}, at={@At(value="HEAD")}, cancellable=true)
    public void tickEntity(Entity entity, CallbackInfo info) {
        if (!EntityCullingModBase.instance.config.tickCulling || EntityCullingModBase.instance.config.skipEntityCulling) {
            ++EntityCullingModBase.instance.tickedEntities;
            return;
        }
        if (EntityCullingModBase.instance.config.forceDisplayCulling && entity instanceof Display) {
            Display display = (Display)entity;
            this.processDisplay(display);
        }
        if (NMSCullingHelper.ignoresCulling(entity) || entity == GeneralUtil.getPlayer() || entity == GeneralUtil.getCameraEntity() || entity.m_20159_() || entity.m_20160_() || entity instanceof AbstractMinecart) {
            ++EntityCullingModBase.instance.tickedEntities;
            return;
        }
        if (EntityCullingModBase.instance.tickCullWhistelist.contains(entity.m_6095_()) || EntityCullingModBase.instance.entityWhitelist.contains(entity.m_6095_())) {
            ++EntityCullingModBase.instance.tickedEntities;
            return;
        }
        if (entity instanceof Cullable) {
            Cullable cull = (Cullable)entity;
            if (cull.isCulled() || cull.isOutOfCamera()) {
                this.basicTick(entity);
                ++EntityCullingModBase.instance.skippedEntityTicks;
                info.cancel();
                return;
            }
            cull.setOutOfCamera(true);
        }
        ++EntityCullingModBase.instance.tickedEntities;
    }

    private void processDisplay(Display display) {
        if (display.m_6921_().m_82309_() == 0.0 && display instanceof DisplayAccessor) {
            DisplayAccessor accessor = (DisplayAccessor)display;
            accessor.invokeSetWidth(3.0f);
            accessor.invokeSetHeight(3.0f);
            display.m_6034_(display.m_20185_(), display.m_20186_(), display.m_20189_());
        }
    }

    private void basicTick(Entity entity) {
        entity.m_146867_();
        ++entity.f_19797_;
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.m_8107_();
            if (living.f_20916_ > 0) {
                --living.f_20916_;
            }
        }
        if (entity instanceof Warden) {
            Warden warden = (Warden)entity;
            if (this.mc.f_91073_.m_5776_() && !warden.m_20067_() && warden.f_19797_ % this.getWardenHeartBeatDelay(warden) == 0) {
                this.mc.f_91073_.m_7785_(warden.m_20185_(), warden.m_20186_(), warden.m_20189_(), SoundEvents.f_215762_, warden.m_5720_(), 5.0f, warden.m_6100_(), false);
            }
        }
    }

    private int getWardenHeartBeatDelay(Warden warden) {
        float f = warden.m_219464_() / AngerLevel.ANGRY.m_219226_();
        return 40 - Mth.m_14143_((float)(Mth.m_14036_((float)f, (float)0.0f, (float)1.0f) * 30.0f));
    }
}

