/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.advancements;

import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import java.util.Map;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import rbasamoyai.escalated.index.EscalatedTriggers;

public class WalkwayTravelTracker {
    private static final Reference2ObjectArrayMap<Player, WalkwayTravelInfo> PLAYER_STATS = new Reference2ObjectArrayMap();

    public static void tick() {
        ObjectIterator iter = PLAYER_STATS.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = (Map.Entry)iter.next();
            Player player = (Player)entry.getKey();
            WalkwayTravelInfo info = (WalkwayTravelInfo)entry.getValue();
            if (player.m_213877_() || !player.m_6084_() || player.m_9236_().m_46472_() != info.attemptDimension) {
                iter.remove();
                continue;
            }
            if (info.onWalkway) {
                info.lastY = player.m_146904_();
                if (info.lastY < info.startY) {
                    info.startY = info.lastY;
                }
                if (info.lastY - info.startY < 100) continue;
                EscalatedTriggers.ESCALATOR_100.tryAwardingTo(player);
                if (player.m_9236_().m_46472_() == Level.f_46429_) {
                    EscalatedTriggers.ESCALATOR_100_NETHER.tryAwardingTo(player);
                }
                iter.remove();
                continue;
            }
            int yDiff = player.m_146904_() - info.lastY;
            --info.ticksOnWalkway;
            if (Math.abs(yDiff) <= 3 && info.ticksOnWalkway >= 1) continue;
            iter.remove();
        }
    }

    public static void clearList() {
        PLAYER_STATS.clear();
    }

    public static void stopTrackingPlayerOnWalkway(Player player) {
        if (!PLAYER_STATS.containsKey((Object)player)) {
            return;
        }
        WalkwayTravelInfo info = (WalkwayTravelInfo)PLAYER_STATS.get((Object)player);
        info.onWalkway = false;
    }

    public static void trackPlayerOnWalkway(Player player, int time) {
        WalkwayTravelInfo info;
        if (!PLAYER_STATS.containsKey((Object)player)) {
            info = new WalkwayTravelInfo();
            info.startY = player.m_146904_();
            info.attemptDimension = player.m_9236_().m_46472_();
            PLAYER_STATS.put((Object)player, (Object)info);
        }
        info = (WalkwayTravelInfo)PLAYER_STATS.get((Object)player);
        info.ticksOnWalkway = time;
        info.lastY = player.m_146904_();
        info.onWalkway = true;
    }

    static class WalkwayTravelInfo {
        int ticksOnWalkway;
        boolean onWalkway;
        int startY;
        int lastY;
        ResourceKey<Level> attemptDimension;

        WalkwayTravelInfo() {
        }
    }
}

