/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import rbasamoyai.escalated.walkways.AbstractWalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayBlock;
import rbasamoyai.escalated.walkways.WalkwayCaps;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;

public class WalkwayTerminalBlock
extends AbstractWalkwayBlock {
    public WalkwayTerminalBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
        this.m_49959_((BlockState)((BlockState)this.m_49965_().m_61090_()).m_61124_((Property)CAPS_SHAFT, (Comparable)((Object)WalkwayCaps.NONE)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{CAPS_SHAFT});
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        Direction leftFace = ((Direction)state.m_61143_(HORIZONTAL_FACING)).m_122428_();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.m_61143_((Property)CAPS_SHAFT));
        return face == leftFace && !caps.hasLeftCap() || face == leftFace.m_122424_() && !caps.hasRightCap() || face == Direction.DOWN;
    }

    protected boolean areStatesKineticallyEquivalent(BlockState oldState, BlockState newState) {
        return super.areStatesKineticallyEquivalent(oldState, newState) && oldState.m_61143_((Property)CAPS_SHAFT) == newState.m_61143_((Property)CAPS_SHAFT);
    }

    @Override
    public WalkwaySlope getWalkwaySlope(BlockState state) {
        return WalkwaySlope.TERMINAL;
    }

    @Override
    public boolean hasWalkwayShaft(BlockState state) {
        return true;
    }

    @Override
    public boolean movesEntities(BlockState state) {
        return false;
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        Level level = context.m_43725_();
        BlockState newState = state;
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        Direction left = facing.m_122428_();
        Direction right = left.m_122424_();
        Direction clicked = context.m_43719_();
        WalkwayCaps caps = (WalkwayCaps)((Object)state.m_61143_((Property)CAPS_SHAFT));
        if (clicked == left) {
            caps = caps.toggleLeft();
        }
        if (clicked == right) {
            caps = caps.toggleRight();
        }
        newState = (BlockState)newState.m_61124_((Property)CAPS_SHAFT, (Comparable)((Object)caps));
        KineticBlockEntity.switchToBlockState((Level)level, (BlockPos)context.m_8083_(), (BlockState)this.updateAfterWrenched(newState, context));
        BlockState setState = level.m_8055_(context.m_8083_());
        if (setState != state) {
            AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)context.m_8083_(), 1.0f, level.f_46441_.m_188501_() * 0.5f + 0.5f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        if (remove) {
            return state;
        }
        WalkwayCaps caps = (WalkwayCaps)((Object)state.m_61143_((Property)CAPS_SHAFT));
        if (replace) {
            if (left && caps.hasRightCap()) {
                caps = caps.toggleRight();
            } else if (!left && caps.hasLeftCap()) {
                caps = caps.toggleLeft();
            }
        } else if (left && caps.hasRightCap()) {
            caps = caps.toggleRight();
        } else if (!left && caps.hasLeftCap()) {
            caps = caps.toggleLeft();
        }
        return (BlockState)state.m_61124_((Property)CAPS_SHAFT, (Comparable)((Object)caps));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        if (face == facing) {
            return true;
        }
        if (face == facing.m_122424_()) {
            return false;
        }
        BlockPos otherPos = pos.m_121945_(facing);
        BlockState otherState = level.m_8055_(otherPos);
        Block block = otherState.m_60734_();
        if (block instanceof WalkwayBlock) {
            WalkwayBlock walkway = (WalkwayBlock)block;
            if (!(otherState.m_60734_() instanceof WalkwayTerminalBlock) && walkway.connectedToWalkwayOnSide(level, otherState, otherPos, face)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isEscalator(Level level, BlockState state, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        BlockPos otherPos = pos.m_121945_(facing);
        BlockState otherState = level.m_8055_(otherPos);
        Block block = otherState.m_60734_();
        if (!(block instanceof WalkwayBlock)) {
            return false;
        }
        WalkwayBlock walkway = (WalkwayBlock)block;
        if (walkway.getWalkwaySlope(otherState) == WalkwaySlope.TERMINAL) {
            return false;
        }
        return walkway.isEscalator(level, state, pos);
    }
}

