/*
 * Decompiled with CFR 0.152.
 */
package rbasamoyai.escalated.walkways;

import com.tterrag.registrate.util.nullness.NonNullSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import rbasamoyai.escalated.index.EscalatedShapes;
import rbasamoyai.escalated.walkways.NarrowEscalatorBlock;
import rbasamoyai.escalated.walkways.WalkwayBlockEntity;
import rbasamoyai.escalated.walkways.WalkwaySet;
import rbasamoyai.escalated.walkways.WalkwaySlope;
import rbasamoyai.escalated.walkways.WideWalkwaySideBlock;

public class WideEscalatorSideBlock
extends NarrowEscalatorBlock {
    public static final BooleanProperty LEFT = WideWalkwaySideBlock.LEFT;

    public WideEscalatorSideBlock(BlockBehaviour.Properties properties, NonNullSupplier<WalkwaySet> walkwaySetSupplier) {
        super(properties, walkwaySetSupplier);
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{LEFT});
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        WalkwaySlope slope = (WalkwaySlope)((Object)state.m_61143_((Property)SLOPE));
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        if (((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
            return switch (slope) {
                case WalkwaySlope.BOTTOM -> EscalatedShapes.WIDE_ESCALATOR_SIDE_BOTTOM_LEFT.get(facing);
                case WalkwaySlope.TOP -> EscalatedShapes.WIDE_ESCALATOR_SIDE_TOP_LEFT.get(facing);
                case WalkwaySlope.MIDDLE -> EscalatedShapes.WIDE_ESCALATOR_SIDE_MIDDLE_LEFT.get(facing);
                default -> EscalatedShapes.WIDE_WALKWAY_SIDE_LEFT.get(facing);
            };
        }
        return switch (slope) {
            case WalkwaySlope.BOTTOM -> EscalatedShapes.WIDE_ESCALATOR_SIDE_BOTTOM_RIGHT.get(facing);
            case WalkwaySlope.TOP -> EscalatedShapes.WIDE_ESCALATOR_SIDE_TOP_RIGHT.get(facing);
            case WalkwaySlope.MIDDLE -> EscalatedShapes.WIDE_ESCALATOR_SIDE_MIDDLE_RIGHT.get(facing);
            default -> EscalatedShapes.WIDE_WALKWAY_SIDE_RIGHT.get(facing);
        };
    }

    @Override
    public VoxelShape m_5939_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext context) {
        WalkwaySlope slope = (WalkwaySlope)((Object)state.m_61143_((Property)SLOPE));
        if (slope == WalkwaySlope.HORIZONTAL || slope == WalkwaySlope.TERMINAL) {
            return super.m_5939_(state, blockGetter, pos, context);
        }
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        WalkwayBlockEntity be = (WalkwayBlockEntity)this.getBlockEntity(blockGetter, pos);
        if (be == null) {
            return super.m_5939_(state, blockGetter, pos, context);
        }
        float visualOffset = be.getVisualProgress();
        if (((Boolean)state.m_61143_((Property)LEFT)).booleanValue()) {
            return switch (slope) {
                case WalkwaySlope.BOTTOM -> EscalatedShapes.WIDE_ESCALATOR_SIDE_BOTTOM_LEFT_STEPPED.getShape(visualOffset, facing);
                case WalkwaySlope.MIDDLE -> EscalatedShapes.WIDE_ESCALATOR_SIDE_MIDDLE_LEFT_STEPPED.getShape(visualOffset, facing);
                case WalkwaySlope.TOP -> EscalatedShapes.WIDE_ESCALATOR_SIDE_TOP_LEFT_STEPPED.getShape(visualOffset, facing);
                default -> super.m_5939_(state, blockGetter, pos, context);
            };
        }
        return switch (slope) {
            case WalkwaySlope.BOTTOM -> EscalatedShapes.WIDE_ESCALATOR_SIDE_BOTTOM_RIGHT_STEPPED.getShape(visualOffset, facing);
            case WalkwaySlope.MIDDLE -> EscalatedShapes.WIDE_ESCALATOR_SIDE_MIDDLE_RIGHT_STEPPED.getShape(visualOffset, facing);
            case WalkwaySlope.TOP -> EscalatedShapes.WIDE_ESCALATOR_SIDE_TOP_RIGHT_STEPPED.getShape(visualOffset, facing);
            default -> super.m_5939_(state, blockGetter, pos, context);
        };
    }

    @Override
    public BlockState transformFromMerge(Level level, BlockState state, BlockPos pos, boolean left, boolean shaft, boolean remove, boolean replace) {
        boolean srcLeft = (Boolean)state.m_61143_((Property)LEFT);
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        if (remove) {
            if (srcLeft == left) {
                return state;
            }
            return (BlockState)((BlockState)this.getWalkwaySet().getNarrowBlock(level, state, pos).m_61124_(HORIZONTAL_FACING, (Comparable)facing)).m_61124_((Property)SLOPE, (Comparable)((Object)((WalkwaySlope)((Object)state.m_61143_((Property)SLOPE)))));
        }
        if (srcLeft != left) {
            return state;
        }
        return (BlockState)((BlockState)this.getWalkwaySet().getWideCenterBlock(level, state, pos).m_61124_(HORIZONTAL_FACING, (Comparable)facing)).m_61124_((Property)SLOPE, (Comparable)((Object)((WalkwaySlope)((Object)state.m_61143_((Property)SLOPE)))));
    }

    @Override
    public boolean connectedToWalkwayOnSide(Level level, BlockState state, BlockPos pos, Direction face) {
        Direction facing = (Direction)state.m_61143_(HORIZONTAL_FACING);
        if (face.m_122434_() == facing.m_122434_()) {
            return true;
        }
        Direction openFace = (Boolean)state.m_61143_((Property)LEFT) != false ? facing.m_122427_() : facing.m_122428_();
        return face == openFace;
    }
}

