/*
 * Decompiled with CFR 0.152.
 */
package net.permutated.exmachinis;

import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.EmptyPart;
import com.mojang.datafixers.util.Unit;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.permutated.exmachinis.items.UpgradeItem;
import net.permutated.exmachinis.machines.base.AbstractMachineTile;
import net.permutated.exmachinis.machines.compactor.FluxCompactorBlock;
import net.permutated.exmachinis.machines.compactor.FluxCompactorMenu;
import net.permutated.exmachinis.machines.compactor.FluxCompactorTile;
import net.permutated.exmachinis.machines.hammer.FluxHammerBlock;
import net.permutated.exmachinis.machines.hammer.FluxHammerMenu;
import net.permutated.exmachinis.machines.hammer.FluxHammerTile;
import net.permutated.exmachinis.machines.sieve.FluxSieveBlock;
import net.permutated.exmachinis.machines.sieve.FluxSieveMenu;
import net.permutated.exmachinis.machines.sieve.FluxSieveTile;
import net.permutated.exmachinis.recipes.CompactingRecipe;
import net.permutated.exmachinis.recipes.CompactingRegistry;
import net.permutated.exmachinis.util.ResourceUtil;
import net.permutated.exmachinis.util.TranslationKey;

public class ModRegistry {
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"exmachinis");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"exmachinis");
    public static final DeferredRegister<BlockEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"exmachinis");
    public static final DeferredRegister<MenuType<?>> CONTAINERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"exmachinis");
    public static final DeferredRegister<RecipeType<?>> RECIPE_TYPES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_TYPES, (String)"exmachinis");
    public static final DeferredRegister<RecipeSerializer<?>> RECIPE_SERIALIZERS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"exmachinis");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_TABS = DeferredRegister.create((ResourceKey)Registries.f_279569_, (String)"exmachinis");
    public static final RegistryObject<CreativeModeTab> CREATIVE_TAB = CREATIVE_TABS.register("creative_tab", () -> CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)TranslationKey.tab())).m_257737_(() -> ((Item)NETHERITE_UPGRADE.get()).m_7968_()).m_257501_((parameters, output) -> ITEMS.getEntries().stream().map(RegistryObject::get).map(Item::m_7968_).forEach(arg_0 -> ((CreativeModeTab.Output)output).m_246342_(arg_0))).m_257652_());
    public static final RegistryObject<Item> GOLD_UPGRADE = ModRegistry.upgradeItem("gold_upgrade", UpgradeItem.Tier.GOLD);
    public static final RegistryObject<Item> DIAMOND_UPGRADE = ModRegistry.upgradeItem("diamond_upgrade", UpgradeItem.Tier.DIAMOND);
    public static final RegistryObject<Item> NETHERITE_UPGRADE = ModRegistry.upgradeItem("netherite_upgrade", UpgradeItem.Tier.NETHERITE);
    public static final RegistryObject<Block> FLUX_SIEVE_BLOCK = BLOCKS.register("flux_sieve", FluxSieveBlock::new);
    public static final RegistryObject<BlockEntityType<FluxSieveTile>> FLUX_SIEVE_TILE = ModRegistry.blockEntity(FLUX_SIEVE_BLOCK, FluxSieveTile::new);
    public static final RegistryObject<MenuType<FluxSieveMenu>> FLUX_SIEVE_MENU = ModRegistry.container("flux_sieve", FluxSieveMenu::new);
    public static final RegistryObject<BlockItem> FLUX_SIEVE_ITEM = ModRegistry.blockItem(FLUX_SIEVE_BLOCK);
    public static final RegistryObject<Block> FLUX_HAMMER_BLOCK = BLOCKS.register("flux_hammer", FluxHammerBlock::new);
    public static final RegistryObject<BlockEntityType<FluxHammerTile>> FLUX_HAMMER_TILE = ModRegistry.blockEntity(FLUX_HAMMER_BLOCK, FluxHammerTile::new);
    public static final RegistryObject<MenuType<FluxHammerMenu>> FLUX_HAMMER_MENU = ModRegistry.container("flux_hammer", FluxHammerMenu::new);
    public static final RegistryObject<BlockItem> FLUX_HAMMER_ITEM = ModRegistry.blockItem(FLUX_HAMMER_BLOCK);
    public static final RegistryObject<Block> FLUX_COMPACTOR_BLOCK = BLOCKS.register("flux_compactor", FluxCompactorBlock::new);
    public static final RegistryObject<BlockEntityType<FluxCompactorTile>> FLUX_COMPACTOR_TILE = ModRegistry.blockEntity(FLUX_COMPACTOR_BLOCK, FluxCompactorTile::new);
    public static final RegistryObject<MenuType<FluxCompactorMenu>> FLUX_COMPACTOR_MENU = ModRegistry.container("flux_compactor", FluxCompactorMenu::new);
    public static final RegistryObject<BlockItem> FLUX_COMPACTOR_ITEM = ModRegistry.blockItem(FLUX_COMPACTOR_BLOCK);
    public static final RegistryObject<RecipeType<CompactingRecipe>> COMPACTING_RECIPE_TYPE = RECIPE_TYPES.register("compacting", () -> RecipeType.simple((ResourceLocation)ResourceUtil.prefix("compacting")));
    public static final RegistryObject<RecipeSerializer<CompactingRecipe>> COMPACTING_RECIPE_SERIALIZER = RECIPE_SERIALIZERS.register("compacting", CompactingRecipe.Serializer::new);
    public static final CompactingRegistry COMPACTING_REGISTRY = new CompactingRegistry();
    private static final Type<Unit> EMPTY_PART = new EmptyPart();

    private ModRegistry() {
    }

    private static RegistryObject<BlockItem> blockItem(RegistryObject<Block> registryObject) {
        return ITEMS.register(registryObject.getId().m_135815_(), () -> new BlockItem((Block)registryObject.get(), new Item.Properties()));
    }

    public static RegistryObject<Item> upgradeItem(String name, UpgradeItem.Tier tier) {
        return ITEMS.register(name, () -> new UpgradeItem(tier));
    }

    private static <T extends AbstractMachineTile> RegistryObject<BlockEntityType<T>> blockEntity(RegistryObject<Block> registryObject, BlockEntityType.BlockEntitySupplier<T> supplier) {
        return TILES.register(registryObject.getId().m_135815_(), () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)supplier, (Block[])new Block[]{(Block)registryObject.get()}).m_58966_(EMPTY_PART));
    }

    private static <T extends AbstractContainerMenu> RegistryObject<MenuType<T>> container(String path, IContainerFactory<T> supplier) {
        return CONTAINERS.register(path, () -> IForgeMenuType.create((IContainerFactory)supplier));
    }

    public static void register() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ITEMS.register(bus);
        BLOCKS.register(bus);
        TILES.register(bus);
        CONTAINERS.register(bus);
        RECIPE_TYPES.register(bus);
        RECIPE_SERIALIZERS.register(bus);
        CREATIVE_TABS.register(bus);
    }
}

