/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import novamachina.exnihilosequentia.world.item.crafting.CrushingRecipe;
import novamachina.exnihilosequentia.world.item.crafting.ItemStackWithChance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CrushingRegistry {
    private static Logger log = LoggerFactory.getLogger(CrushingRegistry.class);
    @Nonnull
    private static final List<CrushingRecipe> recipeList = new ArrayList<CrushingRecipe>();
    private final LoadingCache<Block, CrushingRecipe> cache;

    public CrushingRegistry() {
        CacheLoader<Block, CrushingRecipe> loader = new CacheLoader<Block, CrushingRecipe>(){

            public CrushingRecipe load(Block key) {
                return recipeList.stream().filter(recipe -> recipe.getInput().test(new ItemStack((ItemLike)key))).findFirst().orElse(CrushingRecipe.EMPTY);
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    @Nonnull
    public List<ItemStackWithChance> getResult(@Nonnull Block input) {
        List<ItemStackWithChance> returnList = this.findRecipe(input).getDrops();
        log.debug("Hammer Drop Stack: " + returnList);
        return returnList;
    }

    public boolean isHammerable(@Nonnull Block block) {
        return this.findRecipe(block) != CrushingRecipe.EMPTY;
    }

    @Nonnull
    public CrushingRecipe findRecipe(@Nonnull Block block) {
        try {
            return (CrushingRecipe)((Object)this.cache.get((Object)block));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    public void setRecipes(@Nonnull List<CrushingRecipe> recipes) {
        log.debug("Hammer Registry recipes: " + recipes.size());
        recipeList.addAll(recipes);
        this.cache.invalidateAll();
    }

    @Nonnull
    public List<CrushingRecipe> getRecipeList() {
        return recipeList;
    }

    public void clearRecipes() {
        recipeList.clear();
        this.cache.invalidateAll();
    }
}

