/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.common.registries;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import novamachina.exnihilosequentia.world.item.crafting.SolidifyingRecipe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolidifyingRegistry {
    private static Logger log = LoggerFactory.getLogger(SolidifyingRegistry.class);
    @Nonnull
    private final List<SolidifyingRecipe> recipeList = new ArrayList<SolidifyingRecipe>();
    private final LoadingCache<SolidifyingCacheKey, ItemStack> cache;

    public SolidifyingRegistry() {
        CacheLoader<SolidifyingCacheKey, ItemStack> loader = new CacheLoader<SolidifyingCacheKey, ItemStack>(){

            public ItemStack load(SolidifyingCacheKey key) {
                return SolidifyingRegistry.this.recipeList.stream().filter(fluidOnTopRecipe -> fluidOnTopRecipe.validInputs(key.fluidInTank(), key.fluidOnTop())).findFirst().map(SolidifyingRecipe::getResult).orElse(ItemStack.f_41583_);
            }
        };
        this.cache = CacheBuilder.newBuilder().maximumSize(100L).build((CacheLoader)loader);
    }

    public boolean isValidRecipe(@Nonnull Fluid fluidInTank, @Nonnull Fluid fluidOnTop) {
        return this.getResultItem(fluidInTank, fluidOnTop) != ItemStack.f_41583_;
    }

    @Nonnull
    private ItemStack getResultItem(@Nonnull Fluid fluidInTank, @Nonnull Fluid fluidOnTop) {
        try {
            return (ItemStack)this.cache.get((Object)new SolidifyingCacheKey(fluidInTank, fluidOnTop));
        }
        catch (ExecutionException e) {
            throw new RuntimeException(e);
        }
    }

    @Nonnull
    public ItemStack getResult(@Nonnull Fluid fluidInTank, @Nonnull Fluid fluidOnTop) {
        return this.getResultItem(fluidInTank, fluidOnTop).m_41777_();
    }

    @Nonnull
    public List<SolidifyingRecipe> getRecipeList() {
        return this.recipeList;
    }

    public void setRecipes(@Nonnull List<SolidifyingRecipe> recipes) {
        log.debug("Fluid On Top Registry recipes: " + recipes.size());
        this.recipeList.addAll(recipes);
        this.cache.invalidateAll();
    }

    public void clearRecipes() {
        this.recipeList.clear();
        this.cache.invalidateAll();
    }

    private record SolidifyingCacheKey(Fluid fluidInTank, Fluid fluidOnTop) {
    }
}

