/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CakeBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public abstract class AbstractBlockStateGenerator
extends BlockStateProvider {
    @Nonnull
    protected static final String PARTICLE_TAG = "particle";

    protected AbstractBlockStateGenerator(@Nonnull PackOutput output, @Nonnull String modId, @Nonnull ExistingFileHelper exFileHelper) {
        super(output, modId, exFileHelper);
    }

    @Nonnull
    protected ResourceLocation exnihiloLoc(@Nonnull String string) {
        return new ResourceLocation("exnihilosequentia", string);
    }

    protected ResourceLocation vanillaLoc(@Nonnull String string) {
        return new ResourceLocation("minecraft", string);
    }

    protected void basicBlock(@Nonnull Block block) {
        this.simpleItemBlock(block, this.cubeAll(block));
    }

    protected void registerFluid(@Nonnull Fluid fluid, ResourceLocation stillTexture) {
        ResourceLocation resourceLocation = ForgeRegistries.FLUIDS.getKey((Object)fluid);
        if (resourceLocation != null) {
            ModelBuilder model = ((BlockModelBuilder)this.models().getBuilder("block/" + resourceLocation.m_135815_())).texture(PARTICLE_TAG, stillTexture);
            this.getVariantBuilder(fluid.m_76145_().m_76188_().m_60734_()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        }
    }

    protected void simpleItemBlock(@Nonnull Block block, @Nonnull ModelFile modelFile) {
        this.simpleBlock(block, modelFile);
        this.simpleBlockItem(block, modelFile);
    }

    @Nullable
    protected String getRegistryName(@Nonnull Block b) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)b);
        if (resourceLocation != null) {
            return resourceLocation.toString();
        }
        return null;
    }

    protected void createBarrel(Block block, ResourceLocation texture, ResourceLocation particle) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/barrel_base"))).texture("texture", texture)).texture(PARTICLE_TAG, particle)).renderType("cutout_mipped"));
        this.simpleItemBlock(block, model.model);
    }

    protected void createCake(Block block) {
        VariantBlockStateBuilder builder = this.getVariantBuilder(block);
        for (int i = 1; i < 7; ++i) {
            VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
            ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(this.exnihiloLoc("block/cake_slice" + i)));
            partialBlockstate.with((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(i)).addModels(new ConfiguredModel[]{model});
        }
        VariantBlockStateBuilder.PartialBlockstate partialBlockstate = builder.partialState();
        ConfiguredModel model = new ConfiguredModel((ModelFile)this.models().getExistingFile(this.exnihiloLoc("block/cake_uneaten")));
        partialBlockstate.with((Property)CakeBlock.f_51180_, (Comparable)Integer.valueOf(0)).addModels(new ConfiguredModel[]{model});
    }

    protected void createCrucible(Block block, ResourceLocation texture, ResourceLocation particle) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/crucible_base"))).texture(PARTICLE_TAG, particle)).texture("texture", texture)).renderType("cutout_mipped"));
        this.simpleItemBlock(block, model.model);
    }

    protected void createSieve(Block block, ResourceLocation texture, ResourceLocation particle) {
        ConfiguredModel model = new ConfiguredModel((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(this.getRegistryName(block), this.exnihiloLoc("block/sieve_base"))).texture("texture", texture)).texture(PARTICLE_TAG, particle)).renderType("cutout_mipped"));
        this.simpleItemBlock(block, model.model);
    }
}

