/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data;

import java.util.concurrent.CompletableFuture;
import javax.annotation.Nonnull;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import novamachina.exnihilosequentia.data.EXNLangProvider;
import novamachina.exnihilosequentia.data.ExNihiloBlockStateGenerator;
import novamachina.exnihilosequentia.data.loot.EXNLootModifierProvider;
import novamachina.exnihilosequentia.data.loot.EXNLootProvider;
import novamachina.exnihilosequentia.data.models.ItemModelProvider;
import novamachina.exnihilosequentia.data.recipes.packs.EXNRecipeProvider;
import novamachina.exnihilosequentia.data.tags.EXNTagProvider;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class ExNihiloDataGenerators {
    private ExNihiloDataGenerators() {
    }

    @SubscribeEvent
    public static void gatherData(@Nonnull GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new EXNLootProvider(output));
        generator.addProvider(event.includeServer(), (DataProvider)new EXNRecipeProvider(output, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EXNTagProvider(output, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new EXNLootModifierProvider(output));
        generator.addProvider(event.includeClient(), (DataProvider)new ItemModelProvider(output, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new EXNLangProvider(output, "en_us"));
        generator.addProvider(event.includeClient(), (DataProvider)new ExNihiloBlockStateGenerator(output, existingFileHelper));
    }
}

