/*
 * Decompiled with CFR 0.152.
 */
package novamachina.exnihilosequentia.data.recipes.providers;

import com.mojang.datafixers.util.Either;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.data.recipes.SmithingTransformRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;
import novamachina.exnihilosequentia.common.utility.ExNihiloConstants;
import novamachina.exnihilosequentia.data.recipes.RecipeProviderUtilities;
import novamachina.exnihilosequentia.tags.ExNihiloTags;
import novamachina.exnihilosequentia.world.item.EXNItems;
import novamachina.exnihilosequentia.world.item.Ore;
import novamachina.exnihilosequentia.world.item.OreItem;
import novamachina.exnihilosequentia.world.item.PebbleItem;
import novamachina.exnihilosequentia.world.level.block.BarrelBlock;
import novamachina.exnihilosequentia.world.level.block.CrucibleBlock;
import novamachina.exnihilosequentia.world.level.block.EXNBlocks;
import novamachina.exnihilosequentia.world.level.block.SieveBlock;
import novamachina.novacore.data.recipes.ISubRecipeProvider;
import novamachina.novacore.world.item.ItemDefinition;
import novamachina.novacore.world.level.block.BlockDefinition;

public class CraftingRecipes
implements ISubRecipeProvider {
    public static final String PEBBLE_CONDITION = "has_pebble";
    private static final String MATERIAL_CONDITION = "has_material";
    private static final String CHUNK_CONDITION = "has_chunk";
    private static final String DOLL_CONDITION = "has_doll";
    private static final String PORCELAIN_CLAY_CONDITION = "has_porcelain_clay";

    public void addRecipes(Consumer<FinishedRecipe> consumer) {
        this.addCrooks(consumer);
        this.addPebbleBlocks(consumer);
        this.addBarrels(consumer);
        this.addCrucibles(consumer);
        this.addSieves(consumer);
        this.addOres(consumer);
        this.addHammers(consumer);
        this.addDolls(consumer);
        this.addMeshes(consumer);
        this.addMisc(consumer);
    }

    private void addMisc(Consumer<FinishedRecipe> consumer) {
        ResourceLocation ancientDebrisResourceLocation;
        ResourceLocation cryingObsidianResourceLocation;
        ResourceLocation beehive = ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50718_);
        if (beehive != null) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50718_).m_126130_("xxx").m_126130_("fff").m_126130_("xxx").m_206416_(Character.valueOf('x'), ItemTags.f_13168_).m_126127_(Character.valueOf('f'), (ItemLike)EXNItems.BEEHIVE_FRAME.m_5456_()).m_126132_("has_frame", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.BEEHIVE_FRAME.m_5456_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(beehive));
        }
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.BEEHIVE_FRAME.m_5456_()).m_126130_("xxx").m_126130_("xfx").m_126130_("xxx").m_206416_(Character.valueOf('x'), Tags.Items.RODS_WOODEN).m_206416_(Character.valueOf('f'), Tags.Items.STRING).m_126132_("has_stick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.RODS_WOODEN).m_45077_()})).m_126132_("has_string", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.STRING).m_45077_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNItems.BEEHIVE_FRAME.getId()));
        this.createCookingRecipe(consumer, EXNItems.SILKWORM.m_5456_(), EXNItems.COOKED_SILKWORM.m_5456_(), 0.1f, 600, 0.1f, 100, "has_silkworm", EXNItems.COOKED_SILKWORM.getId());
        this.createSmeltingRecipe(consumer, EXNItems.SILKWORM.m_5456_(), EXNItems.COOKED_SILKWORM.m_5456_(), 0.1f, 200, 0.1f, 100, "has_silkworm", EXNItems.COOKED_SILKWORM.getId());
        this.createSmeltingRecipe(consumer, EXNBlocks.UNFIRED_CRUCIBLE.m_5456_(), EXNBlocks.FIRED_CRUCIBLE.m_5456_(), 0.7f, 200, 0.7f, 100, "has_uncooked_crucible", EXNBlocks.FIRED_CRUCIBLE.getId());
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, EXNBlocks.UNFIRED_CRUCIBLE).m_126130_("c c").m_126130_("c c").m_126130_("ccc").m_126127_(Character.valueOf('c'), (ItemLike)EXNItems.PORCELAIN_CLAY.m_5456_()).m_126132_(PORCELAIN_CLAY_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.PORCELAIN_CLAY.m_5456_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNBlocks.UNFIRED_CRUCIBLE.getId()));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.CRAFTING_DOLL.m_5456_(), (int)4).m_126130_("xex").m_126130_(" x ").m_126130_("x x").m_126127_(Character.valueOf('x'), (ItemLike)EXNItems.PORCELAIN_CLAY.m_5456_()).m_206416_(Character.valueOf('e'), Tags.Items.GEMS_DIAMOND).m_126132_(PORCELAIN_CLAY_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.PORCELAIN_CLAY.m_5456_()})).m_126132_("has_diamond", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.GEMS_DIAMOND).m_45077_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(new ResourceLocation("exnihilosequentia", "doll_x4")));
        ShapedRecipeBuilder.m_246608_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.CRAFTING_DOLL.m_5456_(), (int)6).m_126130_("xex").m_126130_(" x ").m_126130_("x x").m_126127_(Character.valueOf('x'), (ItemLike)EXNItems.PORCELAIN_CLAY.m_5456_()).m_206416_(Character.valueOf('e'), Tags.Items.GEMS_EMERALD).m_126132_(PORCELAIN_CLAY_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.PORCELAIN_CLAY.m_5456_()})).m_126132_("has_emerald", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.GEMS_EMERALD).m_45077_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(new ResourceLocation("exnihilosequentia", "doll_x6")));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.FOOD, EXNBlocks.END_CAKE).m_126130_("ece").m_126130_("eke").m_126130_("ece").m_126127_(Character.valueOf('e'), (ItemLike)Items.f_42545_).m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42729_).m_126127_(Character.valueOf('k'), (ItemLike)Items.f_42502_).m_126132_("has_ender_pearl", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42584_})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNBlocks.END_CAKE.getId()));
        ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.PORCELAIN_CLAY.m_5456_()).m_206419_(ExNihiloTags.CLAY).m_126209_((ItemLike)Items.f_42499_).m_126132_("has_clay", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(ExNihiloTags.CLAY).m_45077_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNItems.PORCELAIN_CLAY.getId()));
        ItemDefinition<PebbleItem> blackstonePebble = EXNItems.PEBBLE_BLACKSTONE;
        ResourceLocation gildedBlackstoneResourceLocation = ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50706_);
        if (EXNItems.GOLD.getRawOreItem() != null && gildedBlackstoneResourceLocation != null) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50706_).m_126130_("xxx").m_126130_("xgx").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)blackstonePebble.m_5456_()).m_206416_(Character.valueOf('g'), Tags.Items.RAW_MATERIALS_GOLD).m_126132_("has_gold", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_151053_})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(gildedBlackstoneResourceLocation));
        }
        if ((cryingObsidianResourceLocation = ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50723_)) != null) {
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)Blocks.f_50723_).m_126130_(" o ").m_126130_("obo").m_126130_(" o ").m_126127_(Character.valueOf('b'), (ItemLike)Items.f_42447_).m_126127_(Character.valueOf('o'), (ItemLike)Blocks.f_50080_).m_126132_("has_obsidian", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Blocks.f_50080_})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(cryingObsidianResourceLocation));
        }
        if ((ancientDebrisResourceLocation = ForgeRegistries.BLOCKS.getKey((Object)Blocks.f_50722_)) != null) {
            ShapelessRecipeBuilder.m_245498_((RecipeCategory)RecipeCategory.MISC, (ItemLike)Blocks.f_50722_).m_126209_((ItemLike)Items.f_42419_).m_126209_((ItemLike)Blocks.f_50080_).m_126132_("has_scrap", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{Items.f_42419_})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(ancientDebrisResourceLocation));
        }
    }

    private void addMeshes(Consumer<FinishedRecipe> consumer) {
        this.createMesh(EXNItems.MESH_FLINT.m_5456_(), EXNItems.MESH_STRING.m_5456_(), Items.f_42484_, consumer);
        this.createMesh(EXNItems.MESH_IRON.m_5456_(), EXNItems.MESH_FLINT.m_5456_(), (TagKey<Item>)Tags.Items.INGOTS_IRON, consumer);
        this.createMesh(EXNItems.MESH_DIAMOND.m_5456_(), EXNItems.MESH_IRON.m_5456_(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createMesh(EXNItems.MESH_EMERALD.m_5456_(), EXNItems.MESH_DIAMOND.m_5456_(), (TagKey<Item>)Tags.Items.GEMS_EMERALD, consumer);
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EXNItems.MESH_EMERALD.m_5456_()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.MISC, (Item)EXNItems.MESH_NETHERITE.m_5456_()).m_266439_("has_emerald_mesh", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.MESH_EMERALD.m_5456_()})).m_266439_(MATERIAL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.INGOTS_NETHERITE).m_45077_()})).m_266371_(consumer, RecipeProviderUtilities.createSaveLocation(new ResourceLocation("exnihilosequentia", "netherite_mesh")));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.MESH_STRING.m_5456_()).m_126130_("iii").m_126130_("iii").m_126130_("iii").m_206416_(Character.valueOf('i'), Tags.Items.STRING).m_126132_("has_sieve", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNBlocks.OAK_SIEVE, EXNBlocks.ACACIA_SIEVE, EXNBlocks.BAMBOO_SIEVE, EXNBlocks.BIRCH_SIEVE, EXNBlocks.CHERRY_SIEVE, EXNBlocks.JUNGLE_SIEVE, EXNBlocks.MANGROVE_SIEVE, EXNBlocks.DARK_OAK_SIEVE, EXNBlocks.SPRUCE_SIEVE, EXNBlocks.CRIMSON_SIEVE, EXNBlocks.WARPED_SIEVE})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNItems.MESH_STRING.getId()));
    }

    private void addDolls(Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.SHULKER_DOLL.m_5456_()).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_206416_(Character.valueOf('c'), Tags.Items.DYES_PURPLE).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), Tags.Items.END_STONES).m_206416_(Character.valueOf('b'), Tags.Items.ENDER_PEARLS).m_126127_(Character.valueOf('m'), (ItemLike)EXNItems.CRAFTING_DOLL.m_5456_()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.CRAFTING_DOLL.m_5456_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNItems.SHULKER_DOLL.getId()));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.GUARDIAN_DOLL.m_5456_()).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_206416_(Character.valueOf('c'), Tags.Items.GEMS_PRISMARINE).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('b'), ItemTags.f_13156_).m_126127_(Character.valueOf('m'), (ItemLike)EXNItems.CRAFTING_DOLL.m_5456_()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.CRAFTING_DOLL.m_5456_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNItems.GUARDIAN_DOLL.getId()));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.BEE_DOLL.m_5456_()).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_206416_(Character.valueOf('c'), Tags.Items.DYES_YELLOW).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), ItemTags.f_13149_).m_126127_(Character.valueOf('b'), (ItemLike)EXNItems.BEEHIVE_FRAME.m_5456_()).m_126127_(Character.valueOf('m'), (ItemLike)EXNItems.CRAFTING_DOLL.m_5456_()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.CRAFTING_DOLL.m_5456_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNItems.BEE_DOLL.getId()));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.BLAZE_DOLL.m_5456_()).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_126127_(Character.valueOf('c'), (ItemLike)Items.f_42593_).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('b'), Tags.Items.CROPS_NETHER_WART).m_126127_(Character.valueOf('m'), (ItemLike)EXNItems.CRAFTING_DOLL.m_5456_()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.CRAFTING_DOLL.m_5456_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNItems.BLAZE_DOLL.getId()));
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)EXNItems.ENDERMAN_DOLL.m_5456_()).m_126130_("ctc").m_126130_("sms").m_126130_("cbc").m_206416_(Character.valueOf('c'), Tags.Items.DYES_BLACK).m_206416_(Character.valueOf('s'), Tags.Items.DUSTS_GLOWSTONE).m_206416_(Character.valueOf('t'), Tags.Items.DUSTS_REDSTONE).m_206416_(Character.valueOf('b'), Tags.Items.CROPS_NETHER_WART).m_126127_(Character.valueOf('m'), (ItemLike)EXNItems.CRAFTING_DOLL.m_5456_()).m_126132_(DOLL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.CRAFTING_DOLL.m_5456_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(EXNItems.ENDERMAN_DOLL.getId()));
    }

    private void addHammers(Consumer<FinishedRecipe> consumer) {
        this.createHammer(EXNItems.HAMMER_ANDESITE.m_5456_(), Items.f_42170_, consumer);
        this.createHammer(EXNItems.HAMMER_BAMBOO.m_5456_(), Items.f_41911_, consumer);
        this.createHammer(EXNItems.HAMMER_BASALT.m_5456_(), Items.f_42051_, consumer);
        this.createHammer(EXNItems.HAMMER_BLACKSTONE.m_5456_(), Items.f_42755_, consumer);
        this.createHammer(EXNItems.HAMMER_CALCITE.m_5456_(), Items.f_151047_, consumer);
        this.createHammer(EXNItems.HAMMER_CHERRY.m_5456_(), Items.f_271154_, consumer);
        this.createHammer(EXNItems.HAMMER_COPPER.m_5456_(), (TagKey<Item>)Tags.Items.INGOTS_COPPER, consumer);
        this.createHammer(EXNItems.HAMMER_DEEPSLATE.m_5456_(), Items.f_151034_, consumer);
        this.createHammer(EXNItems.HAMMER_DIAMOND.m_5456_(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createHammer(EXNItems.HAMMER_DIORITE.m_5456_(), Items.f_42064_, consumer);
        this.createHammer(EXNItems.HAMMER_DRIPSTONE.m_5456_(), Items.f_151054_, consumer);
        this.createHammer(EXNItems.HAMMER_GOLD.m_5456_(), (TagKey<Item>)Tags.Items.INGOTS_GOLD, consumer);
        this.createHammer(EXNItems.HAMMER_GRANITE.m_5456_(), Items.f_41958_, consumer);
        this.createHammer(EXNItems.HAMMER_IRON.m_5456_(), (TagKey<Item>)Tags.Items.INGOTS_IRON, consumer);
        this.createHammer(EXNItems.HAMMER_NETHER_BRICK.m_5456_(), Items.f_42095_, consumer);
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EXNItems.HAMMER_DIAMOND.m_5456_()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.TOOLS, (Item)EXNItems.HAMMER_NETHERITE.m_5456_()).m_266439_("has_diamond_hammer", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.HAMMER_DIAMOND.m_5456_()})).m_266439_(MATERIAL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.INGOTS_NETHERITE).m_45077_()})).m_266371_(consumer, RecipeProviderUtilities.createSaveLocation(new ResourceLocation("exnihilosequentia", ExNihiloConstants.Items.NETHERITE_HAMMER)));
        this.createHammer(EXNItems.HAMMER_RED_NETHER_BRICK.m_5456_(), Items.f_42261_, consumer);
        this.createHammer(EXNItems.HAMMER_STONE.m_5456_(), Items.f_42594_, consumer);
        this.createHammer(EXNItems.HAMMER_TERRACOTTA.m_5456_(), Items.f_42199_, consumer);
        this.createHammer(EXNItems.HAMMER_TUFF.m_5456_(), Items.f_151048_, consumer);
        this.createHammer(EXNItems.HAMMER_WOOD.m_5456_(), (TagKey<Item>)ItemTags.f_13168_, consumer);
    }

    private void addOres(Consumer<FinishedRecipe> consumer) {
        this.createOre(EXNItems.IRON, consumer);
        this.createOre(EXNItems.GOLD, consumer);
        this.createOre(EXNItems.COPPER, consumer);
        this.createOreRecipes(EXNItems.LEAD, new ResourceLocation("exnihilosequentia", EXNItems.LEAD.getIngotId()), consumer);
        this.createOreRecipes(EXNItems.NICKEL, new ResourceLocation("exnihilosequentia", EXNItems.NICKEL.getIngotId()), consumer);
        this.createOreRecipes(EXNItems.SILVER, new ResourceLocation("exnihilosequentia", EXNItems.SILVER.getIngotId()), consumer);
        this.createOreRecipes(EXNItems.TIN, new ResourceLocation("exnihilosequentia", EXNItems.TIN.getIngotId()), consumer);
        this.createOreRecipes(EXNItems.ALUMINUM, new ResourceLocation("exnihilosequentia", EXNItems.ALUMINUM.getIngotId()), consumer);
        this.createOreRecipes(EXNItems.PLATINUM, new ResourceLocation("exnihilosequentia", EXNItems.PLATINUM.getIngotId()), consumer);
        this.createOreRecipes(EXNItems.URANIUM, new ResourceLocation("exnihilosequentia", EXNItems.URANIUM.getIngotId()), consumer);
        this.createOreRecipes(EXNItems.ZINC, new ResourceLocation("exnihilosequentia", EXNItems.ZINC.getIngotId()), consumer);
    }

    private void addSieves(Consumer<FinishedRecipe> consumer) {
        this.createSieve(consumer, EXNBlocks.ACACIA_SIEVE, Items.f_42795_, Items.f_41918_);
        this.createSieve(consumer, EXNBlocks.BAMBOO_SIEVE, Items.f_243694_, Items.f_243860_);
        this.createSieve(consumer, EXNBlocks.BIRCH_SIEVE, Items.f_42753_, Items.f_41916_);
        this.createSieve(consumer, EXNBlocks.CHERRY_SIEVE, Items.f_271154_, Items.f_271349_);
        this.createSieve(consumer, EXNBlocks.DARK_OAK_SIEVE, Items.f_42796_, Items.f_41919_);
        this.createSieve(consumer, EXNBlocks.JUNGLE_SIEVE, Items.f_42794_, Items.f_41917_);
        this.createSieve(consumer, EXNBlocks.MANGROVE_SIEVE, Items.f_220174_, Items.f_220183_);
        this.createSieve(consumer, EXNBlocks.OAK_SIEVE, Items.f_42647_, Items.f_41914_);
        this.createSieve(consumer, EXNBlocks.SPRUCE_SIEVE, Items.f_42700_, Items.f_41915_);
        this.createSieve(consumer, EXNBlocks.CRIMSON_SIEVE, Items.f_42797_, Items.f_41920_);
        this.createSieve(consumer, EXNBlocks.WARPED_SIEVE, Items.f_42798_, Items.f_41921_);
    }

    private void addCrucibles(Consumer<FinishedRecipe> consumer) {
        this.createCrucible(consumer, EXNBlocks.ACACIA_CRUCIBLE, Items.f_41841_, Items.f_41918_);
        this.createCrucible(consumer, EXNBlocks.BAMBOO_CRUCIBLE, Items.f_256933_, Items.f_243860_);
        this.createCrucible(consumer, EXNBlocks.BIRCH_CRUCIBLE, Items.f_41839_, Items.f_41916_);
        this.createCrucible(consumer, EXNBlocks.CHERRY_CRUCIBLE, Items.f_271090_, Items.f_271349_);
        this.createCrucible(consumer, EXNBlocks.DARK_OAK_CRUCIBLE, Items.f_41842_, Items.f_41919_);
        this.createCrucible(consumer, EXNBlocks.JUNGLE_CRUCIBLE, Items.f_41840_, Items.f_41917_);
        this.createCrucible(consumer, EXNBlocks.MANGROVE_CRUCIBLE, Items.f_220179_, Items.f_220183_);
        this.createCrucible(consumer, EXNBlocks.OAK_CRUCIBLE, Items.f_41837_, Items.f_41914_);
        this.createCrucible(consumer, EXNBlocks.SPRUCE_CRUCIBLE, Items.f_41838_, Items.f_41915_);
        this.createCrucible(consumer, EXNBlocks.CRIMSON_CRUCIBLE, Items.f_41843_, Items.f_41920_);
        this.createCrucible(consumer, EXNBlocks.WARPED_CRUCIBLE, Items.f_41844_, Items.f_41921_);
    }

    private void addBarrels(Consumer<FinishedRecipe> consumer) {
        this.createBarrel(consumer, EXNBlocks.STONE_BARREL, (TagKey<Item>)Tags.Items.STONE, Items.f_41922_);
        this.createBarrel(consumer, EXNBlocks.ACACIA_BARREL, Items.f_42795_, Items.f_41918_);
        this.createBarrel(consumer, EXNBlocks.BAMBOO_BARREL, Items.f_243694_, Items.f_243860_);
        this.createBarrel(consumer, EXNBlocks.BIRCH_BARREL, Items.f_42753_, Items.f_41916_);
        this.createBarrel(consumer, EXNBlocks.CHERRY_BARREL, Items.f_271154_, Items.f_271349_);
        this.createBarrel(consumer, EXNBlocks.DARK_OAK_BARREL, Items.f_42796_, Items.f_41919_);
        this.createBarrel(consumer, EXNBlocks.JUNGLE_BARREL, Items.f_42794_, Items.f_41917_);
        this.createBarrel(consumer, EXNBlocks.MANGROVE_BARREL, Items.f_220174_, Items.f_220183_);
        this.createBarrel(consumer, EXNBlocks.OAK_BARREL, Items.f_42647_, Items.f_41914_);
        this.createBarrel(consumer, EXNBlocks.SPRUCE_BARREL, Items.f_42700_, Items.f_41915_);
        this.createBarrel(consumer, EXNBlocks.CRIMSON_BARREL, Items.f_42797_, Items.f_41920_);
        this.createBarrel(consumer, EXNBlocks.WARPED_BARREL, Items.f_42798_, Items.f_41921_);
    }

    private void addPebbleBlocks(Consumer<FinishedRecipe> consumer) {
        this.createPebbleBlock(Blocks.f_50334_, EXNItems.PEBBLE_ANDESITE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_50137_, EXNItems.PEBBLE_BASALT.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_50730_, EXNItems.PEBBLE_BLACKSTONE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_50652_, EXNItems.PEBBLE_STONE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_152497_, EXNItems.PEBBLE_CALCITE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_152550_, EXNItems.PEBBLE_DEEPSLATE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_50228_, EXNItems.PEBBLE_DIORITE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_152537_, EXNItems.PEBBLE_DRIPSTONE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_50259_, EXNItems.PEBBLE_END_STONE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_50122_, EXNItems.PEBBLE_GRANITE.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_50134_, EXNItems.PEBBLE_NETHERRACK.m_5456_(), consumer);
        this.createPebbleBlock(Blocks.f_152496_, EXNItems.PEBBLE_TUFF.m_5456_(), consumer);
    }

    private void addCrooks(Consumer<FinishedRecipe> consumer) {
        this.createCrook(EXNItems.CROOK_ANDESITE.m_5456_(), EXNItems.PEBBLE_ANDESITE.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_BAMBOO.m_5456_(), Items.f_41911_, consumer);
        this.createCrook(EXNItems.CROOK_BASALT.m_5456_(), EXNItems.PEBBLE_BASALT.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_BLACKSTONE.m_5456_(), EXNItems.PEBBLE_BLACKSTONE.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_BONE.m_5456_(), (TagKey<Item>)Tags.Items.BONES, consumer);
        this.createCrook(EXNItems.CROOK_CALCITE.m_5456_(), EXNItems.PEBBLE_CALCITE.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_CHERRY.m_5456_(), Items.f_271154_, consumer);
        this.createCrook(EXNItems.CROOK_COPPER.m_5456_(), ExNihiloTags.NUGGET_COPPER, consumer);
        this.createCrook(EXNItems.CROOK_DEEPSLATE.m_5456_(), EXNItems.PEBBLE_DEEPSLATE.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_DIAMOND.m_5456_(), (TagKey<Item>)Tags.Items.GEMS_DIAMOND, consumer);
        this.createCrook(EXNItems.CROOK_DIORITE.m_5456_(), EXNItems.PEBBLE_DIORITE.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_DRIPSTONE.m_5456_(), EXNItems.PEBBLE_DRIPSTONE.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_GOLD.m_5456_(), (TagKey<Item>)Tags.Items.NUGGETS_GOLD, consumer);
        this.createCrook(EXNItems.CROOK_GRANITE.m_5456_(), EXNItems.PEBBLE_GRANITE.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_IRON.m_5456_(), (TagKey<Item>)Tags.Items.NUGGETS_IRON, consumer);
        this.createCrook(EXNItems.CROOK_NETHER_BRICK.m_5456_(), Items.f_42095_, consumer);
        SmithingTransformRecipeBuilder.m_266555_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_265918_}), (Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{EXNItems.CROOK_DIAMOND.m_5456_()}), (Ingredient)Ingredient.m_204132_((TagKey)Tags.Items.INGOTS_NETHERITE), (RecipeCategory)RecipeCategory.TOOLS, (Item)EXNItems.CROOK_NETHERITE.m_5456_()).m_266439_("has_diamond_crook", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{EXNItems.CROOK_DIAMOND.m_5456_()})).m_266439_(MATERIAL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.INGOTS_NETHERITE).m_45077_()})).m_266371_(consumer, RecipeProviderUtilities.createSaveLocation(new ResourceLocation("exnihilosequentia", ExNihiloConstants.Items.NETHERITE_CROOK)));
        this.createCrook(EXNItems.CROOK_RED_NETHER_BRICK.m_5456_(), Items.f_42261_, consumer);
        this.createCrook(EXNItems.CROOK_STONE.m_5456_(), EXNItems.PEBBLE_STONE.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_TERRACOTTA.m_5456_(), Items.f_42199_, consumer);
        this.createCrook(EXNItems.CROOK_TUFF.m_5456_(), EXNItems.PEBBLE_TUFF.m_5456_(), consumer);
        this.createCrook(EXNItems.CROOK_WOOD.m_5456_(), (TagKey<Item>)Tags.Items.RODS_WOODEN, consumer);
    }

    private void createCrook(Item result, Item input, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("xx").m_126130_(" x").m_126130_(" x").m_126127_(Character.valueOf('x'), (ItemLike)input).m_126145_("exnihilosequentia").m_126132_(PEBBLE_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)result))));
    }

    private void createCrook(Item result, TagKey<Item> input, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)result).m_126130_("xx").m_126130_(" x").m_126130_(" x").m_206416_(Character.valueOf('x'), input).m_126145_("exnihilosequentia").m_126132_(PEBBLE_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(input).m_45077_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)result))));
    }

    private void createPebbleBlock(Block result, Item input, Consumer<FinishedRecipe> consumer) {
        ResourceLocation resourceLocation = ForgeRegistries.BLOCKS.getKey((Object)result);
        if (resourceLocation == null) {
            return;
        }
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.BUILDING_BLOCKS, (ItemLike)result).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)input).m_126145_("exnihilosequentia").m_126132_(PEBBLE_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(resourceLocation));
    }

    private void createBarrel(Consumer<FinishedRecipe> consumer, BlockDefinition<BarrelBlock> barrel, TagKey<Item> block, Item slab) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)barrel.block()).m_126130_("x x").m_126130_("x x").m_126130_("x-x").m_206416_(Character.valueOf('x'), block).m_126127_(Character.valueOf('-'), (ItemLike)slab).m_126145_("exnihilosequentia").m_126132_("has_walls", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(block).m_45077_()})).m_126132_("has_base", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{slab})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(barrel.getId()));
    }

    private void createBarrel(Consumer<FinishedRecipe> consumer, BlockDefinition<BarrelBlock> barrel, Item block, Item slab) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)barrel.block()).m_126130_("x x").m_126130_("x x").m_126130_("x-x").m_126127_(Character.valueOf('x'), (ItemLike)block).m_126127_(Character.valueOf('-'), (ItemLike)slab).m_126145_("exnihilosequentia").m_126132_("has_walls", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126132_("has_base", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{slab})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(barrel.getId()));
    }

    private void createCrucible(Consumer<FinishedRecipe> consumer, BlockDefinition<CrucibleBlock> crucible, Item block, Item slab) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)crucible.block()).m_126130_("c c").m_126130_("clc").m_126130_("s s").m_126127_(Character.valueOf('c'), (ItemLike)block).m_126127_(Character.valueOf('l'), (ItemLike)slab).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126145_("exnihilosequentia").m_126132_("has_logs", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(crucible.getId()));
    }

    private void createCrucible(Consumer<FinishedRecipe> consumer, BlockDefinition<CrucibleBlock> crucible, TagKey<Item> block, TagKey<Item> slab) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)crucible.block()).m_126130_("c c").m_126130_("clc").m_126130_("s s").m_206416_(Character.valueOf('c'), block).m_206416_(Character.valueOf('l'), slab).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126145_("exnihilosequentia").m_126132_("has_logs", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(block).m_45077_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(crucible.getId()));
    }

    private void createSieve(Consumer<FinishedRecipe> consumer, BlockDefinition<SieveBlock> sieve, Item block, Item slab) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, sieve).m_126130_("p p").m_126130_("plp").m_126130_("s s").m_126127_(Character.valueOf('p'), (ItemLike)block).m_126127_(Character.valueOf('l'), (ItemLike)slab).m_206416_(Character.valueOf('s'), Tags.Items.RODS_WOODEN).m_126132_("has_plank", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{block})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(sieve.getId()));
    }

    private void createOre(Ore ore, Consumer<FinishedRecipe> consumer) {
        this.createRawRecipe(ore, consumer);
        this.createNuggetRecipes(ore, consumer);
    }

    private void createRawRecipe(Ore ore, Consumer<FinishedRecipe> consumer) {
        OreItem piece = ore.getPieceItem();
        Either<ItemDefinition<OreItem>, Item> rawEither = ore.getRawOreItem();
        Item rawOre = rawEither.left().isPresent() ? ((ItemDefinition)rawEither.left().get()).m_5456_() : (Item)rawEither.right().get();
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)rawOre).m_126130_("xx").m_126130_("xx").m_126127_(Character.valueOf('x'), (ItemLike)piece).m_126145_("exnihilosequentia").m_126132_("has_piece", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{piece})).m_126140_(consumer, new ResourceLocation("exnihilosequentia", RecipeProviderUtilities.prependRecipePrefix(ForgeRegistries.ITEMS.getKey((Object)rawOre).m_135815_())));
    }

    private void createNuggetRecipes(Ore ore, Consumer<FinishedRecipe> consumer) {
        if (ore.getNuggetItem().left().isPresent()) {
            Either<ItemDefinition<OreItem>, Item> eitherIngot = ore.getIngotItem();
            Item ingot = eitherIngot.left().isPresent() ? ((ItemDefinition)eitherIngot.left().get()).m_5456_() : (Item)eitherIngot.right().get();
            Item nugget = ((ItemDefinition)ore.getNuggetItem().left().get()).m_5456_();
            ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)ingot).m_126130_("xxx").m_126130_("xxx").m_126130_("xxx").m_126127_(Character.valueOf('x'), (ItemLike)nugget).m_126145_("exnihilosequentia").m_126132_("has_nugget", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{nugget})).m_126140_(consumer, new ResourceLocation("exnihilosequentia", RecipeProviderUtilities.prependRecipePrefix(ForgeRegistries.ITEMS.getKey((Object)ingot).m_135815_() + "_from_nugget")));
            ShapelessRecipeBuilder.m_246517_((RecipeCategory)RecipeCategory.MISC, (ItemLike)nugget, (int)9).m_126209_((ItemLike)ingot).m_126132_("has_ingot", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{ingot})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(ForgeRegistries.ITEMS.getKey((Object)nugget)));
        }
    }

    private void createOreRecipes(Ore ore, ResourceLocation registryId, Consumer<FinishedRecipe> consumer) {
        this.createOre(ore, consumer);
        if (ore.getRawOreItem().left().isPresent() && ore.getIngotItem().left().isPresent()) {
            this.createSmeltingRecipe(consumer, ((ItemDefinition)ore.getRawOreItem().left().get()).m_5456_(), ((ItemDefinition)ore.getIngotItem().left().get()).m_5456_(), 0.7f, 200, 0.7f, 100, CHUNK_CONDITION, registryId);
        }
    }

    private void createSmeltingRecipe(Consumer<FinishedRecipe> consumer, Item input, Item output, float xpSmelt, int durationSmelt, float xpBlast, int durationBlast, String condition, ResourceLocation rl) {
        SimpleCookingRecipeBuilder.m_246179_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpSmelt, (int)durationSmelt).m_126132_(condition, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(rl));
        SimpleCookingRecipeBuilder.m_245681_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpBlast, (int)durationBlast).m_126132_(condition, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(new ResourceLocation(rl + "_blast")));
    }

    private void createHammer(Item output, Item input, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).m_126130_(" x ").m_126130_(" -x").m_126130_("-  ").m_126127_(Character.valueOf('x'), (ItemLike)input).m_206416_(Character.valueOf('-'), Tags.Items.RODS).m_126132_("has_stick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.RODS).m_45077_()})).m_126132_(MATERIAL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output))));
    }

    private void createHammer(Item output, TagKey<Item> input, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.TOOLS, (ItemLike)output).m_126130_(" x ").m_126130_(" -x").m_126130_("-  ").m_206416_(Character.valueOf('x'), input).m_206416_(Character.valueOf('-'), Tags.Items.RODS).m_126132_("has_stick", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(Tags.Items.RODS).m_45077_()})).m_126132_(MATERIAL_CONDITION, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(input).m_45077_()})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output))));
    }

    private void createMesh(Item output, Item inputMesh, TagKey<Item> inputItem, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).m_126130_("i i").m_126130_("imi").m_126130_("i i").m_206416_(Character.valueOf('i'), inputItem).m_126127_(Character.valueOf('m'), (ItemLike)inputMesh).m_126132_("has_mesh", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{inputMesh})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output))));
    }

    private void createMesh(Item output, Item inputMesh, Item inputItem, Consumer<FinishedRecipe> consumer) {
        ShapedRecipeBuilder.m_245327_((RecipeCategory)RecipeCategory.MISC, (ItemLike)output).m_126130_("i i").m_126130_("imi").m_126130_("i i").m_126127_(Character.valueOf('i'), (ItemLike)inputItem).m_126127_(Character.valueOf('m'), (ItemLike)inputMesh).m_126132_("has_mesh", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{inputMesh})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)output))));
    }

    private void createCookingRecipe(Consumer<FinishedRecipe> consumer, Item input, Item output, float xpCampfire, int durationCampfire, float xpSmoker, int durationSmoker, String condition, ResourceLocation rl) {
        SimpleCookingRecipeBuilder.m_247020_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpCampfire, (int)durationCampfire).m_126132_(condition, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(new ResourceLocation(rl + "_from_campfire")));
        SimpleCookingRecipeBuilder.m_246159_((Ingredient)Ingredient.m_43929_((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)output, (float)xpSmoker, (int)durationSmoker).m_126132_(condition, (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{input})).m_126140_(consumer, RecipeProviderUtilities.createSaveLocation(new ResourceLocation(rl + "_from_smoker")));
    }
}

